/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Device;
import com.amazonaws.services.devicefarm.model.transform.CPUJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ResolutionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DeviceJsonMarshaller {
    private static DeviceJsonMarshaller instance;

    public void marshall(Device device, JSONWriter jsonWriter) {
        if (device == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (device.getArn() != null) {
                jsonWriter.key("arn").value((Object)device.getArn());
            }
            if (device.getName() != null) {
                jsonWriter.key("name").value((Object)device.getName());
            }
            if (device.getManufacturer() != null) {
                jsonWriter.key("manufacturer").value((Object)device.getManufacturer());
            }
            if (device.getModel() != null) {
                jsonWriter.key("model").value((Object)device.getModel());
            }
            if (device.getFormFactor() != null) {
                jsonWriter.key("formFactor").value((Object)device.getFormFactor());
            }
            if (device.getPlatform() != null) {
                jsonWriter.key("platform").value((Object)device.getPlatform());
            }
            if (device.getOs() != null) {
                jsonWriter.key("os").value((Object)device.getOs());
            }
            if (device.getCpu() != null) {
                jsonWriter.key("cpu");
                CPUJsonMarshaller.getInstance().marshall(device.getCpu(), jsonWriter);
            }
            if (device.getResolution() != null) {
                jsonWriter.key("resolution");
                ResolutionJsonMarshaller.getInstance().marshall(device.getResolution(), jsonWriter);
            }
            if (device.getHeapSize() != null) {
                jsonWriter.key("heapSize").value((Object)device.getHeapSize());
            }
            if (device.getMemory() != null) {
                jsonWriter.key("memory").value((Object)device.getMemory());
            }
            if (device.getImage() != null) {
                jsonWriter.key("image").value((Object)device.getImage());
            }
            if (device.getCarrier() != null) {
                jsonWriter.key("carrier").value((Object)device.getCarrier());
            }
            if (device.getRadio() != null) {
                jsonWriter.key("radio").value((Object)device.getRadio());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeviceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeviceJsonMarshaller();
        }
        return instance;
    }
}

