/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CreateEventSourceMappingRequestMarshaller
implements Marshaller<Request<CreateEventSourceMappingRequest>, CreateEventSourceMappingRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<CreateEventSourceMappingRequest> marshall(CreateEventSourceMappingRequest createEventSourceMappingRequest) {
        if (createEventSourceMappingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createEventSourceMappingRequest, "AWSLambda");
        String target = "AWSLambda.CreateEventSourceMapping";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createEventSourceMappingRequest.getEventSourceArn() != null) {
                jsonWriter.key("EventSourceArn").value((Object)createEventSourceMappingRequest.getEventSourceArn());
            }
            if (createEventSourceMappingRequest.getFunctionName() != null) {
                jsonWriter.key("FunctionName").value((Object)createEventSourceMappingRequest.getFunctionName());
            }
            if (createEventSourceMappingRequest.isEnabled() != null) {
                jsonWriter.key("Enabled").value((Object)createEventSourceMappingRequest.isEnabled());
            }
            if (createEventSourceMappingRequest.getBatchSize() != null) {
                jsonWriter.key("BatchSize").value((Object)createEventSourceMappingRequest.getBatchSize());
            }
            if (createEventSourceMappingRequest.getStartingPosition() != null) {
                jsonWriter.key("StartingPosition").value((Object)createEventSourceMappingRequest.getStartingPosition());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "/2015-03-31/event-source-mappings/";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

