/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothisk.device.utils;

import com.baidubce.services.iothisk.device.model.DeviceSdkType;

public class CounterUtils {
    private static final long RTC_COUNTER_INTERVAL = 120L;

    public static void validCounter(DeviceSdkType deviceSdkType, long counter, long currentCounter) {
        switch (deviceSdkType) {
            case NONE_RTC: {
                if (counter > currentCounter) break;
                throw new IllegalArgumentException("Expired message");
            }
            case RTC: {
                if (Math.abs(currentCounter - counter) <= 120L) break;
                throw new IllegalArgumentException("Expired message");
            }
            case NONE_COUNTER: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown device key sdk type");
            }
        }
    }
}

