/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.visitors.helpers;

import com.github.curiousoddman.rgxgen.model.SymbolRange;
import com.github.curiousoddman.rgxgen.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.util.chars.CharList;
import java.util.Arrays;
import java.util.List;

public class SymbolSetIndexer {
    private final CharList symbols;
    private final List<SymbolRange> symbolRanges;
    private final int[] rangeOffsets;
    private final int size;

    public SymbolSetIndexer(SymbolSet symbolSet) {
        this.symbols = symbolSet.getSymbols();
        this.symbolRanges = symbolSet.getSymbolRanges();
        int tmpSize = this.symbols.size();
        int rangesCount = this.symbolRanges.size();
        if (rangesCount > 0) {
            int currentOffset;
            this.rangeOffsets = new int[rangesCount];
            this.rangeOffsets[0] = currentOffset = 0;
            for (int i = 0; i < rangesCount - 1; ++i) {
                int offset;
                SymbolRange symbolRange = this.symbolRanges.get(i);
                int rangeSize = symbolRange.size();
                tmpSize += rangeSize;
                this.rangeOffsets[i + 1] = offset = currentOffset + rangeSize;
                currentOffset = offset;
            }
            tmpSize += this.symbolRanges.get(rangesCount - 1).size();
        } else {
            this.rangeOffsets = new int[0];
        }
        this.size = tmpSize;
    }

    public int size() {
        return this.size;
    }

    public char[] getAll() {
        char[] chars = new char[this.size];
        for (int i = 0; i < this.size; ++i) {
            chars[i] = this.get(i);
        }
        return chars;
    }

    public char get(int seed) {
        if (seed < this.symbols.size()) {
            return this.symbols.get(seed);
        }
        if ((seed -= this.symbols.size()) == 0) {
            return (char)this.symbolRanges.get(0).from();
        }
        int i = this.findRangeIndex(seed);
        int offset = this.rangeOffsets[i];
        return (char)(this.symbolRanges.get(i).from() + seed - offset);
    }

    private int findRangeIndex(int seed) {
        int i = Arrays.binarySearch(this.rangeOffsets, seed);
        if (i > 0) {
            return i;
        }
        return -i - 2;
    }
}

