/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.UUID;

public class ProxiedServeEventFilters
implements Predicate<ServeEvent> {
    @JsonUnwrapped
    private final RequestPattern filters;
    @JsonUnwrapped
    private final List<UUID> ids;
    @JsonUnwrapped
    private final boolean allowNonProxied;

    public ProxiedServeEventFilters() {
        this(null, null, false);
    }

    @JsonCreator
    public ProxiedServeEventFilters(@JsonProperty(value="filters") RequestPattern filters, @JsonProperty(value="ids") List<UUID> ids, @JsonProperty(value="allowNonProxied") boolean allowNonProxied) {
        this.filters = filters;
        this.ids = ids;
        this.allowNonProxied = allowNonProxied;
    }

    public boolean apply(ServeEvent serveEvent) {
        if (!serveEvent.getResponseDefinition().isProxyResponse() && !this.allowNonProxied) {
            return false;
        }
        if (this.filters != null && !this.filters.match(serveEvent.getRequest()).isExactMatch()) {
            return false;
        }
        return this.ids == null || this.ids.contains(serveEvent.getId());
    }
}

