/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.impl;

import com.ibm.db2.cmx.CMXException;
import com.ibm.db2.cmx.ProductInformation;
import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.internal.Service;
import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.internal.monitor.MonitorAgent;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Properties;

public class ConfigurationValidator {
    PrintWriter printWriter_ = null;
    int timeout_ = 5;

    public ConfigurationValidator(int n2, PrintWriter printWriter) {
        this.timeout_ = n2;
        this.printWriter_ = printWriter;
    }

    public ProductInformation.Server getServerProductInformation(String string) throws CMXException {
        ControllerAgent controllerAgent = this.getControllerAgent(string);
        ProductInformation.Server server = null;
        if (controllerAgent != null) {
            try {
                controllerAgent.registerDriverOverNetwork(null, null, null, -1L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.printWriter_ != null) {
                    exception.printStackTrace(this.printWriter_);
                }
                throw new CMXException(exception, 3);
            }
            finally {
                try {
                    controllerAgent.close();
                }
                catch (Exception exception) {}
            }
            server = ControlDriver.getInstance().getServerProductInformation();
            if (server == null) {
                throw new CMXException(4);
            }
        }
        return server;
    }

    public ArrayList<Profile> getServerProfileCache(String string) throws CMXException {
        throw new CMXException(100);
    }

    public boolean isLocalPortAvailable(int n2) {
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.socket().bind(new InetSocketAddress(n2));
            serverSocketChannel.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isControllerAvailable(String string) {
        boolean bl2;
        block3: {
            ControllerAgent controllerAgent = this.getControllerAgent(string);
            boolean bl3 = bl2 = controllerAgent != null;
            if (controllerAgent != null) {
                try {
                    controllerAgent.close();
                }
                catch (Exception exception) {
                    if (this.printWriter_ == null) break block3;
                    exception.printStackTrace(this.printWriter_);
                }
            }
        }
        return bl2;
    }

    public boolean isMonitorAvailable(String string, String string2, int n2, String string3) {
        boolean bl2;
        block7: {
            ControllerAgent controllerAgent = this.getControllerAgent(string);
            bl2 = false;
            if (controllerAgent != null) {
                try {
                    ControlDataSourceImpl controlDataSourceImpl = new ControlDataSourceImpl(Service.getControllerType(string), null, null, string2, Integer.toString(n2), string3, false, null, null);
                    controllerAgent.lookupOverNetwork(controlDataSourceImpl);
                    Properties properties = controlDataSourceImpl.getOverrides();
                    if (this.printWriter_ != null) {
                        this.printWriter_.println("lookup results = " + String.valueOf(properties));
                    }
                    String string4 = properties.getProperty("monitorServerName");
                    String string5 = properties.getProperty("monitorPort");
                    String string6 = properties.getProperty("monitorCollectionInterval");
                    String string7 = properties.getProperty("monitorEnabled");
                    if (string7 != null && string7.equals("1")) {
                        MonitorAgent monitorAgent = Service.getMonitorAgent(false, null, 12, string4, Integer.parseInt(string5), Integer.parseInt(string6), null, null, null, null, null, null);
                        monitorAgent.getConnection();
                        if (this.printWriter_ != null) {
                            this.printWriter_.println("ma.isConnectionActive ()=" + monitorAgent.isConnectionActive());
                        }
                        if (monitorAgent.isConnectionActive()) {
                            bl2 = true;
                        }
                        monitorAgent.close();
                    }
                    controllerAgent.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (this.printWriter_ == null) break block7;
                    exception.printStackTrace(this.printWriter_);
                }
            }
        }
        return bl2;
    }

    private ControllerAgent getControllerAgent(String string) {
        if (string != null) {
            if (this.printWriter_ != null) {
                this.printWriter_.println("using controllerURL = " + string);
            }
        } else {
            if (this.printWriter_ != null) {
                this.printWriter_.println("controllerURL not found");
            }
            return null;
        }
        ControllerAgent controllerAgent = Service.getControllerAgent(string, true);
        if (controllerAgent.isConnected()) {
            if (this.printWriter_ != null) {
                this.printWriter_.println("Successfully connected to the controller");
            }
            return controllerAgent;
        }
        if (this.printWriter_ != null) {
            this.printWriter_.println("Unable to connect to the controller");
        }
        return null;
    }
}

