/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.controller;

import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.MonitorInterface;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.TransportPoolStatistics;
import com.ibm.db2.cmx.internal.Service;
import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.internal.controller.ControllerMessageHelper;
import com.ibm.db2.cmx.internal.controller.ControllerProcessorAS;
import com.ibm.db2.cmx.internal.core.CMXConnection;
import com.ibm.db2.cmx.internal.core.CMXConnectionFactory;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.monitor.MonitorAgentImpl;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.net.InetSocketAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ControllerAgentImpl
implements ControllerAgent {
    private CMXConnection cmxConnection_;
    private InetSocketAddress fixedControllerAddress_;
    private static Logger logger__ = Log.getCMXClientLogger();
    private long lastFixedLookupConnectRetryTime_ = 0L;
    private long fixedLookupConnectRetryInterval_ = Integer.parseInt(DataProperties.getProperty("pdq.cmx.dataSourceLookupInterval")) * 60 * 1000;

    public ControllerAgentImpl(String string, boolean bl2) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "<init>", "ENTRY " + Arrays.deepToString(new Object[]{string, bl2}));
        }
        this.initializeFixedAddress(string);
        if (bl2) {
            if (this.fixedControllerAddress_ == null) {
                return;
            }
            this.connectUsingFixedAddressWithCurrentThread();
        }
    }

    @Override
    public void close() throws Exception {
        this.cmxConnection_.close();
    }

    @Override
    public boolean isConnected() {
        return this.cmxConnection_ != null && this.cmxConnection_.isConnected();
    }

    @Override
    public synchronized void lookupOverNetwork(ControlDataSourceImpl controlDataSourceImpl) throws Exception {
        if (!this.isConnected()) {
            this.retryConnectForDataSourceLookup();
            if (this.isConnected() && controlDataSourceImpl.getControllerType() == Service.ControllerType.OPM) {
                if (controlDataSourceImpl.registeredDatasourceOPM_ != null) {
                    if (controlDataSourceImpl.registeredDatasourceOPM_.monitorAgent_ != null && !((MonitorAgentImpl)controlDataSourceImpl.registeredDatasourceOPM_.monitorAgent_).isConnected()) {
                        controlDataSourceImpl.registeredDatasourceOPM_.monitorAgent_.setReconnectFlag(true);
                        if (logger__.isLoggable(Level.CONFIG)) {
                            DataLogger.logControlDataSource(logger__, this, "lookupOverNetwork : reconnect flag set to true", controlDataSourceImpl);
                        }
                    }
                } else if (logger__.isLoggable(Level.SEVERE)) {
                    DataLogger.logControlDataSource(logger__, this, "lookupOverNetwork : cds does not have a reference to registeredDataSource for OPM", controlDataSourceImpl);
                }
            }
        }
        if (this.isConnected()) {
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "lookupOverNetwork", "Sending remote property lookup request for " + controlDataSourceImpl.getLogicalName() + ", " + controlDataSourceImpl.getMonitoredServerName() + ", " + controlDataSourceImpl.getMonitoredPortNumber() + ", " + controlDataSourceImpl.getMonitoredDatabaseName() + ", " + controlDataSourceImpl.getMonitoredLocationName());
            }
            ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
            Message message = this.cmxConnection_.sendRequest(controllerMessageHelper.createLookupRequest(controlDataSourceImpl.getLogicalName(), controlDataSourceImpl.getMonitoredServerName(), controlDataSourceImpl.getMonitoredServerHostname(), controlDataSourceImpl.getMonitoredPortNumber(), controlDataSourceImpl.getMonitoredDatabaseName(), controlDataSourceImpl.getMonitoredLocationName(), this.cmxConnection_.getNegotiatedProcessorVersion("ClientPropertyProcessor")));
            controllerMessageHelper.parseLookupReply(message, controlDataSourceImpl, null);
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logControlDataSource(logger__, this, "lookupOverNetwork", controlDataSourceImpl);
                DataLogger.exit(logger__, this, "lookupOverNetwork", controlDataSourceImpl);
            }
        } else {
            controlDataSourceImpl.init(null, null, -1);
        }
    }

    private void connectUsingFixedAddressWithCurrentThread() {
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "connectUsingFixedAddressWithCurrentThread", "Attempting to connect to a controller server using the pdq.cmx.controllerURL property fixed address: " + this.fixedControllerAddress_);
        }
        this.createConnection(this.fixedControllerAddress_);
    }

    @Override
    public void registerMonitorDataSource(String string, String string2, String[] stringArray, int n2, String string3, String[] stringArray2, int n3, int n4, int n5, int n6, boolean bl2, int[] nArray, String[] stringArray3, String string4, int n7, int n8) throws Exception {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "registerMonitorDataSource", "ENTRY " + Arrays.deepToString(new Object[]{string, string2, stringArray, n2, string3, stringArray2, n3, nArray, n5, n6, bl2, nArray, stringArray3, string4, n7}));
        }
        this.connectToControllerUsingCurrentThread();
        this.checkPreconditions();
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "registerMonitorDataSource", "Sending register monitor datasource request");
        }
        this.cmxConnection_.sendRequest(controllerMessageHelper.createRegisterRequest(string, string2, Configuration.resolveToIPAddress(string2), Configuration.resolveHostname(string2), stringArray, n2 + "", string3, stringArray2, n3, n4, n5, n6, bl2, nArray, stringArray3, string4, n7, this.getNegotiatedVersion(), n8));
    }

    @Override
    public void deregisterMonitorDataSource(String string, String string2, int n2, String string3, String string4, int n3) throws Exception {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "deregisterMonitorDataSource", "ENTRY " + Arrays.deepToString(new Object[]{string, string2, n2, string3, string4}));
        }
        this.connectToControllerUsingCurrentThread();
        this.checkPreconditions();
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "deregisterMonitorDataSource", "Sending deregister monitor datasource request");
        }
        this.cmxConnection_.sendRequest(controllerMessageHelper.createDeregisterRequest(string, string2, Configuration.resolveHostname(string2), n2 + "", string3, string4, n3, this.getNegotiatedVersion()));
    }

    private void connectToControllerUsingCurrentThread() throws Exception {
        if (!this.isConnected() && null != this.fixedControllerAddress_) {
            this.connectUsingFixedAddressWithCurrentThread();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private void initializeFixedAddress(String string) {
        if (string != null) {
            this.fixedControllerAddress_ = this.getAddress(string);
        }
    }

    private InetSocketAddress getAddress(String string) {
        try {
            String string2 = string;
            int n2 = 0;
            int n3 = string.lastIndexOf(58);
            if (n3 > 0) {
                string2 = string.substring(0, n3);
                n2 = Integer.valueOf(string.substring(n3 + 1).trim());
            }
            return new InetSocketAddress(string2, n2);
        }
        catch (NumberFormatException numberFormatException) {
            DataLogger.lowImpactLogger(logger__, this, "getAddress", "Invalid number format when parsing controllerURL: '" + string + "'", numberFormatException);
            return null;
        }
    }

    private void retryConnectForDataSourceLookup() {
        long l8;
        if (this.fixedControllerAddress_ != null && (double)(l8 = System.currentTimeMillis()) >= (double)this.lastFixedLookupConnectRetryTime_ + (double)this.fixedLookupConnectRetryInterval_ * 0.8) {
            this.lastFixedLookupConnectRetryTime_ = l8;
            this.createConnection(this.fixedControllerAddress_);
        }
    }

    private void createConnection(InetSocketAddress inetSocketAddress) {
        CMXConnection cMXConnection;
        try {
            cMXConnection = CMXConnectionFactory.getSharedConnection(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        }
        catch (Exception exception) {
            DataLogger.lowImpactLogger(logger__, this, "createConnection", "WARNING: Failed to establish a socket connection to controller server at " + inetSocketAddress, exception);
            return;
        }
        int n2 = cMXConnection.connectToProcessor(new ControllerProcessorAS());
        if (n2 != -1) {
            this.cmxConnection_ = cMXConnection;
            if (logger__.isLoggable(Level.CONFIG)) {
                DataLogger.logConfigHighVis(logger__, this, "createConnection", "Successfully connected to a controller server at " + inetSocketAddress, false);
            }
        } else {
            try {
                cMXConnection.close();
            }
            catch (Exception exception) {
                DataLogger.logTrappedMonitoringException(logger__, this, "createConnection", exception, null);
            }
            if (logger__.isLoggable(Level.CONFIG)) {
                DataLogger.lowImpactLogger(logger__, this, "createConnection", "WARNING: Incompatible controller server version.  Did not successfully connect to a compatible controller server at " + inetSocketAddress, null);
            }
        }
    }

    private void checkPreconditions() throws Exception {
        if (this.cmxConnection_ == null || !this.cmxConnection_.isConnected()) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_MONITOR_UNABLE_TO_CONNECT_TO_CONTOLLER", new Object[0]), null, 10625);
        }
    }

    @Override
    public void getControllerInfo(StringBuilder stringBuilder) {
        if (this.cmxConnection_ != null) {
            stringBuilder.append("    Controller Agent Connection URL: " + this.cmxConnection_.getUrl() + "\n    Controller Agent Connection Active: " + this.isConnected() + "\n");
        } else {
            stringBuilder.append("    No controller connection.\n");
        }
    }

    @Override
    public void registerDriverOverNetwork(Map<String, Object> map, String string, String string2, long l8) throws Exception {
    }

    @Override
    public void sendDeregisterDriver(String string) throws Exception {
    }

    @Override
    public void sendDeregisterDataSource(String string) throws Exception {
    }

    @Override
    public void sendAndReceiveChainedMessages(ArrayList<ControlDriver.RequestInfo> arrayList) throws Exception {
    }

    @Override
    public void logLookup(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) throws Exception {
    }

    @Override
    public void logStatistics(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String[] stringArray3, Set<ClientInfo>[] setArray, HashMap<String, TransportPoolStatistics> hashMap, long[][] lArray, Long[] longArray, Object[][] objectArray, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, long[][] lArray2) throws Exception {
    }

    @Override
    public void logPushDownErrors(String string, String string2, String string3, MonitorInterface.ClientRuntime clientRuntime, ArrayList<PushDownError> arrayList) throws Exception {
    }

    @Override
    public void logApplicationException(String string, String string2, String string3, MonitorInterface.ClientRuntime clientRuntime, SQLException sQLException) throws Exception {
    }

    @Override
    public void logPushDownApplication(String string, String string2, Map<String, Object> map, String string3, String string4, String string5, String string6, String[] stringArray, Map<String, Object>[] mapArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, HashMap<String, String>[] hashMapArray) throws Exception {
    }

    @Override
    public int getNegotiatedVersion() {
        if (this.cmxConnection_ != null) {
            return this.cmxConnection_.getNegotiatedProcessorVersion("ClientPropertyProcessor");
        }
        return -1;
    }
}

