/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.generator;

import com.ibm.db2.cmx.runtime.Data;
import com.ibm.db2.cmx.runtime.HeterogeneousBatchKind;
import com.ibm.db2.cmx.runtime.StoredProcedureResult;
import com.ibm.db2.cmx.runtime.data.handlers.BeanRowHandler;
import com.ibm.db2.cmx.runtime.data.handlers.ConstantRowHandler;
import com.ibm.db2.cmx.runtime.data.handlers.MapRowHandler;
import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.generator.GeneratorData;
import com.ibm.db2.cmx.runtime.generator.HandlerContainer;
import com.ibm.db2.cmx.runtime.generator.ParameterHandler;
import com.ibm.db2.cmx.runtime.handlers.CallHandler;
import com.ibm.db2.cmx.runtime.handlers.CallHandlerWithParameters;
import com.ibm.db2.cmx.runtime.handlers.ResultHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.runtime.statement.StatementDescriptor;
import com.ibm.db2.cmx.tools.DataVersion;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class BaseData
implements GeneratorData {
    protected Logger logger_;
    private GeneratorData generatorData_;
    private HashMap<String, StatementDescriptor> methodToStatementDescriptorMap = null;
    public static final int SINGLE_ROW_PARAMETERS = 1;
    public static final int MULTI_ROW_PARAMETERS = 2;
    public static final int NO_PARAMETERS = 3;
    public static final int SINGLE_ROW_RESULT = 4;
    public static final int MULTI_ROW_RESULT = 5;
    public static final int ALLOW_STATIC_ROWSET_CURSORS = 6;
    public static final int DISALLOW_STATIC_ROWSET_CURSORS = 7;
    private static final String runtimeVersion__ = DataVersion.getProductVersion();
    private static final int[] runtimeVersionParts__ = BaseData.getVersionParts(runtimeVersion__);

    public String getGeneratorVersion() {
        return "1.0.0";
    }

    public void checkCompatibleRuntimeVersion(String string) throws DataRuntimeException {
        int[] nArray;
        String string2 = runtimeVersion__;
        int[] nArray2 = runtimeVersionParts__;
        try {
            nArray = BaseData.getVersionParts(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_UNABLE_GEN_VCHECK", "pureQuery Runtime", "IBM InfoSphere Optim pureQuery Runtime", string, string2), numberFormatException, 10077);
        }
        if (nArray2[0] < nArray[0]) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_GEN_INCOMPAT_RUNTIME", string2, string), null, 10078);
        }
        if (nArray2[0] == nArray[0]) {
            if (nArray2[1] < nArray[1]) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_GEN_INCOMPAT_RUNTIME", string2, string), null, 10079);
            }
            if (nArray2[1] == nArray[1] && nArray2[2] < nArray[2]) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_GEN_INCOMPAT_RUNTIME", string2, string), null, 10080);
            }
        }
    }

    private static int[] getVersionParts(String string) throws NumberFormatException {
        int[] nArray = new int[]{0, 0, 0};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        if (stringTokenizer.hasMoreTokens()) {
            nArray[0] = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            nArray[1] = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            nArray[2] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return nArray;
    }

    public BaseData() {
        this.checkCompatibleRuntimeVersion(this.getGeneratorVersion());
    }

    @Override
    public <ROW> ROW[] queryArray(StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer, Class<ROW> clazz, Object ... objectArray) {
        return this.generatorData_.queryArray(statementDescriptor, handlerContainer, clazz, objectArray);
    }

    @Override
    public <ROW> ROW queryFirst(StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer, Object ... objectArray) {
        return this.generatorData_.queryFirst(statementDescriptor, handlerContainer, objectArray);
    }

    @Override
    public <ROW> Iterator<ROW> queryIterator(StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer, Object ... objectArray) {
        return this.generatorData_.queryIterator(statementDescriptor, handlerContainer, objectArray);
    }

    @Override
    public <ROW> List<ROW> queryList(StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer, Object ... objectArray) {
        return this.generatorData_.queryList(statementDescriptor, handlerContainer, objectArray);
    }

    @Override
    public ResultSet queryResults(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, Object ... objectArray) {
        return this.generatorData_.queryResults(statementDescriptor, handlerContainer, objectArray);
    }

    @Override
    public int update(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, Object ... objectArray) {
        return this.generatorData_.update(statementDescriptor, handlerContainer, objectArray);
    }

    @Override
    public <ROW> int update(ROW ROW, StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer, Object ... objectArray) {
        return this.generatorData_.update(ROW, statementDescriptor, handlerContainer, objectArray);
    }

    @Override
    public <T> int[] updateMany(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, Iterator<T> iterator) {
        return this.generatorData_.updateMany(statementDescriptor, handlerContainer, iterator);
    }

    @Override
    public <T> int[] updateMany(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, Iterable<T> iterable) {
        return this.generatorData_.updateMany(statementDescriptor, handlerContainer, iterable);
    }

    @Override
    public <T> int[] updateMany(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, T[] TArray) {
        return this.generatorData_.updateMany(statementDescriptor, handlerContainer, TArray);
    }

    @Override
    public void close() {
        this.generatorData_.close();
    }

    @Override
    public void commit() {
        this.generatorData_.commit();
    }

    @Override
    public boolean getAutoCommit() {
        return this.generatorData_.getAutoCommit();
    }

    @Override
    public Connection getConnection() {
        return this.generatorData_.getConnection();
    }

    @Override
    public <RES> RES query(String string, ResultHandler<RES> resultHandler, Object ... objectArray) {
        return this.generatorData_.query(string, resultHandler, objectArray);
    }

    @Override
    public <RES> RES query(StatementDescriptor statementDescriptor, HandlerContainer<? extends RES, ?, ?> handlerContainer, Object ... objectArray) {
        return this.generatorData_.query(statementDescriptor, handlerContainer, objectArray);
    }

    @Override
    public <RES> RES query(StatementDescriptor statementDescriptor, Object ... objectArray) {
        return this.generatorData_.query(statementDescriptor, (HandlerContainer)null, objectArray);
    }

    @Override
    public Map<String, Object>[] queryArray(String string, Object ... objectArray) {
        return this.generatorData_.queryArray(string, objectArray);
    }

    @Override
    public <ROW> ROW[] queryArray(String string, Class<ROW> clazz, Object ... objectArray) {
        return this.generatorData_.queryArray(string, clazz, objectArray);
    }

    @Override
    public <ROW> ROW[] queryArray(String string, Class<ROW> clazz, RowHandler<ROW> rowHandler, Object ... objectArray) {
        return this.generatorData_.queryArray(string, clazz, rowHandler, objectArray);
    }

    @Override
    public <ROW> ROW[] queryArray(StatementDescriptor statementDescriptor, Class<ROW> clazz, Object ... objectArray) {
        return this.generatorData_.queryArray(statementDescriptor, null, clazz, objectArray);
    }

    @Override
    @Deprecated
    public <ROW> ROW[] queryArray(String string, RowHandler<ROW> rowHandler, Object ... objectArray) {
        return this.generatorData_.queryArray(string, rowHandler, objectArray);
    }

    @Override
    public Map<String, Object> queryFirst(String string, Object ... objectArray) {
        return this.generatorData_.queryFirst(string, objectArray);
    }

    @Override
    public <ROW> ROW queryFirst(String string, Class<ROW> clazz, Object ... objectArray) {
        return this.generatorData_.queryFirst(string, clazz, objectArray);
    }

    @Override
    public <ROW> ROW queryFirst(String string, RowHandler<ROW> rowHandler, Object ... objectArray) {
        return this.generatorData_.queryFirst(string, rowHandler, objectArray);
    }

    @Override
    public <ROW> ROW queryFirst(StatementDescriptor statementDescriptor, Object ... objectArray) {
        return this.generatorData_.queryFirst(statementDescriptor, (HandlerContainer)null, objectArray);
    }

    @Override
    public Iterator<Map<String, Object>> queryIterator(String string, Object ... objectArray) {
        return this.generatorData_.queryIterator(string, objectArray);
    }

    @Override
    public <ROW> Iterator<ROW> queryIterator(String string, Class<ROW> clazz, Object ... objectArray) {
        return this.generatorData_.queryIterator(string, clazz, objectArray);
    }

    @Override
    public <ROW> Iterator<ROW> queryIterator(String string, RowHandler<ROW> rowHandler, Object ... objectArray) {
        return this.generatorData_.queryIterator(string, rowHandler, objectArray);
    }

    @Override
    public <ROW> Iterator<ROW> queryIterator(StatementDescriptor statementDescriptor, Object ... objectArray) {
        return this.generatorData_.queryIterator(statementDescriptor, null, objectArray);
    }

    @Override
    public List<Map<String, Object>> queryList(String string, Object ... objectArray) {
        return this.generatorData_.queryList(string, objectArray);
    }

    @Override
    public <ROW> List<ROW> queryList(String string, Class<ROW> clazz, Object ... objectArray) {
        return this.generatorData_.queryList(string, clazz, objectArray);
    }

    @Override
    public <ROW> List<ROW> queryList(String string, RowHandler<ROW> rowHandler, Object ... objectArray) {
        return this.generatorData_.queryList(string, rowHandler, objectArray);
    }

    @Override
    public <ROW> List<ROW> queryList(StatementDescriptor statementDescriptor, Object ... objectArray) {
        return this.generatorData_.queryList(statementDescriptor, null, objectArray);
    }

    @Override
    public ResultSet queryResults(String string, Object ... objectArray) {
        return this.generatorData_.queryResults(string, objectArray);
    }

    @Override
    public void rollback() {
        this.generatorData_.rollback();
    }

    @Override
    public void setAutoCommit(boolean bl2) {
        this.generatorData_.setAutoCommit(bl2);
    }

    @Override
    public int update(String string, Object ... objectArray) {
        return this.generatorData_.update(string, objectArray);
    }

    public <T> T update(String string, Class<T> clazz, String[] stringArray, Object ... objectArray) {
        return this.generatorData_.update(string, clazz, stringArray, objectArray);
    }

    @Override
    public <T> int[] updateMany(String string, Iterable<T> iterable) {
        return this.generatorData_.updateMany(string, iterable);
    }

    @Override
    public <T> int[] updateMany(String string, Iterator<T> iterator) {
        return this.generatorData_.updateMany(string, iterator);
    }

    @Override
    public <T> int[] updateMany(String string, T[] TArray) {
        return this.generatorData_.updateMany(string, TArray);
    }

    @Override
    public Data getData() {
        return this.generatorData_;
    }

    @Override
    public StatementDescriptor getStatementDescriptor(String string) {
        StatementDescriptor statementDescriptor = null;
        if (null == this.methodToStatementDescriptorMap) {
            this.fillMethodToStatementDescriptorMap();
        }
        if (null == (statementDescriptor = this.methodToStatementDescriptorMap.get(string))) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_STMT_DESC", string, string), null, 10081);
        }
        return statementDescriptor;
    }

    private void fillMethodToStatementDescriptorMap() {
        Field[] fieldArray;
        this.methodToStatementDescriptorMap = new HashMap();
        for (Field field : fieldArray = this.getFieldsForClass(this.getClass())) {
            if (!StatementDescriptor.class.isAssignableFrom(field.getType())) continue;
            try {
                String string;
                StatementDescriptor statementDescriptor = (StatementDescriptor)field.get(this);
                if (null != statementDescriptor) {
                    string = statementDescriptor.getMethodNameAndParameterTypesString();
                    if (null == string) {
                        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, "StatementDescriptor.getMethodNameAndParameterTypesString() returned null.  The value should have been set through the constructor when the StatementDescriptor instance was generated.  ", null, 10082);
                    }
                    if (this.methodToStatementDescriptorMap.containsKey(string)) {
                        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, "Unexpected value returned from StatementDescriptor.getMethodNameAndParameterTypesString().  The value: '" + string + "' was returned.  Two StatementDescriptor instances may be returning the same value from StatementDescriptor.getMethodNameAndParameterTypesString().  ", null, 10083);
                    }
                } else {
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, "The value of a StatementDescriptor field is null.  This value should have been set during generation.  ", null, 10084);
                }
                this.methodToStatementDescriptorMap.put(string, statementDescriptor);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, "Tried to access a field (probably of type StatementDescriptor) to which access is forbidden.  The field was probably declared as private or protected, and it should have been declared as public.  ", illegalAccessException, 10085);
            }
        }
    }

    @Override
    public void setData(Data data) {
        this.generatorData_ = (GeneratorData)data;
    }

    @Override
    public <CAL> CAL call(String string, CallHandler<CAL> callHandler, Object ... objectArray) {
        return this.generatorData_.call(string, callHandler, objectArray);
    }

    @Override
    public <CAL> CAL call(String string, CallHandlerWithParameters<CAL> callHandlerWithParameters, Object ... objectArray) {
        return this.generatorData_.call(string, callHandlerWithParameters, objectArray);
    }

    @Override
    public <CAL> CAL call(String string, com.ibm.db2.cmx.runtime.handlers.ParameterHandler parameterHandler, CallHandlerWithParameters<CAL> callHandlerWithParameters, Object ... objectArray) {
        return this.generatorData_.call(string, parameterHandler, callHandlerWithParameters, objectArray);
    }

    @Override
    public StoredProcedureResult call(String string, Object ... objectArray) {
        return this.generatorData_.call(string, objectArray);
    }

    @Override
    public <CAL> CAL call(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ? extends CAL> handlerContainer, Object ... objectArray) {
        return this.generatorData_.call(statementDescriptor, handlerContainer, objectArray);
    }

    @Override
    public <CAL> CAL call(StatementDescriptor statementDescriptor, Object ... objectArray) {
        return this.generatorData_.call(statementDescriptor, (HandlerContainer)null, objectArray);
    }

    @Override
    public int[] updateMany(String ... stringArray) {
        return this.generatorData_.updateMany(stringArray);
    }

    @Override
    public ResultSet queryResults(int n2, int n3, int n4, String string, Object ... objectArray) {
        return this.generatorData_.queryResults(n2, n3, n4, string, objectArray);
    }

    @Override
    public ResultSet queryResults(StatementDescriptor statementDescriptor, Object ... objectArray) {
        return this.generatorData_.queryResults(statementDescriptor, null, objectArray);
    }

    @Override
    public <ROW> Iterator<ROW> queryIterator(int n2, int n3, int n4, String string, RowHandler<ROW> rowHandler, Object ... objectArray) {
        return this.generatorData_.queryIterator(n2, n3, n4, string, rowHandler, objectArray);
    }

    @Override
    public <ROW> Iterator<ROW> queryIterator(int n2, int n3, int n4, String string, Class<ROW> clazz, Object ... objectArray) {
        return this.generatorData_.queryIterator(n2, n3, n4, string, clazz, objectArray);
    }

    @Override
    public Iterator<Map<String, Object>> queryIterator(int n2, int n3, int n4, String string, Object ... objectArray) {
        return this.generatorData_.queryIterator(n2, n3, n4, string, objectArray);
    }

    @Override
    public <RES> RES query(int n2, int n3, int n4, String string, ResultHandler<RES> resultHandler, Object ... objectArray) {
        return this.generatorData_.query(n2, n3, n4, string, resultHandler, objectArray);
    }

    @Override
    public <RES> RES query(int n2, int n3, int n4, String string, com.ibm.db2.cmx.runtime.handlers.ParameterHandler parameterHandler, ResultHandler<RES> resultHandler, Object ... objectArray) {
        return this.generatorData_.query(n2, n3, n4, string, parameterHandler, resultHandler, objectArray);
    }

    @Override
    public int update(StatementDescriptor statementDescriptor, Object ... objectArray) {
        return this.generatorData_.update(statementDescriptor, (HandlerContainer)null, objectArray);
    }

    @Override
    public <ROW> int update(ROW ROW, StatementDescriptor statementDescriptor, Object ... objectArray) {
        return this.generatorData_.update(ROW, statementDescriptor, null, objectArray);
    }

    @Override
    public <T> int[] updateMany(StatementDescriptor statementDescriptor, Iterator<T> iterator) {
        return this.generatorData_.updateMany(statementDescriptor, null, iterator);
    }

    @Override
    public <T> int[] updateMany(StatementDescriptor statementDescriptor, Iterable<T> iterable) {
        return this.generatorData_.updateMany(statementDescriptor, null, iterable);
    }

    @Override
    public <T> int[] updateMany(StatementDescriptor statementDescriptor, T[] TArray) {
        return this.generatorData_.updateMany(statementDescriptor, null, TArray);
    }

    public static final <T> T testNull(T t2, boolean bl2) {
        return bl2 ? null : (T)t2;
    }

    public StatementDescriptor getStatementDescriptor(String string, String string2, SqlStatementType sqlStatementType, int n2, Object[] objectArray) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, "Unsupported Method", null, 10086);
    }

    public static StatementDescriptor createStatementDescriptor(String string, String string2, int[] nArray, SqlStatementType sqlStatementType, String[] stringArray, com.ibm.db2.cmx.runtime.handlers.ParameterHandler parameterHandler, int[][] nArray2, ResultHandler resultHandler, RowHandler rowHandler, int[][] nArray3, CallHandlerWithParameters callHandlerWithParameters, String string3, long l8, String string4, boolean bl2, String string5, int n2) {
        return new StatementDescriptorImpl(string, string2, sqlStatementType, nArray, stringArray, parameterHandler, nArray2, resultHandler, rowHandler, nArray3, null, callHandlerWithParameters, string3, l8, string4, bl2, string5, n2, String.valueOf(n2));
    }

    public static StatementDescriptor createStatementDescriptor(String string, String string2, int[] nArray, SqlStatementType sqlStatementType, String[] stringArray, com.ibm.db2.cmx.runtime.handlers.ParameterHandler parameterHandler, int[][] nArray2, ResultHandler resultHandler, RowHandler rowHandler, int[][] nArray3, CallHandlerWithParameters callHandlerWithParameters, String string3, long l8, String string4, int n2) {
        return new StatementDescriptorImpl(string, string2, sqlStatementType, nArray, stringArray, parameterHandler, nArray2, resultHandler, rowHandler, nArray3, null, callHandlerWithParameters, string3, l8, string4, false, null, n2, String.valueOf(n2));
    }

    public static StatementDescriptor createStatementDescriptor(String string, String string2, int[] nArray, SqlStatementType sqlStatementType, String[] stringArray, com.ibm.db2.cmx.runtime.handlers.ParameterHandler parameterHandler, int[][] nArray2, RowHandler rowHandler, int[][] nArray3, CallHandlerWithParameters callHandlerWithParameters, String string3, long l8, String string4, int n2) {
        return new StatementDescriptorImpl(string, string2, sqlStatementType, nArray, stringArray, parameterHandler, nArray2, null, rowHandler, nArray3, null, callHandlerWithParameters, string3, l8, string4, false, null, n2, String.valueOf(n2));
    }

    public static StatementDescriptor createStatementDescriptor(String string, String string2, int[] nArray, SqlStatementType sqlStatementType, String[] stringArray, com.ibm.db2.cmx.runtime.handlers.ParameterHandler parameterHandler, int[][] nArray2, RowHandler rowHandler, int[][] nArray3, CallHandlerWithParameters callHandlerWithParameters, String string3, String string4, long l8, int n2) {
        return new StatementDescriptorImpl(string, string2, sqlStatementType, nArray, stringArray, parameterHandler, nArray2, rowHandler, nArray3, null, callHandlerWithParameters, string3, string4, l8, n2, String.valueOf(n2));
    }

    public static StatementDescriptor createStatementDescriptor(String string, String string2, SqlStatementType sqlStatementType, String[] stringArray, ParameterHandler parameterHandler, int[][] nArray, RowHandler rowHandler, int[][] nArray2, String string3, String string4, long l8, int n2) {
        return new StatementDescriptorImpl(string, string2, sqlStatementType, null, stringArray, parameterHandler, nArray, rowHandler, nArray2, null, null, string3, string4, l8, n2, String.valueOf(n2));
    }

    public static StatementDescriptor createStatementDescriptor(String string, String string2, SqlStatementType sqlStatementType, String[] stringArray, ParameterHandler parameterHandler, int[][] nArray, RowHandler rowHandler, int[][] nArray2, CallHandler callHandler, String string3, String string4, long l8, int n2) {
        return new StatementDescriptorImpl(string, string2, sqlStatementType, null, stringArray, parameterHandler, nArray, rowHandler, nArray2, callHandler, null, string3, string4, l8, n2, String.valueOf(n2));
    }

    @Override
    public Logger getLogger() {
        return this.logger_;
    }

    public void setLogger(Logger logger) {
        this.logger_ = logger;
    }

    @Override
    public int[][] endBatch() {
        return this.generatorData_.endBatch();
    }

    @Override
    public void cancelBatch() {
        this.generatorData_.cancelBatch();
    }

    @Override
    public HeterogeneousBatchKind getBatchKind() {
        return this.generatorData_.getBatchKind();
    }

    @Override
    public void startBatch(HeterogeneousBatchKind heterogeneousBatchKind) {
        this.generatorData_.startBatch(heterogeneousBatchKind);
    }

    private Field[] getFieldsForClass(Class clazz) {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(BaseData.getFields(clazz));
        }
        return BaseData.getFieldsNoSM(clazz);
    }

    private static Field[] getFieldsNoSM(Class clazz) {
        return clazz.getFields();
    }

    private static final PrivilegedAction<Field[]> getFields(final Class clazz) {
        return new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return BaseData.getFieldsNoSM(clazz);
            }
        };
    }

    protected static RowHandler<Map<String, Object>> getMapRowHandler() {
        return new MapRowHandler();
    }

    protected static <T> RowHandler<T> getBeanRowHandler(Class<T> clazz) {
        return new BeanRowHandler<T>(clazz);
    }

    protected static <T> RowHandler<T> getConstantRowHandler(Class<T> clazz) {
        return new ConstantRowHandler(clazz);
    }

    public static void checkDriverVersion(String string) {
        if (!Configuration.doesJccVersionSupportFeature(2)) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging(Messages.getText("ERR_JCC_PREREQUISITE_DAO_GETOBJECT_CLASS", string, "IBM Data Server Driver for JDBC and SQLJ", Configuration.JCCVersionAsString__, "4.18"), null, 11790);
        }
    }
}

