/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.tagging;

import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.properties.CaptionSide;
import com.itextpdf.layout.tagging.ITaggingRule;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import com.itextpdf.layout.tagging.TaggingDummyElement;
import com.itextpdf.layout.tagging.TaggingHintKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

class TableTaggingRule
implements ITaggingRule {
    TableTaggingRule() {
    }

    @Override
    public boolean onTagFinish(LayoutTaggingHelper taggingHelper, TaggingHintKey tableHintKey) {
        List<TaggingHintKey> kidKeys = taggingHelper.getAccessibleKidsHint(tableHintKey);
        TreeMap<Integer, TreeMap<Integer, TaggingHintKey>> tableTags = new TreeMap<Integer, TreeMap<Integer, TaggingHintKey>>();
        ArrayList<TaggingHintKey> tableCellTagsUnindexed = new ArrayList<TaggingHintKey>();
        ArrayList<TaggingHintKey> nonCellKids = new ArrayList<TaggingHintKey>();
        for (TaggingHintKey kidKey : kidKeys) {
            if ("TD".equals(kidKey.getAccessibleElement().getAccessibilityProperties().getRole()) || "TH".equals(kidKey.getAccessibleElement().getAccessibilityProperties().getRole())) {
                if (kidKey.getAccessibleElement() instanceof Cell) {
                    Cell cell = (Cell)kidKey.getAccessibleElement();
                    int rowInd = cell.getRow();
                    int colInd = cell.getCol();
                    TreeMap<Integer, TaggingHintKey> rowTags = (TreeMap<Integer, TaggingHintKey>)tableTags.get(rowInd);
                    if (rowTags == null) {
                        rowTags = new TreeMap<Integer, TaggingHintKey>();
                        tableTags.put(rowInd, rowTags);
                    }
                    rowTags.put(colInd, kidKey);
                    continue;
                }
                tableCellTagsUnindexed.add(kidKey);
                continue;
            }
            nonCellKids.add(kidKey);
        }
        boolean createTBody = true;
        if (tableHintKey.getAccessibleElement() instanceof Table) {
            Table modelElement = (Table)tableHintKey.getAccessibleElement();
            createTBody = modelElement.getHeader() != null && !modelElement.isSkipFirstHeader() || modelElement.getFooter() != null && !modelElement.isSkipLastFooter();
        }
        TaggingDummyElement tbodyTag = null;
        tbodyTag = new TaggingDummyElement(createTBody ? "TBody" : null);
        for (TaggingHintKey nonCellKid : nonCellKids) {
            String kidRole = nonCellKid.getAccessibleElement().getAccessibilityProperties().getRole();
            if ("THead".equals(kidRole) || "TFoot".equals(kidRole) || "Caption".equals(kidRole)) continue;
            taggingHelper.moveKidHint(nonCellKid, tableHintKey);
        }
        for (TaggingHintKey nonCellKid : nonCellKids) {
            String kidRole = nonCellKid.getAccessibleElement().getAccessibilityProperties().getRole();
            if (!"THead".equals(kidRole)) continue;
            taggingHelper.moveKidHint(nonCellKid, tableHintKey);
        }
        taggingHelper.addKidsHint(tableHintKey, Collections.singletonList(LayoutTaggingHelper.getOrCreateHintKey(tbodyTag)), -1);
        for (TaggingHintKey nonCellKid : nonCellKids) {
            String kidRole = nonCellKid.getAccessibleElement().getAccessibilityProperties().getRole();
            if (!"TFoot".equals(kidRole)) continue;
            taggingHelper.moveKidHint(nonCellKid, tableHintKey);
        }
        for (TreeMap rowTags : tableTags.values()) {
            TaggingDummyElement row = new TaggingDummyElement("TR");
            TaggingHintKey rowTagHint = LayoutTaggingHelper.getOrCreateHintKey(row);
            for (TaggingHintKey cellTagHint : rowTags.values()) {
                taggingHelper.moveKidHint(cellTagHint, rowTagHint);
            }
            if (tableCellTagsUnindexed != null) {
                for (TaggingHintKey cellTagHint : tableCellTagsUnindexed) {
                    taggingHelper.moveKidHint(cellTagHint, rowTagHint);
                }
                tableCellTagsUnindexed = null;
            }
            taggingHelper.addKidsHint(tbodyTag, Collections.singletonList(row), -1);
        }
        for (TaggingHintKey nonCellKid : nonCellKids) {
            String kidRole = nonCellKid.getAccessibleElement().getAccessibilityProperties().getRole();
            if (!"Caption".equals(kidRole)) continue;
            TableTaggingRule.moveCaption(taggingHelper, nonCellKid, tableHintKey);
        }
        return true;
    }

    private static void moveCaption(LayoutTaggingHelper taggingHelper, TaggingHintKey caption, TaggingHintKey tableHintKey) {
        if (!(tableHintKey.getAccessibleElement() instanceof Table)) {
            return;
        }
        Table tableElem = (Table)tableHintKey.getAccessibleElement();
        Div captionDiv = tableElem.getCaption();
        if (captionDiv == null) {
            return;
        }
        CaptionSide captionSide = captionDiv.getProperty(119) == null ? CaptionSide.TOP : (CaptionSide)((Object)captionDiv.getProperty(119));
        if (CaptionSide.TOP.equals((Object)captionSide)) {
            taggingHelper.moveKidHint(caption, tableHintKey, 0);
        } else {
            taggingHelper.moveKidHint(caption, tableHintKey);
        }
    }
}

