/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.controllers;

import com.mangofactory.swagger.annotations.ApiIgnore;
import com.mangofactory.swagger.core.SwaggerCache;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.ResourceListing;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DefaultSwaggerController {
    public static final String DOCUMENTATION_BASE_PATH = "/api-docs";
    @Autowired
    private SwaggerCache swaggerCache;

    @ApiIgnore
    @RequestMapping(value={"/api-docs"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ResourceListing> getResourceListing(@RequestParam(value="group", required=false) String swaggerGroup) {
        return this.getSwaggerResourceListing(swaggerGroup);
    }

    @ApiIgnore
    @RequestMapping(value={"/api-docs/{swaggerGroup}/{apiDeclaration}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ApiListing> getApiListing(@PathVariable String swaggerGroup, @PathVariable String apiDeclaration) {
        return this.getSwaggerApiListing(swaggerGroup, apiDeclaration);
    }

    private ResponseEntity<ApiListing> getSwaggerApiListing(String swaggerGroup, String apiDeclaration) {
        ApiListing apiListing;
        ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
        Map<String, ApiListing> apiListingMap = this.swaggerCache.getSwaggerApiListingMap().get(swaggerGroup);
        if (null != apiListingMap && null != (apiListing = apiListingMap.get(apiDeclaration))) {
            responseEntity = new ResponseEntity((Object)apiListing, HttpStatus.OK);
        }
        return responseEntity;
    }

    private ResponseEntity<ResourceListing> getSwaggerResourceListing(String swaggerGroup) {
        ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
        ResourceListing resourceListing = null;
        if (null == swaggerGroup) {
            resourceListing = this.swaggerCache.getSwaggerApiResourceListingMap().values().iterator().next();
        } else if (this.swaggerCache.getSwaggerApiResourceListingMap().containsKey(swaggerGroup)) {
            resourceListing = this.swaggerCache.getSwaggerApiResourceListingMap().get(swaggerGroup);
        }
        if (null != resourceListing) {
            responseEntity = new ResponseEntity((Object)resourceListing, HttpStatus.OK);
        }
        return responseEntity;
    }
}

