/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.core;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.mangofactory.swagger.core.ResourceGroupingStrategy;
import com.mangofactory.swagger.core.StringUtils;
import com.mangofactory.swagger.scanners.ResourceGroup;
import com.wordnik.swagger.annotations.Api;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class SpringGroupingStrategy
implements ResourceGroupingStrategy {
    @Override
    public Set<ResourceGroup> getResourceGroups(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.groups(handlerMethod);
    }

    @Override
    public String getResourceDescription(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.getDescription(handlerMethod);
    }

    @Override
    public Integer getResourcePosition(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return 0;
    }

    private Set<ResourceGroup> groups(HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        String defaultGroup = String.format("%s", StringUtils.splitCamelCase(controllerClass.getSimpleName(), "-"));
        Optional requestMapping = Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)controllerClass, RequestMapping.class));
        if (requestMapping.isPresent()) {
            HashSet groups = Sets.newHashSet();
            for (String groupFromReqMapping : Arrays.asList(((RequestMapping)requestMapping.get()).value())) {
                if (Strings.isNullOrEmpty((String)groupFromReqMapping)) continue;
                String groupName = StringUtils.maybeChompLeadingSlash(StringUtils.firstPathSegment(groupFromReqMapping));
                groups.add(new ResourceGroup(groupName));
            }
            if (groups.size() > 0) {
                return groups;
            }
        }
        return Sets.newHashSet((Object[])new ResourceGroup[]{new ResourceGroup(StringUtils.maybeChompLeadingSlash(defaultGroup.toLowerCase()))});
    }

    private String getDescription(HandlerMethod handlerMethod) {
        String descriptionFromAnnotation;
        Class controllerClass = handlerMethod.getBeanType();
        String description = StringUtils.splitCamelCase(controllerClass.getSimpleName(), " ");
        Api apiAnnotation = (Api)AnnotationUtils.findAnnotation((Class)controllerClass, Api.class);
        if (null != apiAnnotation && !Strings.isNullOrEmpty((String)(descriptionFromAnnotation = (String)Optional.fromNullable((Object)Strings.emptyToNull((String)apiAnnotation.value())).or((Object)apiAnnotation.description())))) {
            return descriptionFromAnnotation;
        }
        return description;
    }
}

