/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.model.AllowableListValues;
import com.wordnik.swagger.model.AllowableValues;
import com.wordnik.swagger.model.Parameter;
import java.util.Collection;
import java.util.List;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import scala.collection.JavaConversions;

public class OperationParameterRequestConditionReader
implements Command<RequestMappingContext> {
    @Override
    public void execute(RequestMappingContext context) {
        ParamsRequestCondition paramsCondition = context.getRequestMappingInfo().getParamsCondition();
        List parameters = (List)context.get("parameters");
        for (NameValueExpression expression : paramsCondition.getExpressions()) {
            if (expression.isNegated() || Iterables.any(this.nullToEmptyList(parameters), this.withName(expression.getName()))) continue;
            Parameter parameter = new Parameter(expression.getName(), ScalaUtils.toOption(null), ScalaUtils.toOption(expression.getValue()), true, false, "string", (AllowableValues)new AllowableListValues(JavaConversions.collectionAsScalaIterable((Collection)Lists.newArrayList((Object[])new String[]{(String)expression.getValue()})).toList(), "string"), "query", ScalaUtils.toOption(""));
            parameters.add(parameter);
        }
    }

    private Iterable<Parameter> nullToEmptyList(List<Parameter> parameters) {
        if (parameters == null) {
            return Lists.newArrayList();
        }
        return parameters;
    }

    private Predicate<? super Parameter> withName(final String name) {
        return new Predicate<Parameter>(){

            public boolean apply(Parameter input) {
                return Objects.equal((Object)input.name(), (Object)name);
            }
        };
    }
}

