/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation;

import com.google.common.collect.Lists;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.CommandExecutor;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.readers.operation.HandlerMethodResolver;
import com.mangofactory.swagger.readers.operation.ResolvedMethodParameter;
import com.mangofactory.swagger.readers.operation.parameter.ParameterAllowableReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterDataTypeReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterDefaultReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterDescriptionReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterMultiplesReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterNameReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterRequiredReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterTypeReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.model.AllowableValues;
import com.wordnik.swagger.model.Parameter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.web.method.HandlerMethod;

public class OperationParameterReader
implements Command<RequestMappingContext> {
    @Override
    public void execute(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        SwaggerGlobalSettings swaggerGlobalSettings = (SwaggerGlobalSettings)context.get("swaggerGlobalSettings");
        HandlerMethodResolver handlerMethodResolver = new HandlerMethodResolver(swaggerGlobalSettings.getTypeResolver());
        List<ResolvedMethodParameter> methodParameters = handlerMethodResolver.methodParameters(handlerMethod);
        ArrayList parameters = Lists.newArrayList();
        ArrayList commandList = Lists.newArrayList();
        commandList.add(new ParameterAllowableReader());
        commandList.add(new ParameterDataTypeReader());
        commandList.add(new ParameterTypeReader());
        commandList.add(new ParameterDefaultReader());
        commandList.add(new ParameterDescriptionReader());
        commandList.add(new ParameterMultiplesReader());
        commandList.add(new ParameterNameReader());
        commandList.add(new ParameterRequiredReader());
        for (ResolvedMethodParameter methodParameter : methodParameters) {
            if (this.shouldIgnore(methodParameter, swaggerGlobalSettings.getIgnorableParameterTypes())) continue;
            RequestMappingContext parameterContext = new RequestMappingContext(context.getRequestMappingInfo(), handlerMethod);
            parameterContext.put("methodParameter", methodParameter.getMethodParameter());
            parameterContext.put("resolvedMethodParameter", methodParameter);
            parameterContext.put("swaggerGlobalSettings", swaggerGlobalSettings);
            CommandExecutor commandExecutor = new CommandExecutor();
            commandExecutor.execute(commandList, parameterContext);
            Object result = parameterContext.getResult();
            Parameter parameter = new Parameter((String)result.get("name"), ScalaUtils.toOption(result.get("description")), ScalaUtils.toOption(result.get("defaultValue")), ((Boolean)result.get("required")).booleanValue(), ((Boolean)result.get("allowMultiple")).booleanValue(), (String)result.get("dataType"), (AllowableValues)result.get("allowableValues"), (String)result.get("paramType"), ScalaUtils.toOption(result.get("paramAccess")));
            parameters.add(parameter);
        }
        context.put("parameters", parameters);
    }

    private boolean shouldIgnore(ResolvedMethodParameter parameter, Set<Class> ignorableParamTypes) {
        if (null != ignorableParamTypes && !ignorableParamTypes.isEmpty()) {
            if (ignorableParamTypes.contains(parameter.getMethodParameter().getParameterType())) {
                return true;
            }
            for (Annotation annotation : parameter.getMethodParameter().getParameterAnnotations()) {
                if (!ignorableParamTypes.contains(annotation.annotationType())) continue;
                return true;
            }
        }
        return false;
    }
}

