/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.scanners;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.authorization.AuthorizationContext;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.CommandExecutor;
import com.mangofactory.swagger.core.ResourceGroupingStrategy;
import com.mangofactory.swagger.models.ModelProvider;
import com.mangofactory.swagger.ordering.ApiDescriptionLexicographicalOrdering;
import com.mangofactory.swagger.paths.SwaggerPathProvider;
import com.mangofactory.swagger.readers.ApiDescriptionReader;
import com.mangofactory.swagger.readers.ApiModelReader;
import com.mangofactory.swagger.readers.MediaTypeReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.mangofactory.swagger.scanners.ResourceGroup;
import com.wordnik.swagger.core.SwaggerSpec;
import com.wordnik.swagger.model.ApiDescription;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.Authorization;
import com.wordnik.swagger.model.Model;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.immutable.List;

public class ApiListingScanner {
    private static final Logger log = LoggerFactory.getLogger(ApiListingScanner.class);
    private String apiVersion = "1.0";
    private String swaggerVersion = SwaggerSpec.version();
    private Map<ResourceGroup, java.util.List<RequestMappingContext>> resourceGroupRequestMappings;
    private SwaggerPathProvider swaggerPathProvider;
    private SwaggerGlobalSettings swaggerGlobalSettings;
    private ResourceGroupingStrategy resourceGroupingStrategy;
    private AuthorizationContext authorizationContext;
    private final ModelProvider modelProvider;
    private Ordering<ApiDescription> apiDescriptionOrdering = new ApiDescriptionLexicographicalOrdering();

    public ApiListingScanner(Map<ResourceGroup, java.util.List<RequestMappingContext>> resourceGroupRequestMappings, SwaggerPathProvider swaggerPathProvider, ModelProvider modelProvider, AuthorizationContext authorizationContext) {
        this.resourceGroupRequestMappings = resourceGroupRequestMappings;
        this.swaggerPathProvider = swaggerPathProvider;
        this.authorizationContext = authorizationContext;
        this.modelProvider = modelProvider;
    }

    public Map<String, ApiListing> scan() {
        HashMap apiListingMap = Maps.newHashMap();
        int position = 0;
        if (null == this.resourceGroupRequestMappings) {
            log.error("resourceGroupRequestMappings should not be null.");
        } else {
            for (Map.Entry<ResourceGroup, java.util.List<RequestMappingContext>> entry : this.resourceGroupRequestMappings.entrySet()) {
                ResourceGroup resourceGroup = entry.getKey();
                LinkedHashSet produces = new LinkedHashSet(2);
                LinkedHashSet consumes = new LinkedHashSet(2);
                HashSet apiDescriptions = Sets.newHashSet();
                ArrayList readers = Lists.newArrayList();
                readers.add(new MediaTypeReader());
                readers.add(new ApiDescriptionReader(this.swaggerPathProvider));
                readers.add(new ApiModelReader(this.modelProvider));
                LinkedHashMap<String, Model> models = new LinkedHashMap<String, Model>();
                for (RequestMappingContext each : entry.getValue()) {
                    CommandExecutor commandExecutor = new CommandExecutor();
                    each.put("authorizationContext", this.authorizationContext);
                    each.put("swaggerGlobalSettings", this.swaggerGlobalSettings);
                    each.put("currentResourceGroup", resourceGroup);
                    Map<String, Object> results = commandExecutor.execute(readers, each);
                    java.util.List producesMediaTypes = (java.util.List)results.get("produces");
                    java.util.List consumesMediaTypes = (java.util.List)results.get("consumes");
                    Map swaggerModels = (Map)results.get("models");
                    if (null != swaggerModels) {
                        models.putAll(swaggerModels);
                    }
                    produces.addAll(producesMediaTypes);
                    consumes.addAll(consumesMediaTypes);
                    java.util.List apiDescriptionList = (java.util.List)results.get("apiDescriptionList");
                    apiDescriptions.addAll(apiDescriptionList);
                }
                List<Authorization> authorizations = ScalaUtils.emptyScalaList();
                if (null != this.authorizationContext) {
                    authorizations = this.authorizationContext.getScalaAuthorizations();
                }
                Option modelOption = ScalaUtils.toOption(models);
                if (null != models) {
                    modelOption = ScalaUtils.toOption(ScalaUtils.toScalaModelMap(models));
                }
                ArrayList sortedDescriptions = new ArrayList(apiDescriptions);
                Collections.sort(sortedDescriptions, this.apiDescriptionOrdering);
                String resourcePath = "fix this";
                ApiListing apiListing = new ApiListing(this.apiVersion, this.swaggerVersion, this.swaggerPathProvider.getApplicationBasePath(), resourcePath, ScalaUtils.toScalaList(produces), ScalaUtils.toScalaList(consumes), ScalaUtils.emptyScalaList(), authorizations, ScalaUtils.toScalaList(sortedDescriptions), modelOption, ScalaUtils.toOption(null), position++);
                apiListingMap.put(resourceGroup.getGroupName(), apiListing);
            }
        }
        return apiListingMap;
    }

    public SwaggerGlobalSettings getSwaggerGlobalSettings() {
        return this.swaggerGlobalSettings;
    }

    public void setSwaggerGlobalSettings(SwaggerGlobalSettings swaggerGlobalSettings) {
        this.swaggerGlobalSettings = swaggerGlobalSettings;
    }

    public void setResourceGroupingStrategy(ResourceGroupingStrategy resourceGroupingStrategy) {
        this.resourceGroupingStrategy = resourceGroupingStrategy;
    }

    public void setAuthorizationContext(AuthorizationContext authorizationContext) {
        this.authorizationContext = authorizationContext;
    }

    public void setApiDescriptionOrdering(Ordering<ApiDescription> apiDescriptionOrdering) {
        this.apiDescriptionOrdering = apiDescriptionOrdering;
    }
}

