/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.entity;

import com.nepxion.discovery.common.entity.MapWeightEntity;
import com.nepxion.discovery.common.entity.RegionWeightEntity;
import com.nepxion.discovery.common.entity.VersionWeightEntity;
import com.nepxion.discovery.common.entity.WeightEntity;
import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class WeightEntityWrapper {
    public static List<WeightEntity> parseWeightEntityList(String weightValue) {
        ArrayList<WeightEntity> weightEntityList = new ArrayList<WeightEntity>();
        Map jsonWeightMap = JsonUtil.fromJson(weightValue, Map.class);
        for (Map.Entry entry : jsonWeightMap.entrySet()) {
            String providerServiceName = (String)entry.getKey();
            String providerWeightValue = (String)entry.getValue();
            WeightEntity weightEntity = new WeightEntity();
            weightEntity.setProviderServiceName(providerServiceName);
            WeightEntityWrapper.parseWeightEntity(weightEntity, providerWeightValue);
            weightEntityList.add(weightEntity);
        }
        return weightEntityList;
    }

    public static void parseWeightEntity(MapWeightEntity weightEntity, String weightValue) {
        Map<String, Integer> weightMap = weightEntity.getWeightMap();
        List<String> providerWeightValueList = StringUtil.splitToList(weightValue, ";");
        for (String value : providerWeightValueList) {
            String[] valueArray = StringUtils.split((String)value, (String)"=");
            String key = valueArray[0].trim();
            int weight = 0;
            try {
                weight = Integer.valueOf(valueArray[1].trim());
                if (weight < 0) {
                    weight = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            weightMap.put(key, weight);
        }
    }

    public static int getWeight(String consumerServiceId, String providerServiceId, String providerKey, Map<String, List<WeightEntity>> weightEntityMap) {
        if (MapUtils.isEmpty(weightEntityMap)) {
            return -1;
        }
        List<WeightEntity> weightEntityList = weightEntityMap.get(consumerServiceId);
        return WeightEntityWrapper.getWeight(providerServiceId, providerKey, weightEntityList);
    }

    public static int getWeight(String providerServiceId, String providerKey, List<WeightEntity> weightEntityList) {
        if (CollectionUtils.isEmpty(weightEntityList)) {
            return -1;
        }
        for (WeightEntity weightEntity : weightEntityList) {
            String providerServiceName = weightEntity.getProviderServiceName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)providerServiceName, (CharSequence)providerServiceId)) continue;
            return WeightEntityWrapper.getWeight(providerKey, weightEntity);
        }
        return -1;
    }

    public static int getWeight(String providerKey, MapWeightEntity weightEntity) {
        if (weightEntity == null) {
            return -1;
        }
        Map<String, Integer> weightMap = weightEntity.getWeightMap();
        if (MapUtils.isEmpty(weightMap)) {
            return -1;
        }
        Integer weight = weightMap.get(providerKey);
        if (weight != null) {
            return weight;
        }
        return -1;
    }

    public static int getWeight(WeightFilterEntity weightFilterEntity, String providerServiceId, String providerVersion, String providerRegion, String serviceId) {
        int weight = -1;
        if (StringUtils.isNotEmpty((CharSequence)serviceId) && weight < 0) {
            Map<String, List<WeightEntity>> versionWeightEntityMap = weightFilterEntity.getVersionWeightEntityMap();
            weight = WeightEntityWrapper.getWeight(serviceId, providerServiceId, providerVersion, versionWeightEntityMap);
        }
        if (weight < 0) {
            List<WeightEntity> versionWeightEntityList = weightFilterEntity.getVersionWeightEntityList();
            weight = WeightEntityWrapper.getWeight(providerServiceId, providerVersion, versionWeightEntityList);
        }
        if (weight < 0) {
            VersionWeightEntity versionWeightEntity = weightFilterEntity.getVersionWeightEntity();
            weight = WeightEntityWrapper.getWeight(providerVersion, versionWeightEntity);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceId) && weight < 0) {
            Map<String, List<WeightEntity>> regionWeightEntityMap = weightFilterEntity.getRegionWeightEntityMap();
            weight = WeightEntityWrapper.getWeight(serviceId, providerServiceId, providerRegion, regionWeightEntityMap);
        }
        if (weight < 0) {
            List<WeightEntity> regionWeightEntityList = weightFilterEntity.getRegionWeightEntityList();
            weight = WeightEntityWrapper.getWeight(providerServiceId, providerRegion, regionWeightEntityList);
        }
        if (weight < 0) {
            RegionWeightEntity regionWeightEntity = weightFilterEntity.getRegionWeightEntity();
            weight = WeightEntityWrapper.getWeight(providerRegion, regionWeightEntity);
        }
        return weight;
    }
}

