/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.AppleFileEventStreams;
import com.swoval.files.DirectoryRegistry;
import com.swoval.files.DirectoryRegistryImpl;
import com.swoval.files.FileTreeViews;
import com.swoval.files.Observers;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import com.swoval.files.TypedPath;
import com.swoval.files.TypedPaths;
import com.swoval.files.apple.ClosedFileEventMonitorException;
import com.swoval.files.apple.FileEvent;
import com.swoval.files.apple.FileEventMonitor;
import com.swoval.files.apple.FileEventMonitors;
import com.swoval.files.apple.Flags;
import com.swoval.functional.Consumer;
import com.swoval.functional.Either;
import com.swoval.logging.Logger;
import com.swoval.logging.Loggers;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class ApplePathWatcher
implements PathWatcher<PathWatchers.Event> {
    private final DirectoryRegistry directoryRegistry;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final long latency;
    private final AppleFileEventStreams appleFileEventStreams = new AppleFileEventStreams();
    private final TimeUnit timeUnit;
    private final Flags.Create flags;
    private final FileEventMonitor fileEventMonitor;
    private final Observers<PathWatchers.Event> observers = new Observers();
    private static final DefaultOnStreamRemoved DefaultOnStreamRemoved = new DefaultOnStreamRemoved();
    private final Logger logger;

    @Override
    public int addObserver(FileTreeViews.Observer<? super PathWatchers.Event> observer) {
        return this.observers.addObserver(observer);
    }

    @Override
    public void removeObserver(int n) {
        this.observers.removeObserver(n);
    }

    @Override
    public Either<IOException, Boolean> register(Path path, int n) {
        Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        return this.register(path2, this.flags, n);
    }

    public Either<IOException, Boolean> register(Path path, Flags.Create create, int n) {
        boolean bl = true;
        Map.Entry<Path, Stream> entry = this.find(path);
        this.directoryRegistry.addDirectory(path, n);
        if (entry == null) {
            try {
                FileEventMonitors.Handle handle = this.fileEventMonitor.createStream(path, this.latency, this.timeUnit, create);
                if (handle == FileEventMonitors.Handles.INVALID) {
                    bl = false;
                } else {
                    this.removeRedundantStreams(path);
                    this.appleFileEventStreams.put(path, new Stream(this.fileEventMonitor, handle));
                }
            }
            catch (ClosedFileEventMonitorException closedFileEventMonitorException) {
                this.close();
                bl = false;
            }
        }
        if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
            this.logger.debug(this + " registered " + path + " with max depth " + n);
        }
        return Either.right(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRedundantStreams(Path path) {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        if (this.appleFileEventStreams.lock()) {
            try {
                Map.Entry entry;
                Iterator iterator = this.appleFileEventStreams.iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    Path path2 = (Path)entry.getKey();
                    if (!path2.startsWith(path) || path2.equals(path)) continue;
                    arrayList.add(path2);
                }
                entry = arrayList.iterator();
                while (entry.hasNext()) {
                    this.unregister((Path)entry.next());
                }
            }
            finally {
                this.appleFileEventStreams.unlock();
            }
        }
    }

    @Override
    public void unregister(Path path) {
        Path path2;
        Path path3 = path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        if (!this.closed.get()) {
            this.directoryRegistry.removeDirectory(path2);
            Stream stream = (Stream)this.appleFileEventStreams.remove(path2);
            if (stream != null && stream.handle != FileEventMonitors.Handles.INVALID) {
                try {
                    stream.close();
                }
                catch (ClosedFileEventMonitorException closedFileEventMonitorException) {
                    closedFileEventMonitorException.printStackTrace(System.err);
                }
            }
            if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                this.logger.debug("ApplePathWatcher unregistered " + path);
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                this.logger.debug(this + " closed");
            }
            this.appleFileEventStreams.clear();
            this.fileEventMonitor.close();
        }
    }

    ApplePathWatcher(DirectoryRegistry directoryRegistry, Logger logger) throws InterruptedException {
        this(10L, TimeUnit.MILLISECONDS, new Flags.Create().setNoDefer().setFileEvents(), DefaultOnStreamRemoved, directoryRegistry, logger);
    }

    ApplePathWatcher(long l, TimeUnit timeUnit, Flags.Create create, Consumer<String> consumer, DirectoryRegistry directoryRegistry) throws InterruptedException {
        this(l, timeUnit, create, consumer, directoryRegistry, Loggers.getLogger());
    }

    ApplePathWatcher(long l, TimeUnit timeUnit, Flags.Create create, final Consumer<String> consumer, DirectoryRegistry directoryRegistry, final Logger logger) throws InterruptedException {
        this.latency = l;
        this.timeUnit = timeUnit;
        this.flags = create;
        this.directoryRegistry = directoryRegistry == null ? new DirectoryRegistryImpl() : directoryRegistry;
        this.logger = logger;
        this.fileEventMonitor = FileEventMonitors.get(new Consumer<FileEvent>(){

            @Override
            public void accept(FileEvent fileEvent) {
                if (Loggers.shouldLog(logger, Loggers.Level.DEBUG)) {
                    logger.debug(this + " received event for " + fileEvent.fileName);
                }
                if (!ApplePathWatcher.this.closed.get()) {
                    String string = fileEvent.fileName;
                    TypedPath typedPath = TypedPaths.get(Paths.get(string, new String[0]));
                    if (ApplePathWatcher.this.directoryRegistry.accept(typedPath.getPath())) {
                        PathWatchers.Event event = fileEvent.itemIsFile() ? (fileEvent.isNewFile() && typedPath.exists() ? new PathWatchers.Event(typedPath, PathWatchers.Event.Kind.Create) : (fileEvent.isRemoved() || !typedPath.exists() ? new PathWatchers.Event(typedPath, PathWatchers.Event.Kind.Delete) : new PathWatchers.Event(typedPath, PathWatchers.Event.Kind.Modify))) : (typedPath.exists() ? new PathWatchers.Event(typedPath, PathWatchers.Event.Kind.Modify) : new PathWatchers.Event(typedPath, PathWatchers.Event.Kind.Delete));
                        try {
                            if (Loggers.shouldLog(logger, Loggers.Level.DEBUG)) {
                                logger.debug(this + " passing " + event + " to observers");
                            }
                            ApplePathWatcher.this.observers.onNext(event);
                        }
                        catch (Exception exception) {
                            logger.debug(this + " invoking onError for " + exception);
                            ApplePathWatcher.this.observers.onError(exception);
                        }
                    }
                }
            }
        }, new Consumer<String>(){

            @Override
            public void accept(String string) {
                if (!ApplePathWatcher.this.closed.get()) {
                    ApplePathWatcher.this.appleFileEventStreams.remove(Paths.get(string, new String[0]));
                    consumer.accept(string);
                }
            }
        });
    }

    private Map.Entry<Path, Stream> find(Path path) {
        Iterator iterator = this.appleFileEventStreams.iterator();
        Map.Entry entry = null;
        while (entry == null && iterator.hasNext()) {
            Map.Entry entry2 = iterator.next();
            if (!path.startsWith((Path)entry2.getKey())) continue;
            entry = entry2;
        }
        return entry;
    }

    static class DefaultOnStreamRemoved
    implements Consumer<String> {
        DefaultOnStreamRemoved() {
        }

        @Override
        public void accept(String string) {
        }
    }

    static class Stream
    implements AutoCloseable {
        final FileEventMonitors.Handle handle;
        final FileEventMonitor fileEventMonitor;

        Stream(FileEventMonitor fileEventMonitor, FileEventMonitors.Handle handle) {
            this.fileEventMonitor = fileEventMonitor;
            this.handle = handle;
        }

        @Override
        public void close() throws ClosedFileEventMonitorException {
            if (!this.handle.equals(FileEventMonitors.Handles.INVALID)) {
                this.fileEventMonitor.stopStream(this.handle);
            }
        }
    }
}

