/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.scenario.template;

import io.gatling.http.util.HttpHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.scenario.RequestBody;
import io.gatling.recorder.scenario.RequestBodyBytes;
import io.gatling.recorder.scenario.RequestBodyParams;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.ScenarioExporter$;
import io.gatling.recorder.scenario.template.ExtractedUris;
import io.gatling.recorder.scenario.template.package$;
import java.io.Serializable;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RequestTemplate$ {
    public static final RequestTemplate$ MODULE$ = new RequestTemplate$();
    private static final List<String> BuiltInHttpMethods = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"GET", "PUT", "PATCH", "HEAD", "DELETE", "OPTIONS", "POST"}));
    private static final int MaxLiteralSize = 65534;

    public List<String> BuiltInHttpMethods() {
        return BuiltInHttpMethods;
    }

    public int MaxLiteralSize() {
        return MaxLiteralSize;
    }

    public String headersBlockName(int id) {
        return new StringBuilder(8).append("headers_").append(id).toString();
    }

    public String renderRequest(String simulationClass, RequestElement request, ExtractedUris extractedUri, RecorderConfiguration config) {
        String prefix = config.http().useSimulationAsPrefix() ? simulationClass : "request";
        String postfix = config.http().useMethodAndUriAsPostfix() ? new StringBuilder(1).append(":").append(this.sanitizeRequestPostfix(new StringBuilder(1).append(request.method()).append("_").append(request.uri()).toString())).toString() : "";
        return new StringBuilder(14).append("http(\"").append(prefix).append("_").append(request.id()).append(postfix).append("\")\n\t\t\t.").append(this.renderMethod$1(request, extractedUri)).append(RequestTemplate$.renderHeaders$1(request)).append(this.renderBodyOrParams$1(request, config)).append(RequestTemplate$.renderCredentials$1(request)).append(RequestTemplate$.renderResources$1(request, simulationClass, extractedUri, config)).append(RequestTemplate$.renderStatusCheck$1(request)).append(RequestTemplate$.renderResponseBodyCheck$1(request, config)).toString();
    }

    public String sanitizeRequestPostfix(String postfix) {
        return postfix.replaceAll("[^-._=:/?&A-Za-z0-9]", "_");
    }

    public String render(String simulationClass, RequestElement request, ExtractedUris extractedUri, RecorderConfiguration config) {
        return new StringBuilder(6).append("exec(").append(this.renderRequest(simulationClass, request, extractedUri, config)).append(")").toString().toString();
    }

    private final String renderMethod$1(RequestElement request$1, ExtractedUris extractedUri$1) {
        return this.BuiltInHttpMethods().contains((Object)request$1.method()) ? new StringBuilder(2).append(request$1.method().toLowerCase(Locale.ROOT)).append("(").append(RequestTemplate$.renderUrl$1(request$1, extractedUri$1)).append(")").toString() : new StringBuilder(17).append("httpRequest(\"").append(request$1.method()).append("\", ").append(RequestTemplate$.renderUrl$1(request$1, extractedUri$1)).append(")").toString();
    }

    private static final boolean usesBaseUrl$1(RequestElement request$1) {
        String string = request$1.printedUrl();
        String string2 = request$1.uri();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private static final String renderUrl$1(RequestElement request$1, ExtractedUris extractedUri$1) {
        return RequestTemplate$.usesBaseUrl$1(request$1) ? package$.MODULE$.protectWithTripleQuotes(request$1.printedUrl()) : extractedUri$1.renderUri(request$1.uri());
    }

    public static final /* synthetic */ String $anonfun$renderRequest$1(int id) {
        return new StringBuilder(14).append("\n\t\t\t.headers(").append(MODULE$.headersBlockName(id)).append(")").toString();
    }

    private static final String renderHeaders$1(RequestElement request$1) {
        return (String)request$1.filteredHeadersId().map((Function1 & Serializable)id -> RequestTemplate$.$anonfun$renderRequest$1(BoxesRunTime.unboxToInt((Object)id))).getOrElse((Function0 & Serializable)() -> "");
    }

    private final String renderLongString$1(String value) {
        return value.length() > this.MaxLiteralSize() ? new StringBuilder(14).append("Seq(").append(StringOps$.MODULE$.grouped$extension(Predef$.MODULE$.augmentString(value), this.MaxLiteralSize()).map((Function1 & Serializable)string -> package$.MODULE$.protectWithTripleQuotes((String)string)).mkString(", ")).append(").mkString").toString() : package$.MODULE$.protectWithTripleQuotes(value);
    }

    private final String renderBodyOrParams$1(RequestElement request$1, RecorderConfiguration config$1) {
        return (String)request$1.body().map((Function1 & Serializable)x0$1 -> {
            String string;
            RequestBody requestBody = x0$1;
            if (requestBody instanceof RequestBodyBytes) {
                string = new StringBuilder(26).append("\n\t\t\t.body(RawFileBody(\"").append(ScenarioExporter$.MODULE$.requestBodyRelativeFilePath(request$1, config$1)).append("\"))").toString();
            } else if (requestBody instanceof RequestBodyParams) {
                RequestBodyParams requestBodyParams = (RequestBodyParams)requestBody;
                List<Tuple2<String, String>> params = requestBodyParams.params();
                string = params.map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    String string = new StringBuilder(18).append("\n\t\t\t.formParam(").append(package$.MODULE$.protectWithTripleQuotes(key)).append(", ").append(this.renderLongString$1(value)).append(")").toString();
                    return string;
                }).mkString();
            } else {
                throw new MatchError((Object)requestBody);
            }
            return string;
        }).getOrElse((Function0 & Serializable)() -> "");
    }

    private static final String renderCredentials$1(RequestElement request$1) {
        return (String)request$1.basicAuthCredentials().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String username = (String)tuple2._1();
            String password = (String)tuple2._2();
            String string = new StringBuilder(17).append("\n\t\t\t.basicAuth(").append(package$.MODULE$.protectWithTripleQuotes(username)).append(",").append(package$.MODULE$.protectWithTripleQuotes(password)).append(")").toString();
            return string;
        }).getOrElse((Function0 & Serializable)() -> "");
    }

    private static final String renderStatusCheck$1(RequestElement request$1) {
        return !HttpHelper$.MODULE$.isOk(request$1.statusCode()) ? new StringBuilder(23).append("\n\t\t\t.check(status.is(").append(request$1.statusCode()).append("))").toString() : "";
    }

    private static final String renderResponseBodyCheck$1(RequestElement request$1, RecorderConfiguration config$1) {
        return request$1.responseBody().isDefined() && config$1.http().checkResponseBodies() ? new StringBuilder(41).append("\n\t\t\t.check(bodyBytes.is(RawFileBody(\"").append(ScenarioExporter$.MODULE$.responseBodyRelativeFilePath(request$1, config$1)).append("\")))").toString() : "";
    }

    private static final String renderResources$1(RequestElement request$1, String simulationClass$1, ExtractedUris extractedUri$1, RecorderConfiguration config$1) {
        return request$1.nonEmbeddedResources().nonEmpty() ? new StringBuilder(16).append("\n\t\t\t.resources(").append(((List)request$1.nonEmbeddedResources().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RequestElement resource = (RequestElement)tuple2._1();
            String string = MODULE$.renderRequest(simulationClass$1, resource, extractedUri$1, config$1);
            return string;
        }).mkString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(",\n            ")))).append(")").toString() : "";
    }

    private RequestTemplate$() {
    }
}

