/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"version", "vectorString", "attackVector", "attackComplexity", "attackRequirements", "privilegesRequired", "userInteraction", "vulnerableSystemConfidentiality", "vulnerableSystemIntegrity", "vulnerableSystemAvailability", "subsequentSystemConfidentiality", "subsequentSystemIntegrity", "subsequentSystemAvailability", "exploitMaturity", "confidentialityRequirements", "integrityRequirements", "availabilityRequirements", "modifiedAttackVector", "modifiedAttackComplexity", "modifiedAttackRequirements", "modifiedPrivilegesRequired", "modifiedUserInteraction", "modifiedVulnerableSystemConfidentiality", "modifiedVulnerableSystemIntegrity", "modifiedVulnerableSystemAvailability", "modifiedSubsequentSystemConfidentiality", "modifiedSubsequentSystemIntegrity", "modifiedSubsequentSystemAvailability", "safety", "automatable", "recovery", "valueDensity", "vulnerabilityResponseEffort", "providerUrgency", "baseScore", "baseSeverity", "threatScore", "threatSeverity", "environmentalScore", "environmentalSeverity"})
public class CvssV4Data
implements Serializable {
    private static final long serialVersionUID = 8537782209754450697L;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="CVSS Version")
    private Version version;
    @JsonProperty(value="vectorString")
    private String vectorString;
    @JsonProperty(value="attackVector")
    private AttackVectorType attackVector;
    @JsonProperty(value="attackComplexity")
    private AttackComplexityType attackComplexity;
    @JsonProperty(value="attackRequirements")
    private AttackRequirementsType attackRequirements;
    @JsonProperty(value="privilegesRequired")
    private PrivilegesRequiredType privilegesRequired;
    @JsonProperty(value="userInteraction")
    private UserInteractionType userInteraction;
    @JsonProperty(value="vulnerableSystemConfidentiality")
    @JsonAlias(value={"vulnConfidentialityImpact"})
    private CiaType vulnConfidentialityImpact;
    @JsonProperty(value="vulnerableSystemIntegrity")
    @JsonAlias(value={"vulnIntegrityImpact"})
    private CiaType vulnIntegrityImpact;
    @JsonProperty(value="vulnerableSystemAvailability")
    @JsonAlias(value={"vulnAvailabilityImpact"})
    private CiaType vulnAvailabilityImpact;
    @JsonProperty(value="subsequentSystemConfidentiality")
    @JsonAlias(value={"subConfidentialityImpact"})
    private CiaType subConfidentialityImpact;
    @JsonProperty(value="subsequentSystemIntegrity")
    @JsonAlias(value={"subIntegrityImpact"})
    private CiaType subIntegrityImpact;
    @JsonProperty(value="subsequentSystemAvailability")
    @JsonAlias(value={"subAvailabilityImpact"})
    private CiaType subAvailabilityImpact;
    @JsonProperty(value="exploitMaturity")
    @JsonSetter(nulls=Nulls.SKIP)
    private ExploitMaturityType exploitMaturity = ExploitMaturityType.NOT_DEFINED;
    @JsonProperty(value="confidentialityRequirements")
    @JsonAlias(value={"confidentialityRequirement"})
    private CiaRequirementType confidentialityRequirement;
    @JsonProperty(value="integrityRequirements")
    @JsonAlias(value={"integrityRequirement"})
    private CiaRequirementType integrityRequirement;
    @JsonProperty(value="availabilityRequirements")
    @JsonAlias(value={"availabilityRequirement"})
    private CiaRequirementType availabilityRequirement;
    @JsonProperty(value="modifiedAttackVector")
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedAttackVectorType modifiedAttackVector = ModifiedAttackVectorType.NOT_DEFINED;
    @JsonProperty(value="modifiedAttackComplexity")
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedAttackComplexityType modifiedAttackComplexity = ModifiedAttackComplexityType.NOT_DEFINED;
    @JsonProperty(value="modifiedAttackRequirements")
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedAttackRequirementsType modifiedAttackRequirements = ModifiedAttackRequirementsType.NOT_DEFINED;
    @JsonProperty(value="modifiedPrivilegesRequired")
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedPrivilegesRequiredType modifiedPrivilegesRequired = ModifiedPrivilegesRequiredType.NOT_DEFINED;
    @JsonProperty(value="modifiedUserInteraction")
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedUserInteractionType modifiedUserInteraction = ModifiedUserInteractionType.NOT_DEFINED;
    @JsonProperty(value="modifiedVulnerableSystemConfidentiality")
    @JsonAlias(value={"modifiedVulnConfidentialityImpact"})
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedCiaType modifiedVulnConfidentialityImpact = ModifiedCiaType.NOT_DEFINED;
    @JsonProperty(value="modifiedVulnerableSystemIntegrity")
    @JsonAlias(value={"modifiedVulnIntegrityImpact"})
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedCiaType modifiedVulnIntegrityImpact = ModifiedCiaType.NOT_DEFINED;
    @JsonProperty(value="modifiedVulnerableSystemAvailability")
    @JsonAlias(value={"modifiedVulnAvailabilityImpact"})
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedCiaType modifiedVulnAvailabilityImpact = ModifiedCiaType.NOT_DEFINED;
    @JsonProperty(value="modifiedSubsequentSystemConfidentiality")
    @JsonAlias(value={"modifiedSubConfidentialityImpact"})
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedCiaType modifiedSubConfidentialityImpact = ModifiedCiaType.NOT_DEFINED;
    @JsonProperty(value="modifiedSubsequentSystemIntegrity")
    @JsonAlias(value={"modifiedSubIntegrityImpact"})
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedCiaType modifiedSubIntegrityImpact = ModifiedCiaType.NOT_DEFINED;
    @JsonProperty(value="modifiedSubsequentSystemAvailability")
    @JsonAlias(value={"modifiedSubAvailabilityImpact"})
    @JsonSetter(nulls=Nulls.SKIP)
    private ModifiedCiaType modifiedSubAvailabilityImpact = ModifiedCiaType.NOT_DEFINED;
    @JsonProperty(value="safety")
    @JsonAlias(value={"Safety"})
    @JsonSetter(nulls=Nulls.SKIP)
    private SafetyType safety = SafetyType.NOT_DEFINED;
    @JsonProperty(value="automatable")
    @JsonAlias(value={"Automatable"})
    @JsonSetter(nulls=Nulls.SKIP)
    private AutomatableType automatable = AutomatableType.NOT_DEFINED;
    @JsonProperty(value="recovery")
    @JsonAlias(value={"Recovery"})
    @JsonSetter(nulls=Nulls.SKIP)
    private RecoveryType recovery = RecoveryType.NOT_DEFINED;
    @JsonProperty(value="valueDensity")
    @JsonSetter(nulls=Nulls.SKIP)
    private ValueDensityType valueDensity = ValueDensityType.NOT_DEFINED;
    @JsonProperty(value="vulnerabilityResponseEffort")
    @JsonSetter(nulls=Nulls.SKIP)
    private VulnerabilityResponseEffortType vulnerabilityResponseEffort = VulnerabilityResponseEffortType.NOT_DEFINED;
    @JsonProperty(value="providerUrgency")
    @JsonSetter(nulls=Nulls.SKIP)
    private ProviderUrgencyType providerUrgency = ProviderUrgencyType.NOT_DEFINED;
    @JsonProperty(value="baseScore")
    private Double baseScore;
    @JsonProperty(value="baseSeverity")
    private SeverityType baseSeverity;
    @JsonProperty(value="threatScore")
    private Double threatScore;
    @JsonProperty(value="threatSeverity")
    private SeverityType threatSeverity;
    @JsonProperty(value="environmentalScore")
    private Double environmentalScore;
    @JsonProperty(value="environmentalSeverity")
    private SeverityType environmentalSeverity;

    public CvssV4Data() {
    }

    public CvssV4Data(Version version, String vectorString, AttackVectorType attackVector, AttackComplexityType attackComplexity, AttackRequirementsType attackRequirements, PrivilegesRequiredType privilegesRequired, UserInteractionType userInteraction, CiaType vulnConfidentialityImpact, CiaType vulnIntegrityImpact, CiaType vulnAvailabilityImpact, CiaType subConfidentialityImpact, CiaType subIntegrityImpact, CiaType subAvailabilityImpact, ExploitMaturityType exploitMaturity, CiaRequirementType confidentialityRequirement, CiaRequirementType integrityRequirement, CiaRequirementType availabilityRequirement, ModifiedAttackVectorType modifiedAttackVector, ModifiedAttackComplexityType modifiedAttackComplexity, ModifiedAttackRequirementsType modifiedAttackRequirements, ModifiedPrivilegesRequiredType modifiedPrivilegesRequired, ModifiedUserInteractionType modifiedUserInteraction, ModifiedCiaType modifiedVulnConfidentialityImpact, ModifiedCiaType modifiedVulnIntegrityImpact, ModifiedCiaType modifiedVulnAvailabilityImpact, ModifiedCiaType modifiedSubConfidentialityImpact, ModifiedCiaType modifiedSubIntegrityImpact, ModifiedCiaType modifiedSubAvailabilityImpact, SafetyType safety, AutomatableType automatable, RecoveryType recovery, ValueDensityType valueDensity, VulnerabilityResponseEffortType vulnerabilityResponseEffort, ProviderUrgencyType providerUrgency, Double baseScore, SeverityType baseSeverity, Double threatScore, SeverityType threatSeverity, Double environmentalScore, SeverityType environmentalSeverity) {
        this.version = version;
        this.vectorString = vectorString;
        this.attackVector = attackVector;
        this.attackComplexity = attackComplexity;
        this.attackRequirements = attackRequirements;
        this.privilegesRequired = privilegesRequired;
        this.userInteraction = userInteraction;
        this.vulnConfidentialityImpact = vulnConfidentialityImpact;
        this.vulnIntegrityImpact = vulnIntegrityImpact;
        this.vulnAvailabilityImpact = vulnAvailabilityImpact;
        this.subConfidentialityImpact = subConfidentialityImpact;
        this.subIntegrityImpact = subIntegrityImpact;
        this.subAvailabilityImpact = subAvailabilityImpact;
        this.exploitMaturity = exploitMaturity;
        this.confidentialityRequirement = confidentialityRequirement;
        this.integrityRequirement = integrityRequirement;
        this.availabilityRequirement = availabilityRequirement;
        this.modifiedAttackVector = modifiedAttackVector;
        this.modifiedAttackComplexity = modifiedAttackComplexity;
        this.modifiedAttackRequirements = modifiedAttackRequirements;
        this.modifiedPrivilegesRequired = modifiedPrivilegesRequired;
        this.modifiedUserInteraction = modifiedUserInteraction;
        this.modifiedVulnConfidentialityImpact = modifiedVulnConfidentialityImpact;
        this.modifiedVulnIntegrityImpact = modifiedVulnIntegrityImpact;
        this.modifiedVulnAvailabilityImpact = modifiedVulnAvailabilityImpact;
        this.modifiedSubConfidentialityImpact = modifiedSubConfidentialityImpact;
        this.modifiedSubIntegrityImpact = modifiedSubIntegrityImpact;
        this.modifiedSubAvailabilityImpact = modifiedSubAvailabilityImpact;
        this.safety = safety;
        this.automatable = automatable;
        this.recovery = recovery;
        this.valueDensity = valueDensity;
        this.vulnerabilityResponseEffort = vulnerabilityResponseEffort;
        this.providerUrgency = providerUrgency;
        this.baseScore = baseScore;
        this.baseSeverity = baseSeverity;
        this.threatScore = threatScore;
        this.threatSeverity = threatSeverity;
        this.environmentalScore = environmentalScore;
        this.environmentalSeverity = environmentalSeverity;
    }

    @JsonProperty(value="version")
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty(value="vectorString")
    public String getVectorString() {
        return this.vectorString;
    }

    @JsonProperty(value="attackVector")
    public AttackVectorType getAttackVector() {
        return this.attackVector;
    }

    @JsonProperty(value="attackComplexity")
    public AttackComplexityType getAttackComplexity() {
        return this.attackComplexity;
    }

    @JsonProperty(value="attackRequirements")
    public AttackRequirementsType getAttackRequirements() {
        return this.attackRequirements;
    }

    @JsonProperty(value="privilegesRequired")
    public PrivilegesRequiredType getPrivilegesRequired() {
        return this.privilegesRequired;
    }

    @JsonProperty(value="userInteraction")
    public UserInteractionType getUserInteraction() {
        return this.userInteraction;
    }

    @JsonProperty(value="vulnConfidentialityImpact")
    public CiaType getVulnConfidentialityImpact() {
        return this.vulnConfidentialityImpact;
    }

    @JsonProperty(value="vulnIntegrityImpact")
    public CiaType getVulnIntegrityImpact() {
        return this.vulnIntegrityImpact;
    }

    @JsonProperty(value="vulnAvailabilityImpact")
    public CiaType getVulnAvailabilityImpact() {
        return this.vulnAvailabilityImpact;
    }

    @JsonProperty(value="subConfidentialityImpact")
    public CiaType getSubConfidentialityImpact() {
        return this.subConfidentialityImpact;
    }

    @JsonProperty(value="subIntegrityImpact")
    public CiaType getSubIntegrityImpact() {
        return this.subIntegrityImpact;
    }

    @JsonProperty(value="subAvailabilityImpact")
    public CiaType getSubAvailabilityImpact() {
        return this.subAvailabilityImpact;
    }

    @JsonProperty(value="exploitMaturity")
    public ExploitMaturityType getExploitMaturity() {
        return this.exploitMaturity;
    }

    @JsonProperty(value="baseScore")
    public Double getBaseScore() {
        return this.baseScore;
    }

    @JsonProperty(value="baseSeverity")
    public SeverityType getBaseSeverity() {
        return this.baseSeverity;
    }

    @JsonProperty(value="confidentialityRequirement")
    public CiaRequirementType getConfidentialityRequirement() {
        return this.confidentialityRequirement;
    }

    @JsonProperty(value="integrityRequirement")
    public CiaRequirementType getIntegrityRequirement() {
        return this.integrityRequirement;
    }

    @JsonProperty(value="availabilityRequirement")
    public CiaRequirementType getAvailabilityRequirement() {
        return this.availabilityRequirement;
    }

    @JsonProperty(value="modifiedAttackVector")
    public ModifiedAttackVectorType getModifiedAttackVector() {
        return this.modifiedAttackVector;
    }

    @JsonProperty(value="modifiedAttackComplexity")
    public ModifiedAttackComplexityType getModifiedAttackComplexity() {
        return this.modifiedAttackComplexity;
    }

    @JsonProperty(value="modifiedAttackRequirements")
    public ModifiedAttackRequirementsType getModifiedAttackRequirements() {
        return this.modifiedAttackRequirements;
    }

    @JsonProperty(value="modifiedPrivilegesRequired")
    public ModifiedPrivilegesRequiredType getModifiedPrivilegesRequired() {
        return this.modifiedPrivilegesRequired;
    }

    @JsonProperty(value="modifiedUserInteraction")
    public ModifiedUserInteractionType getModifiedUserInteraction() {
        return this.modifiedUserInteraction;
    }

    @JsonProperty(value="modifiedVulnConfidentialityImpact")
    public ModifiedCiaType getModifiedVulnConfidentialityImpact() {
        return this.modifiedVulnConfidentialityImpact;
    }

    @JsonProperty(value="modifiedVulnIntegrityImpact")
    public ModifiedCiaType getModifiedVulnIntegrityImpact() {
        return this.modifiedVulnIntegrityImpact;
    }

    @JsonProperty(value="modifiedVulnAvailabilityImpact")
    public ModifiedCiaType getModifiedVulnAvailabilityImpact() {
        return this.modifiedVulnAvailabilityImpact;
    }

    @JsonProperty(value="modifiedSubConfidentialityImpact")
    public ModifiedCiaType getModifiedSubConfidentialityImpact() {
        return this.modifiedSubConfidentialityImpact;
    }

    @JsonProperty(value="modifiedSubIntegrityImpact")
    public ModifiedCiaType getModifiedSubIntegrityImpact() {
        return this.modifiedSubIntegrityImpact;
    }

    @JsonProperty(value="modifiedSubAvailabilityImpact")
    public ModifiedCiaType getModifiedSubAvailabilityImpact() {
        return this.modifiedSubAvailabilityImpact;
    }

    @JsonProperty(value="Safety")
    @JsonAlias(value={"safety"})
    public SafetyType getSafety() {
        return this.safety;
    }

    @JsonProperty(value="Automatable")
    @JsonAlias(value={"automatable"})
    public AutomatableType getAutomatable() {
        return this.automatable;
    }

    @JsonProperty(value="Recovery")
    @JsonAlias(value={"recovery"})
    public RecoveryType getRecovery() {
        return this.recovery;
    }

    @JsonProperty(value="valueDensity")
    public ValueDensityType getValueDensity() {
        return this.valueDensity;
    }

    @JsonProperty(value="vulnerabilityResponseEffort")
    public VulnerabilityResponseEffortType getVulnerabilityResponseEffort() {
        return this.vulnerabilityResponseEffort;
    }

    @JsonProperty(value="providerUrgency")
    public ProviderUrgencyType getProviderUrgency() {
        return this.providerUrgency;
    }

    @JsonProperty(value="threatScore")
    public Double getThreatScore() {
        return this.threatScore;
    }

    @JsonProperty(value="threatSeverity")
    public SeverityType getThreatSeverity() {
        return this.threatSeverity;
    }

    @JsonProperty(value="environmentalScore")
    public Double getEnvironmentalScore() {
        return this.environmentalScore;
    }

    @JsonProperty(value="environmentalSeverity")
    public SeverityType getEnvironmentalSeverity() {
        return this.environmentalSeverity;
    }

    public String toString() {
        StringBuilder v = new StringBuilder("CVSS:").append(this.version == null ? "" : this.version).append("/AV:").append(this.attackVector == null ? "" : Character.valueOf(this.attackVector.value().charAt(0))).append("/AC:").append(this.attackComplexity == null ? "" : Character.valueOf(this.attackComplexity.value().charAt(0))).append("/AT:").append(this.attackRequirements == null ? "" : Character.valueOf(this.attackRequirements.value().charAt(0))).append("/PR:").append(this.privilegesRequired == null ? "" : Character.valueOf(this.privilegesRequired.value().charAt(0))).append("/UI:").append(this.userInteraction == null ? "" : Character.valueOf(this.userInteraction.value().charAt(0))).append("/VC:").append(this.vulnConfidentialityImpact == null ? "" : Character.valueOf(this.vulnConfidentialityImpact.value().charAt(0))).append("/VI:").append(this.vulnIntegrityImpact == null ? "" : Character.valueOf(this.vulnIntegrityImpact.value().charAt(0))).append("/VA:").append(this.vulnAvailabilityImpact == null ? "" : Character.valueOf(this.vulnAvailabilityImpact.value().charAt(0))).append("/SC:").append(this.subConfidentialityImpact == null ? "" : Character.valueOf(this.subConfidentialityImpact.value().charAt(0))).append("/SI:").append(this.subIntegrityImpact == null ? "" : Character.valueOf(this.subIntegrityImpact.value().charAt(0))).append("/SA:").append(this.subAvailabilityImpact == null ? "" : Character.valueOf(this.subAvailabilityImpact.value().charAt(0)));
        if (this.exploitMaturity != null) {
            v.append("/E:").append(this.exploitMaturity == ExploitMaturityType.NOT_DEFINED ? "X" : Character.valueOf(this.exploitMaturity.value().charAt(0)));
        }
        if (this.confidentialityRequirement != null) {
            v.append("/CR:").append(this.confidentialityRequirement == CiaRequirementType.NOT_DEFINED ? "X" : Character.valueOf(this.confidentialityRequirement.value().charAt(0)));
        }
        if (this.integrityRequirement != null) {
            v.append("/IR:").append(this.integrityRequirement == CiaRequirementType.NOT_DEFINED ? "X" : Character.valueOf(this.integrityRequirement.value().charAt(0)));
        }
        if (this.availabilityRequirement != null) {
            v.append("/AR:").append(this.availabilityRequirement == CiaRequirementType.NOT_DEFINED ? "X" : Character.valueOf(this.availabilityRequirement.value().charAt(0)));
        }
        if (this.modifiedAttackVector != null) {
            v.append("/MAV:").append(this.modifiedAttackVector == ModifiedAttackVectorType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedAttackVector.value().charAt(0)));
        }
        if (this.modifiedAttackComplexity != null) {
            v.append("/MAC:").append(this.modifiedAttackComplexity == ModifiedAttackComplexityType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedAttackComplexity.value().charAt(0)));
        }
        if (this.modifiedAttackRequirements != null) {
            v.append("/MAT:").append(this.modifiedAttackRequirements == ModifiedAttackRequirementsType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedAttackRequirements.value().charAt(0)));
        }
        if (this.modifiedPrivilegesRequired != null) {
            v.append("/MPR:").append(this.modifiedPrivilegesRequired == ModifiedPrivilegesRequiredType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedPrivilegesRequired.value().charAt(0)));
        }
        if (this.modifiedUserInteraction != null) {
            v.append("/MUI:").append(this.modifiedUserInteraction == ModifiedUserInteractionType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedUserInteraction.value().charAt(0)));
        }
        if (this.modifiedVulnConfidentialityImpact != null) {
            v.append("/MVC:").append(this.modifiedVulnConfidentialityImpact == ModifiedCiaType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedVulnConfidentialityImpact.value().charAt(0)));
        }
        if (this.modifiedVulnIntegrityImpact != null) {
            v.append("/MVI:").append(this.modifiedVulnIntegrityImpact == ModifiedCiaType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedVulnIntegrityImpact.value().charAt(0)));
        }
        if (this.modifiedVulnAvailabilityImpact != null) {
            v.append("/MVA:").append(this.modifiedVulnAvailabilityImpact == ModifiedCiaType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedVulnAvailabilityImpact.value().charAt(0)));
        }
        if (this.modifiedSubConfidentialityImpact != null) {
            v.append("/MSC:").append(this.modifiedSubConfidentialityImpact == ModifiedCiaType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedSubConfidentialityImpact.value().charAt(0)));
        }
        if (this.modifiedSubIntegrityImpact != null) {
            v.append("/MSI:").append(this.modifiedSubIntegrityImpact == ModifiedCiaType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedSubIntegrityImpact.value().charAt(0)));
        }
        if (this.modifiedSubAvailabilityImpact != null) {
            v.append("/MSA:").append(this.modifiedSubAvailabilityImpact == ModifiedCiaType.NOT_DEFINED ? "X" : Character.valueOf(this.modifiedSubAvailabilityImpact.value().charAt(0)));
        }
        if (this.safety != null) {
            v.append("/S:").append(this.safety == SafetyType.NOT_DEFINED ? "X" : Character.valueOf(this.safety.value().charAt(0)));
        }
        if (this.automatable != null) {
            v.append("/AU:").append(this.automatable == AutomatableType.NOT_DEFINED ? "X" : Character.valueOf(this.automatable.value().charAt(0)));
        }
        if (this.recovery != null) {
            v.append("/R:").append(this.recovery.value().charAt(0));
        }
        if (this.valueDensity != null) {
            v.append("/V:").append(this.valueDensity == ValueDensityType.NOT_DEFINED ? "X" : Character.valueOf(this.valueDensity.value().charAt(0)));
        }
        if (this.vulnerabilityResponseEffort != null) {
            v.append("/RE:").append(this.vulnerabilityResponseEffort == VulnerabilityResponseEffortType.NOT_DEFINED ? "X" : Character.valueOf(this.vulnerabilityResponseEffort.value().charAt(0)));
        }
        if (this.providerUrgency != null) {
            v.append("/U:");
            if (this.providerUrgency == ProviderUrgencyType.NOT_DEFINED) {
                v.append("X");
            } else {
                v.append(this.providerUrgency.value().charAt(0)).append(this.providerUrgency.value().substring(1).toLowerCase());
            }
        }
        return v.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CvssV4Data)) {
            return false;
        }
        CvssV4Data that = (CvssV4Data)o;
        return this.version == that.version && Objects.equals(this.vectorString, that.vectorString) && this.attackVector == that.attackVector && this.attackComplexity == that.attackComplexity && this.attackRequirements == that.attackRequirements && this.privilegesRequired == that.privilegesRequired && this.userInteraction == that.userInteraction && this.vulnConfidentialityImpact == that.vulnConfidentialityImpact && this.vulnIntegrityImpact == that.vulnIntegrityImpact && this.vulnAvailabilityImpact == that.vulnAvailabilityImpact && this.subConfidentialityImpact == that.subConfidentialityImpact && this.subIntegrityImpact == that.subIntegrityImpact && this.subAvailabilityImpact == that.subAvailabilityImpact && this.exploitMaturity == that.exploitMaturity && this.confidentialityRequirement == that.confidentialityRequirement && this.integrityRequirement == that.integrityRequirement && this.availabilityRequirement == that.availabilityRequirement && this.modifiedAttackVector == that.modifiedAttackVector && this.modifiedAttackComplexity == that.modifiedAttackComplexity && this.modifiedAttackRequirements == that.modifiedAttackRequirements && this.modifiedPrivilegesRequired == that.modifiedPrivilegesRequired && this.modifiedUserInteraction == that.modifiedUserInteraction && this.modifiedVulnConfidentialityImpact == that.modifiedVulnConfidentialityImpact && this.modifiedVulnIntegrityImpact == that.modifiedVulnIntegrityImpact && this.modifiedVulnAvailabilityImpact == that.modifiedVulnAvailabilityImpact && this.modifiedSubConfidentialityImpact == that.modifiedSubConfidentialityImpact && this.modifiedSubIntegrityImpact == that.modifiedSubIntegrityImpact && this.modifiedSubAvailabilityImpact == that.modifiedSubAvailabilityImpact && this.safety == that.safety && this.automatable == that.automatable && this.recovery == that.recovery && this.valueDensity == that.valueDensity && this.vulnerabilityResponseEffort == that.vulnerabilityResponseEffort && this.providerUrgency == that.providerUrgency && Objects.equals(this.baseScore, that.baseScore) && this.baseSeverity == that.baseSeverity && Objects.equals(this.threatScore, that.threatScore) && this.threatSeverity == that.threatSeverity && Objects.equals(this.environmentalScore, that.environmentalScore) && this.environmentalSeverity == that.environmentalSeverity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.vectorString, this.attackVector, this.attackComplexity, this.attackRequirements, this.privilegesRequired, this.userInteraction, this.vulnConfidentialityImpact, this.vulnIntegrityImpact, this.vulnAvailabilityImpact, this.subConfidentialityImpact, this.subIntegrityImpact, this.subAvailabilityImpact, this.exploitMaturity, this.confidentialityRequirement, this.integrityRequirement, this.availabilityRequirement, this.modifiedAttackVector, this.modifiedAttackComplexity, this.modifiedAttackRequirements, this.modifiedPrivilegesRequired, this.modifiedUserInteraction, this.modifiedVulnConfidentialityImpact, this.modifiedVulnIntegrityImpact, this.modifiedVulnAvailabilityImpact, this.modifiedSubConfidentialityImpact, this.modifiedSubIntegrityImpact, this.modifiedSubAvailabilityImpact, this.safety, this.automatable, this.recovery, this.valueDensity, this.vulnerabilityResponseEffort, this.providerUrgency, this.baseScore, this.baseSeverity, this.threatScore, this.threatSeverity, this.environmentalScore, this.environmentalSeverity});
    }

    public static enum Version {
        _4_0("4.0");

        private static final Map<String, Version> CONSTANTS;
        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Version fromValue(String value) {
            Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Version>();
            for (Version c : Version.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum UserInteractionType {
        NONE("NONE"),
        PASSIVE("PASSIVE"),
        ACTIVE("ACTIVE");

        private static final Map<String, UserInteractionType> CONSTANTS;
        private final String value;

        private UserInteractionType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UserInteractionType fromValue(String value) {
            UserInteractionType constant;
            if (value != null && value.length() == 1) {
                for (UserInteractionType t : UserInteractionType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, UserInteractionType>();
            for (UserInteractionType c : UserInteractionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SeverityType {
        NONE("NONE"),
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        CRITICAL("CRITICAL");

        private static final Map<String, SeverityType> CONSTANTS;
        private final String value;

        private SeverityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SeverityType fromValue(String value) {
            SeverityType constant;
            if (value != null && value.length() == 1) {
                for (SeverityType t : SeverityType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, SeverityType>();
            for (SeverityType c : SeverityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum RemediationLevelType {
        OFFICIAL_FIX("OFFICIAL_FIX"),
        TEMPORARY_FIX("TEMPORARY_FIX"),
        WORKAROUND("WORKAROUND"),
        UNAVAILABLE("UNAVAILABLE"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, RemediationLevelType> CONSTANTS;
        private final String value;

        private RemediationLevelType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RemediationLevelType fromValue(String value) {
            RemediationLevelType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (RemediationLevelType t : RemediationLevelType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, RemediationLevelType>();
            for (RemediationLevelType c : RemediationLevelType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum PrivilegesRequiredType {
        HIGH("HIGH"),
        LOW("LOW"),
        NONE("NONE");

        private static final Map<String, PrivilegesRequiredType> CONSTANTS;
        private final String value;

        private PrivilegesRequiredType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PrivilegesRequiredType fromValue(String value) {
            PrivilegesRequiredType constant;
            if (value != null && value.length() == 1) {
                for (PrivilegesRequiredType t : PrivilegesRequiredType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, PrivilegesRequiredType>();
            for (PrivilegesRequiredType c : PrivilegesRequiredType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedUserInteractionType {
        NONE("NONE"),
        PASSIVE("PASSIVE"),
        ACTIVE("ACTIVE"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedUserInteractionType> CONSTANTS;
        private final String value;

        private ModifiedUserInteractionType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedUserInteractionType fromValue(String value) {
            ModifiedUserInteractionType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedUserInteractionType t : ModifiedUserInteractionType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedUserInteractionType>();
            for (ModifiedUserInteractionType c : ModifiedUserInteractionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedVulnCiaType {
        NONE("NONE"),
        LOW("LOW"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedVulnCiaType> CONSTANTS;
        private final String value;

        private ModifiedVulnCiaType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedVulnCiaType fromValue(String value) {
            ModifiedVulnCiaType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedVulnCiaType t : ModifiedVulnCiaType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedVulnCiaType>();
            for (ModifiedVulnCiaType c : ModifiedVulnCiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedPrivilegesRequiredType {
        HIGH("HIGH"),
        LOW("LOW"),
        NONE("NONE"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedPrivilegesRequiredType> CONSTANTS;
        private final String value;

        private ModifiedPrivilegesRequiredType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedPrivilegesRequiredType fromValue(String value) {
            ModifiedPrivilegesRequiredType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedPrivilegesRequiredType t : ModifiedPrivilegesRequiredType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedPrivilegesRequiredType>();
            for (ModifiedPrivilegesRequiredType c : ModifiedPrivilegesRequiredType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ProviderUrgencyType {
        CLEAR("CLEAR"),
        GREEN("GREEN"),
        AMBER("AMBER"),
        RED("RED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ProviderUrgencyType> CONSTANTS;
        private final String value;

        private ProviderUrgencyType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ProviderUrgencyType fromValue(String value) {
            ProviderUrgencyType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ProviderUrgencyType t : ProviderUrgencyType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ProviderUrgencyType>();
            for (ProviderUrgencyType c : ProviderUrgencyType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum VulnerabilityResponseEffortType {
        LOW("LOW"),
        MODERATE("MODERATE"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, VulnerabilityResponseEffortType> CONSTANTS;
        private final String value;

        private VulnerabilityResponseEffortType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static VulnerabilityResponseEffortType fromValue(String value) {
            VulnerabilityResponseEffortType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (VulnerabilityResponseEffortType t : VulnerabilityResponseEffortType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, VulnerabilityResponseEffortType>();
            for (VulnerabilityResponseEffortType c : VulnerabilityResponseEffortType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ValueDensityType {
        DIFFUSE("DIFFUSE"),
        CONCENTRATED("CONCENTRATED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ValueDensityType> CONSTANTS;
        private final String value;

        private ValueDensityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ValueDensityType fromValue(String value) {
            ValueDensityType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ValueDensityType t : ValueDensityType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ValueDensityType>();
            for (ValueDensityType c : ValueDensityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum RecoveryType {
        AUTOMATIC("AUTOMATIC"),
        USER("USER"),
        IRRECOVERABLE("IRRECOVERABLE"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, RecoveryType> CONSTANTS;
        private final String value;

        private RecoveryType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RecoveryType fromValue(String value) {
            RecoveryType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (RecoveryType t : RecoveryType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, RecoveryType>();
            for (RecoveryType c : RecoveryType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AutomatableType {
        NO("NO"),
        YES("YES"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, AutomatableType> CONSTANTS;
        private final String value;

        private AutomatableType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AutomatableType fromValue(String value) {
            AutomatableType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (AutomatableType t : AutomatableType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AutomatableType>();
            for (AutomatableType c : AutomatableType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SafetyType {
        NEGLIGIBLE("NEGLIGIBLE"),
        PRESENT("PRESENT"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, SafetyType> CONSTANTS;
        private final String value;

        private SafetyType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SafetyType fromValue(String value) {
            SafetyType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (SafetyType t : SafetyType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, SafetyType>();
            for (SafetyType c : SafetyType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedCiaType {
        NONE("NONE"),
        LOW("LOW"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedCiaType> CONSTANTS;
        private final String value;

        private ModifiedCiaType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedCiaType fromValue(String value) {
            ModifiedCiaType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedCiaType t : ModifiedCiaType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedCiaType>();
            for (ModifiedCiaType c : ModifiedCiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedAttackVectorType {
        NETWORK("NETWORK"),
        ADJACENT("ADJACENT"),
        LOCAL("LOCAL"),
        PHYSICAL("PHYSICAL"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedAttackVectorType> CONSTANTS;
        private final String value;

        private ModifiedAttackVectorType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedAttackVectorType fromValue(String value) {
            ModifiedAttackVectorType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedAttackVectorType t : ModifiedAttackVectorType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedAttackVectorType>();
            for (ModifiedAttackVectorType c : ModifiedAttackVectorType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedAttackRequirementsType {
        NONE("NONE"),
        PRESENT("PRESENT"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedAttackRequirementsType> CONSTANTS;
        private final String value;

        private ModifiedAttackRequirementsType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedAttackRequirementsType fromValue(String value) {
            ModifiedAttackRequirementsType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedAttackRequirementsType t : ModifiedAttackRequirementsType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedAttackRequirementsType>();
            for (ModifiedAttackRequirementsType c : ModifiedAttackRequirementsType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AttackRequirementsType {
        NONE("NONE"),
        PRESENT("PRESENT");

        private static final Map<String, AttackRequirementsType> CONSTANTS;
        private final String value;

        private AttackRequirementsType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AttackRequirementsType fromValue(String value) {
            AttackRequirementsType constant;
            if (value != null && value.length() == 1) {
                for (AttackRequirementsType t : AttackRequirementsType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AttackRequirementsType>();
            for (AttackRequirementsType c : AttackRequirementsType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedAttackComplexityType {
        HIGH("HIGH"),
        LOW("LOW"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedAttackComplexityType> CONSTANTS;
        private final String value;

        private ModifiedAttackComplexityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedAttackComplexityType fromValue(String value) {
            ModifiedAttackComplexityType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedAttackComplexityType t : ModifiedAttackComplexityType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedAttackComplexityType>();
            for (ModifiedAttackComplexityType c : ModifiedAttackComplexityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ExploitMaturityType {
        UNREPORTED("UNREPORTED"),
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT"),
        ATTACKED("ATTACKED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ExploitMaturityType> CONSTANTS;
        private final String value;

        private ExploitMaturityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExploitMaturityType fromValue(String value) {
            ExploitMaturityType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ExploitMaturityType t : ExploitMaturityType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ExploitMaturityType>();
            for (ExploitMaturityType c : ExploitMaturityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaType {
        NONE("NONE"),
        LOW("LOW"),
        HIGH("HIGH");

        private static final Map<String, CiaType> CONSTANTS;
        private final String value;

        private CiaType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CiaType fromValue(String value) {
            CiaType constant;
            if (value != null && value.length() == 1) {
                for (CiaType t : CiaType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CiaType>();
            for (CiaType c : CiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaRequirementType {
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, CiaRequirementType> CONSTANTS;
        private final String value;

        private CiaRequirementType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CiaRequirementType fromValue(String value) {
            CiaRequirementType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (CiaRequirementType t : CiaRequirementType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CiaRequirementType>();
            for (CiaRequirementType c : CiaRequirementType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AttackVectorType {
        NETWORK("NETWORK"),
        ADJACENT("ADJACENT"),
        LOCAL("LOCAL"),
        PHYSICAL("PHYSICAL");

        private static final Map<String, AttackVectorType> CONSTANTS;
        private final String value;

        private AttackVectorType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AttackVectorType fromValue(String value) {
            AttackVectorType constant;
            if (value != null && value.length() == 1) {
                for (AttackVectorType t : AttackVectorType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AttackVectorType>();
            for (AttackVectorType c : AttackVectorType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AttackComplexityType {
        HIGH("HIGH"),
        LOW("LOW");

        private static final Map<String, AttackComplexityType> CONSTANTS;
        private final String value;

        private AttackComplexityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AttackComplexityType fromValue(String value) {
            AttackComplexityType constant;
            if (value != null && value.length() == 1) {
                for (AttackComplexityType t : AttackComplexityType.values()) {
                    if (!t.value.startsWith(value.toUpperCase())) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AttackComplexityType>();
            for (AttackComplexityType c : AttackComplexityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

