/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.model.Nullable;
import io.quarkus.registry.model.Release;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableRelease
implements Release {
    private final String version;
    @Nullable
    private final String quarkusCore;
    @Nullable
    private final String repositoryURL;

    private ImmutableRelease(String version, @Nullable String quarkusCore, @Nullable String repositoryURL) {
        this.version = version;
        this.quarkusCore = quarkusCore;
        this.repositoryURL = repositoryURL;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="quarkus-core")
    @Nullable
    public String getQuarkusCore() {
        return this.quarkusCore;
    }

    @Override
    @JsonProperty(value="repository-url")
    @Nullable
    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public final ImmutableRelease withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableRelease(newValue, this.quarkusCore, this.repositoryURL);
    }

    public final ImmutableRelease withQuarkusCore(@Nullable String value) {
        if (Objects.equals(this.quarkusCore, value)) {
            return this;
        }
        return new ImmutableRelease(this.version, value, this.repositoryURL);
    }

    public final ImmutableRelease withRepositoryURL(@Nullable String value) {
        if (Objects.equals(this.repositoryURL, value)) {
            return this;
        }
        return new ImmutableRelease(this.version, this.quarkusCore, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelease && this.equalTo((ImmutableRelease)another);
    }

    private boolean equalTo(ImmutableRelease another) {
        return this.version.equals(another.version) && Objects.equals(this.quarkusCore, another.quarkusCore);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + Objects.hashCode(this.quarkusCore);
        return h;
    }

    public String toString() {
        return "Release{version=" + this.version + ", quarkusCore=" + this.quarkusCore + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRelease fromJson(Json json) {
        Builder builder = ImmutableRelease.builder();
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.quarkusCore != null) {
            builder.quarkusCore(json.quarkusCore);
        }
        if (json.repositoryURL != null) {
            builder.repositoryURL(json.repositoryURL);
        }
        return builder.build();
    }

    public static ImmutableRelease copyOf(Release instance) {
        if (instance instanceof ImmutableRelease) {
            return (ImmutableRelease)instance;
        }
        return ImmutableRelease.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private long initBits = 1L;
        private String version;
        private String quarkusCore;
        private String repositoryURL;

        private Builder() {
        }

        public final Builder from(Release instance) {
            String repositoryURLValue;
            Objects.requireNonNull(instance, "instance");
            this.version(instance.getVersion());
            String quarkusCoreValue = instance.getQuarkusCore();
            if (quarkusCoreValue != null) {
                this.quarkusCore(quarkusCoreValue);
            }
            if ((repositoryURLValue = instance.getRepositoryURL()) != null) {
                this.repositoryURL(repositoryURLValue);
            }
            return this;
        }

        @JsonProperty(value="version")
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="quarkus-core")
        public final Builder quarkusCore(@Nullable String quarkusCore) {
            this.quarkusCore = quarkusCore;
            return this;
        }

        @JsonProperty(value="repository-url")
        public final Builder repositoryURL(@Nullable String repositoryURL) {
            this.repositoryURL = repositoryURL;
            return this;
        }

        public ImmutableRelease build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelease(this.version, this.quarkusCore, this.repositoryURL);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build Release, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Release {
        String version;
        String quarkusCore;
        String repositoryURL;

        Json() {
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty(value="quarkus-core")
        public void setQuarkusCore(@Nullable String quarkusCore) {
            this.quarkusCore = quarkusCore;
        }

        @JsonProperty(value="repository-url")
        public void setRepositoryURL(@Nullable String repositoryURL) {
            this.repositoryURL = repositoryURL;
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getQuarkusCore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRepositoryURL() {
            throw new UnsupportedOperationException();
        }
    }
}

