/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.messagewriter;

import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.PrintStream;

final class DefaultMessageWriter
implements MessageWriter {
    protected final PrintStream out;
    protected boolean debug;

    DefaultMessageWriter() {
        this(System.out, false);
    }

    DefaultMessageWriter(PrintStream out) {
        this(out, false);
    }

    DefaultMessageWriter(boolean debug) {
        this(System.out, debug);
    }

    DefaultMessageWriter(PrintStream out, boolean debug) {
        this.out = out;
        this.debug = debug;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    @Override
    public void info(String msg) {
        this.out.println(msg);
    }

    @Override
    public void error(String msg) {
        this.out.println("\u2757 " + msg);
    }

    @Override
    public void debug(String msg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.out.println("[DEBUG] " + msg);
    }

    @Override
    public void warn(String msg) {
        this.out.println("\ud83d\udd25 " + msg);
    }
}

