/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.runtime.metrics.MetricsFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public class MicrometerMetricsFactory
implements MetricsFactory {
    final MeterRegistry globalRegistry;
    final MicrometerConfig config;

    public MicrometerMetricsFactory(MicrometerConfig config, MeterRegistry globalRegistry) {
        this.globalRegistry = globalRegistry;
        this.config = config;
    }

    public boolean metricsSystemSupported(String name) {
        return "micrometer".equals(name) || "smallrye-metrics".equals(name) && this.config.binder.mpMetrics.enabled.orElse(false) != false;
    }

    public MetricsFactory.MetricBuilder builder(String name, MetricsFactory.Type type) {
        return new MicrometerMetricsBuilder(name);
    }

    static class MicrometerTimeRecorder
    implements MetricsFactory.TimeRecorder {
        Timer timer;

        MicrometerTimeRecorder(Timer timer) {
            this.timer = timer;
        }

        public void update(long amount, TimeUnit unit) {
            this.timer.record(amount, unit);
        }
    }

    class MicrometerMetricsBuilder
    implements MetricsFactory.MetricBuilder {
        String name;
        String description;
        String unit;
        Tags tags = Tags.empty();

        public MicrometerMetricsBuilder(String name) {
            this.name = name;
        }

        public MetricsFactory.MetricBuilder description(String description) {
            this.description = description;
            return this;
        }

        public MetricsFactory.MetricBuilder tag(String key, String value) {
            this.tags = this.tags.and(key, value);
            return this;
        }

        public MetricsFactory.MetricBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public void buildCounter(Supplier<Number> countFunction) {
            FunctionCounter.builder((String)this.name, countFunction, x -> ((Number)countFunction.get()).doubleValue()).description(this.description).baseUnit(this.unit).tags((Iterable)this.tags).register(MicrometerMetricsFactory.this.globalRegistry);
        }

        public <T, R extends Number> void buildCounter(T obj, Function<T, R> countFunction) {
            FunctionCounter.builder((String)this.name, obj, x -> ((Number)countFunction.apply(x)).doubleValue()).description(this.description).baseUnit(this.unit).tags((Iterable)this.tags).register(MicrometerMetricsFactory.this.globalRegistry);
        }

        public void buildGauge(Supplier<Number> gaugeFunction) {
            Gauge.builder((String)this.name, gaugeFunction).description(this.description).baseUnit(this.unit).tags((Iterable)this.tags).strongReference(true).register(MicrometerMetricsFactory.this.globalRegistry);
        }

        public <T, R extends Number> void buildGauge(T obj, Function<T, R> gaugeFunction) {
            Gauge.builder((String)this.name, obj, x -> ((Number)gaugeFunction.apply(obj)).doubleValue()).description(this.description).baseUnit(this.unit).tags((Iterable)this.tags).strongReference(true).register(MicrometerMetricsFactory.this.globalRegistry);
        }

        public MetricsFactory.TimeRecorder buildTimer() {
            Timer timer = Timer.builder((String)this.name).description(this.description).tags((Iterable)this.tags).register(MicrometerMetricsFactory.this.globalRegistry);
            return new MicrometerTimeRecorder(timer);
        }

        public Runnable buildTimer(Runnable f) {
            Timer timer = Timer.builder((String)this.name).description(this.description).tags((Iterable)this.tags).register(MicrometerMetricsFactory.this.globalRegistry);
            return timer.wrap(f);
        }

        public <T> Callable<T> buildTimer(Callable<T> f) {
            Timer timer = Timer.builder((String)this.name).description(this.description).tags((Iterable)this.tags).register(MicrometerMetricsFactory.this.globalRegistry);
            return timer.wrap(f);
        }

        public <T> Supplier<T> buildTimer(Supplier<T> f) {
            Timer timer = Timer.builder((String)this.name).description(this.description).tags((Iterable)this.tags).register(MicrometerMetricsFactory.this.globalRegistry);
            return timer.wrap(f);
        }
    }
}

