/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.panache.common.deployment.ByteCodeType;
import io.quarkus.panache.common.deployment.PanacheConstants;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerVisitor;
import io.quarkus.panache.common.deployment.TypeBundle;
import io.quarkus.panache.common.deployment.visitors.KotlinPanacheClassOperationGenerationVisitor;
import io.quarkus.panache.common.deployment.visitors.PanacheRepositoryClassOperationGenerationVisitor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class PanacheEntityClassOperationGenerationVisitor
extends ClassVisitor {
    protected org.objectweb.asm.Type thisClass;
    private final Set<String> userMethods = new HashSet<String>();
    protected TypeBundle typeBundle;
    protected final ClassInfo panacheEntityBaseClassInfo;
    protected ClassInfo entityInfo;
    protected List<PanacheMethodCustomizer> methodCustomizers;
    protected final Map<String, ByteCodeType> typeArguments = new HashMap<String, ByteCodeType>();
    protected final Function<String, String> argMapper;
    protected final ByteCodeType entityUpperBound;
    private final Map<String, String> erasures = new HashMap<String, String>();

    public PanacheEntityClassOperationGenerationVisitor(ClassVisitor outputClassVisitor, TypeBundle typeBundle, ClassInfo entityInfo, List<PanacheMethodCustomizer> methodCustomizers, IndexView indexView) {
        super(589824, outputClassVisitor);
        String className = entityInfo.name().toString();
        this.thisClass = org.objectweb.asm.Type.getType((String)("L" + className.replace('.', '/') + ";"));
        this.typeBundle = typeBundle;
        this.panacheEntityBaseClassInfo = indexView.getClassByName(typeBundle.entityBase().dotName());
        this.entityInfo = entityInfo;
        this.methodCustomizers = methodCustomizers;
        ByteCodeType baseType = typeBundle.entityBase();
        List typeVariables = indexView.getClassByName(baseType.dotName()).typeParameters();
        this.entityUpperBound = !typeVariables.isEmpty() ? new ByteCodeType((Type)((TypeVariable)typeVariables.get(0)).bounds().get(0)) : null;
        this.discoverTypeParameters(entityInfo, indexView, typeBundle, baseType);
        this.argMapper = type -> {
            ByteCodeType byteCodeType = this.typeArguments.get(type);
            return byteCodeType != null ? byteCodeType.descriptor() : KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor();
        };
    }

    public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
        this.userMethods.add(methodName + "/" + descriptor);
        MethodVisitor superVisitor = super.visitMethod(access, methodName, descriptor, signature, exceptions);
        if (Modifier.isStatic(access) && Modifier.isPublic(access) && (access & 0x1000) == 0 && !this.methodCustomizers.isEmpty()) {
            Object[] argTypes = AsmUtil.getParameterTypes((String)descriptor);
            MethodInfo method = this.entityInfo.method(methodName, (Type[])argTypes);
            if (method == null) {
                throw new IllegalStateException("Could not find indexed method: " + this.thisClass + "." + methodName + " with descriptor " + descriptor + " and arg types " + Arrays.toString(argTypes));
            }
            superVisitor = new PanacheMethodCustomizerVisitor(superVisitor, method, this.thisClass, this.methodCustomizers);
        }
        return superVisitor;
    }

    public void visitEnd() {
        for (MethodInfo method : this.panacheEntityBaseClassInfo.methods()) {
            AnnotationInstance bridge;
            String descriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> null);
            if (this.userMethods.contains(method.name() + "/" + descriptor) || (bridge = method.annotation(PanacheConstants.DOTNAME_GENERATE_BRIDGE)) == null) continue;
            this.generateMethod(method, bridge.value("targetReturnTypeErased"), bridge.value("callSuperMethod"));
        }
        super.visitEnd();
    }

    protected void discoverTypeParameters(ClassInfo classInfo, IndexView indexView, TypeBundle types, ByteCodeType baseType) {
        List<ByteCodeType> foundTypeArguments = KotlinPanacheClassOperationGenerationVisitor.recursivelyFindEntityTypeArguments(indexView, classInfo.name(), baseType.dotName());
        ByteCodeType entityType = foundTypeArguments.size() > 0 ? foundTypeArguments.get(0) : KotlinPanacheClassOperationGenerationVisitor.OBJECT;
        ByteCodeType idType = foundTypeArguments.size() > 1 ? foundTypeArguments.get(1) : KotlinPanacheClassOperationGenerationVisitor.OBJECT;
        this.typeArguments.put("Entity", entityType);
        this.typeArguments.put("Id", idType);
        this.typeArguments.keySet().stream().filter(k -> !k.equals("Id")).forEach(k -> this.erasures.put((String)k, KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor()));
        try {
            ByteCodeType entity = this.typeArguments.get("Entity");
            if (entity != null) {
                this.erasures.put(entity.dotName().toString(), entity.descriptor());
            }
            this.erasures.put(types.queryType().dotName().toString(), KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor());
            this.erasures.put(types.updateType().dotName().toString(), KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected void generateMethod(MethodInfo method, AnnotationValue targetReturnTypeErased, AnnotationValue callSuperMethod) {
        List parameters = method.parameters();
        MethodVisitor mv = super.visitMethod(4105, method.name(), AsmUtil.getDescriptor((MethodInfo)method, name -> null), AsmUtil.getSignature((MethodInfo)method, name1 -> null), null);
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        mv.visitCode();
        for (PanacheMethodCustomizer customizer : this.methodCustomizers) {
            customizer.customize(this.thisClass, method, mv);
        }
        if (callSuperMethod != null && callSuperMethod.asBoolean()) {
            for (int i = 0; i < parameters.size(); ++i) {
                mv.visitIntInsn(25, i);
            }
            this.invokeOperations(mv, method, true);
        } else {
            this.loadOperations(mv);
            this.loadArguments(mv, parameters);
            this.invokeOperations(mv, method, false);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void loadOperations(MethodVisitor mv) {
        mv.visitFieldInsn(178, this.typeBundle.operations().internalName(), "INSTANCE", this.typeBundle.operations().descriptor());
    }

    private void loadArguments(MethodVisitor mv, List<Type> parameters) {
        this.injectModel(mv);
        for (int i = 0; i < parameters.size(); ++i) {
            mv.visitIntInsn(25, i);
        }
    }

    private void invokeOperations(MethodVisitor mv, MethodInfo method, boolean callSuperMethod) {
        StringJoiner joiner = new StringJoiner("", "(", ")");
        if (!callSuperMethod) {
            joiner.add(PanacheRepositoryClassOperationGenerationVisitor.CLASS.descriptor());
        }
        this.descriptors(method, joiner);
        Type returnType = method.returnType();
        String descriptor = AsmUtil.getDescriptor((Type)returnType, this.argMapper);
        String key = returnType.kind() == Type.Kind.TYPE_VARIABLE ? returnType.asTypeVariable().identifier() : returnType.name().toString();
        String operationDescriptor = joiner + this.erasures.getOrDefault(key, descriptor);
        if (callSuperMethod) {
            mv.visitMethodInsn(184, this.typeBundle.entityBase().internalName(), method.name(), operationDescriptor, false);
        } else {
            mv.visitMethodInsn(182, this.typeBundle.operations().internalName(), method.name(), operationDescriptor, false);
        }
        if (returnType.kind() != Type.Kind.PRIMITIVE && returnType.kind() != Type.Kind.VOID) {
            String cast;
            if (returnType.kind() == Type.Kind.TYPE_VARIABLE) {
                TypeVariable typeVariable = returnType.asTypeVariable();
                ByteCodeType type = this.typeArguments.get(typeVariable.identifier());
                type = type == null && typeVariable.bounds().size() != 1 ? KotlinPanacheClassOperationGenerationVisitor.OBJECT : new ByteCodeType((Type)typeVariable.bounds().get(0));
                cast = type.internalName();
            } else {
                cast = returnType.name().toString().replace('.', '/');
            }
            mv.visitTypeInsn(192, cast);
        }
        mv.visitInsn(AsmUtil.getReturnInstruction((Type)returnType));
    }

    private void descriptors(MethodInfo method, StringJoiner joiner) {
        for (Type parameter : method.parameters()) {
            if (parameter.kind() == Type.Kind.TYPE_VARIABLE || method.name().endsWith("ById") && parameter.name().equals((Object)this.typeArguments.get("Id").dotName())) {
                joiner.add(KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor());
                continue;
            }
            joiner.add(this.mapType(parameter));
        }
    }

    private String mapType(Type parameter) {
        String descriptor;
        switch (parameter.kind()) {
            case PRIMITIVE: 
            case TYPE_VARIABLE: {
                descriptor = KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor();
                break;
            }
            default: {
                String value = AsmUtil.getDescriptor((Type)parameter, this.argMapper);
                descriptor = this.erasures.getOrDefault(value, value);
            }
        }
        return descriptor;
    }

    protected void injectModel(MethodVisitor mv) {
        mv.visitLdcInsn((Object)this.thisClass);
    }
}

