/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Exclusion;

public class PomUtils {
    public static Model toModel(DecomposedBom decomposed) {
        return PomUtils.toModel(decomposed, null);
    }

    public static Model toModel(DecomposedBom decomposed, Model baseModel) {
        DependencyManagement dm = new DependencyManagement();
        HashMap<String, Dependency> artifacts = new HashMap<String, Dependency>();
        for (ProjectRelease projectRelease : decomposed.releases()) {
            for (ProjectDependency dep : projectRelease.dependencies()) {
                artifacts.put(dep.key().toString(), PomUtils.toModelDep(dep));
            }
        }
        ArrayList keys = new ArrayList(artifacts.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            dm.addDependency((Dependency)artifacts.get(key));
        }
        Model model = PomUtils.initModel(baseModel);
        model.setGroupId(decomposed.bomArtifact().getGroupId());
        model.setArtifactId(decomposed.bomArtifact().getArtifactId());
        model.setVersion(decomposed.bomArtifact().getVersion());
        model.setDependencyManagement(dm);
        return model;
    }

    public static Model initModel(Model baseModel) {
        Model model = new Model();
        model.setModelVersion(PomUtils.modelVersion(baseModel));
        model.setGroupId(baseModel == null ? null : baseModel.getGroupId());
        model.setArtifactId(baseModel == null ? null : baseModel.getArtifactId());
        model.setVersion(baseModel == null ? null : baseModel.getVersion());
        model.setPackaging(baseModel == null ? "pom" : baseModel.getPackaging());
        model.setName(PomUtils.name(baseModel));
        model.setDescription(PomUtils.description(baseModel));
        model.setUrl(PomUtils.url(baseModel));
        model.setDevelopers(PomUtils.developers(baseModel));
        model.setLicenses(PomUtils.licenses(baseModel));
        model.setScm(PomUtils.scm(baseModel));
        model.setCiManagement(PomUtils.ciManagement(baseModel));
        model.setIssueManagement(PomUtils.issueManagement(baseModel));
        model.setDistributionManagement(PomUtils.distributionManagement(baseModel));
        return model;
    }

    public static Dependency toModelDep(ProjectDependency dep) {
        Boolean optional;
        org.eclipse.aether.graph.Dependency aetherDep = dep.dependency();
        Artifact a = dep.artifact();
        Dependency modelDep = new Dependency();
        modelDep.setGroupId(a.getGroupId());
        modelDep.setArtifactId(a.getArtifactId());
        if (!a.getClassifier().isEmpty()) {
            modelDep.setClassifier(a.getClassifier());
        }
        if (!"jar".equals(a.getExtension())) {
            modelDep.setType(a.getExtension());
        }
        modelDep.setVersion(a.getVersion());
        String scope = aetherDep.getScope();
        if (scope != null && !scope.isEmpty() && !"compile".equals(scope)) {
            modelDep.setScope(scope);
        }
        if ((optional = aetherDep.getOptional()) != null && optional.booleanValue()) {
            modelDep.setOptional(true);
        }
        if (!aetherDep.getExclusions().isEmpty()) {
            for (Exclusion aetherExcl : aetherDep.getExclusions()) {
                org.apache.maven.model.Exclusion modelExcl = new org.apache.maven.model.Exclusion();
                modelExcl.setGroupId(aetherExcl.getGroupId());
                modelExcl.setArtifactId(aetherExcl.getArtifactId());
                modelDep.addExclusion(modelExcl);
            }
        }
        return modelDep;
    }

    public static void toPom(DecomposedBom decomposed, Path file) throws IOException {
        PomUtils.toPom(decomposed, file, null);
    }

    public static void toPom(DecomposedBom decomposed, Path file, Model baseModel) throws IOException {
        if (!Files.exists(file.getParent(), new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        ModelUtils.persistModel((Path)file, (Model)PomUtils.toModel(decomposed, baseModel));
    }

    private static String modelVersion(Model base) {
        return base == null ? "4.0.0" : base.getModelVersion();
    }

    private static String name(Model base) {
        return base == null ? "Generated Quarkus platform BOM" : base.getName();
    }

    private static String description(Model base) {
        return base == null ? "Generated Quarkus platform BOM" : base.getDescription();
    }

    private static String url(Model base) {
        return base == null ? null : base.getUrl();
    }

    private static List<Developer> developers(Model base) {
        return base == null ? Collections.emptyList() : base.getDevelopers();
    }

    private static List<License> licenses(Model base) {
        return base == null ? Collections.emptyList() : base.getLicenses();
    }

    private static Scm scm(Model base) {
        return base == null ? null : base.getScm();
    }

    private static CiManagement ciManagement(Model base) {
        return base == null ? null : base.getCiManagement();
    }

    private static IssueManagement issueManagement(Model base) {
        return base == null ? null : base.getIssueManagement();
    }

    private static DistributionManagement distributionManagement(Model base) {
        return base == null ? null : base.getDistributionManagement();
    }
}

