/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.quarkus.vertx.web.runtime.NdjsonMulti;
import io.smallrye.mutiny.Multi;
import io.vertx.core.AsyncResult;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiNdjsonSupport {
    private MultiNdjsonSupport() {
    }

    private static void initialize(HttpServerResponse response, RoutingContext rc) {
        if (response.bytesWritten() == 0L) {
            MultiMap headers = response.headers();
            if (headers.get(HttpHeaders.CONTENT_TYPE) == null) {
                if (rc.getAcceptableContentType() == null) {
                    headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/x-ndjson");
                } else {
                    headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)rc.getAcceptableContentType());
                }
            }
            response.setChunked(true);
        }
    }

    public static void subscribeString(Multi<String> multi, RoutingContext rc) {
        MultiNdjsonSupport.write((Multi<Buffer>)multi.map(s -> Buffer.buffer((String)("\"" + s + "\"\n"))), rc);
    }

    public static void subscribeObject(Multi<Object> multi, RoutingContext rc) {
        MultiNdjsonSupport.write((Multi<Buffer>)multi.map(o -> Buffer.buffer((String)(Json.encode((Object)o) + "\n"))), rc);
    }

    private static void onWriteDone(Subscription subscription, AsyncResult<Void> ar, RoutingContext rc) {
        if (ar.failed()) {
            rc.fail(ar.cause());
        } else {
            subscription.request(1L);
        }
    }

    public static void write(Multi<Buffer> multi, final RoutingContext rc) {
        final HttpServerResponse response = rc.response();
        multi.subscribe().withSubscriber((Subscriber)new Subscriber<Buffer>(){
            Subscription upstream;

            public void onSubscribe(Subscription subscription) {
                this.upstream = subscription;
                this.upstream.request(1L);
            }

            public void onNext(Buffer item) {
                MultiNdjsonSupport.initialize(response, rc);
                response.write((Object)item, ar -> MultiNdjsonSupport.onWriteDone(this.upstream, (AsyncResult<Void>)ar, rc));
            }

            public void onError(Throwable throwable) {
                rc.fail(throwable);
            }

            public void onComplete() {
                MultiNdjsonSupport.endOfStream(response, rc);
            }
        });
    }

    private static void endOfStream(HttpServerResponse response, RoutingContext rc) {
        MultiMap headers;
        if (response.bytesWritten() == 0L && (headers = response.headers()).get(HttpHeaders.CONTENT_TYPE) == null) {
            if (rc.getAcceptableContentType() == null) {
                headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/x-ndjson");
            } else {
                headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)rc.getAcceptableContentType());
            }
        }
        response.end();
    }

    public static boolean isNdjson(Multi<?> multi) {
        return multi instanceof NdjsonMulti;
    }
}

