/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.quarkus.arc.ArcContainer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.Validator;

public class ValidationSupport {
    public static final String APPLICATION_JSON = "application/json";
    public static final String ACCEPT_HEADER = "Accept";
    public static final String PROBLEM_TITLE = "title";
    public static final String PROBLEM_DETAIL = "detail";
    public static final String PROBLEM_FIELD = "field";
    public static final String PROBLEM_MESSAGE = "message";
    public static final String PROBLEM_STATUS = "status";
    public static final String PROBLEM_VIOLATIONS = "violations";

    private ValidationSupport() {
    }

    public static Validator getValidator(ArcContainer container) {
        return (Validator)container.instance(Validator.class, new Annotation[0]).get();
    }

    public static String mapViolationsToJson(Set<ConstraintViolation<?>> violations, HttpServerResponse response) {
        response.setStatusCode(500);
        JsonObject json = ValidationSupport.generateJsonResponse(violations, true);
        return json.encode();
    }

    private static JsonObject generateJsonResponse(Set<ConstraintViolation<?>> violations, boolean violationInProducedItem) {
        JsonObject json = new JsonObject().put(PROBLEM_TITLE, (Object)"Constraint Violation").put(PROBLEM_DETAIL, (Object)"validation constraint violations");
        JsonArray array = new JsonArray();
        boolean isProduced = false;
        for (ConstraintViolation<?> cv : violations) {
            if (ValidationSupport.isReturnValueConstraintViolation(cv)) {
                isProduced = true;
            }
            JsonObject violation = new JsonObject();
            violation.put(PROBLEM_FIELD, (Object)cv.getPropertyPath().toString());
            violation.put(PROBLEM_MESSAGE, (Object)cv.getMessage());
            array.add((Object)violation);
        }
        json.put(PROBLEM_STATUS, (Object)(isProduced || violationInProducedItem ? 500 : 400));
        json.put(PROBLEM_VIOLATIONS, (Object)array);
        return json;
    }

    public static void handleViolationException(ConstraintViolationException ex, RoutingContext rc, boolean forceJsonEncoding) {
        String accept = rc.request().getHeader(ACCEPT_HEADER);
        if (forceJsonEncoding || accept != null && accept.contains(APPLICATION_JSON)) {
            rc.response().putHeader("content-type", APPLICATION_JSON);
            JsonObject json = ValidationSupport.generateJsonResponse(ex.getConstraintViolations(), false);
            rc.response().setStatusCode(json.getInteger(PROBLEM_STATUS).intValue());
            rc.response().end(json.encode());
        } else {
            int status = 400;
            for (ConstraintViolation violation : ex.getConstraintViolations()) {
                if (!ValidationSupport.isReturnValueConstraintViolation(violation)) continue;
                status = 500;
                break;
            }
            rc.fail(status, (Throwable)ex);
        }
    }

    static boolean isReturnValueConstraintViolation(ConstraintViolation<?> violation) {
        Iterator pathNodes = violation.getPropertyPath().iterator();
        return pathNodes.hasNext() && ((Path.Node)pathNodes.next()).getKind() == ElementKind.METHOD && pathNodes.hasNext() && ((Path.Node)pathNodes.next()).getKind() == ElementKind.RETURN_VALUE;
    }
}

