/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime;

import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.vertx.ConsumeEvent;
import io.quarkus.vertx.LocalEventBusCodec;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.runtime.EventConsumerInvoker;
import io.quarkus.vertx.runtime.VertxCurrentContextFactory;
import io.quarkus.vertx.runtime.VertxProducer;
import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class VertxEventBusConsumerRecorder {
    private static final Logger LOGGER = Logger.getLogger((String)VertxEventBusConsumerRecorder.class.getName());
    static volatile Vertx vertx;
    static volatile List<MessageConsumer<?>> messageConsumers;

    public void configureVertx(Supplier<Vertx> vertx, Map<String, ConsumeEvent> messageConsumerConfigurations, LaunchMode launchMode, ShutdownContext shutdown, Map<Class<?>, Class<?>> codecByClass, List<Class<?>> selectorTypes) {
        VertxEventBusConsumerRecorder.vertx = vertx.get();
        messageConsumers = new CopyOnWriteArrayList();
        this.registerMessageConsumers(messageConsumerConfigurations);
        this.registerCodecs(codecByClass, selectorTypes);
        if (launchMode == LaunchMode.DEVELOPMENT) {
            shutdown.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxEventBusConsumerRecorder.this.unregisterMessageConsumers();
                }
            });
        } else {
            shutdown.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxEventBusConsumerRecorder.this.destroy();
                }
            });
        }
    }

    public RuntimeValue<CurrentContextFactory> currentContextFactory() {
        return new RuntimeValue((Object)new VertxCurrentContextFactory());
    }

    public static Vertx getVertx() {
        return vertx;
    }

    void destroy() {
        messageConsumers = null;
        vertx = null;
    }

    void registerMessageConsumers(Map<String, ConsumeEvent> messageConsumerConfigurations) {
        if (!messageConsumerConfigurations.isEmpty()) {
            final EventBus eventBus = vertx.eventBus();
            VertxInternal vi = (VertxInternal)vertx;
            CountDownLatch latch = new CountDownLatch(messageConsumerConfigurations.size());
            ArrayList registrationFailures = new ArrayList();
            for (final Map.Entry<String, ConsumeEvent> entry : messageConsumerConfigurations.entrySet()) {
                final EventConsumerInvoker invoker = this.createInvoker(entry.getKey());
                final String address = entry.getValue().value();
                EventLoopContext context = vi.createEventLoopContext();
                context.runOnContext((Handler)new Handler<Void>((ContextInternal)context, latch, registrationFailures){
                    final /* synthetic */ ContextInternal val$context;
                    final /* synthetic */ CountDownLatch val$latch;
                    final /* synthetic */ List val$registrationFailures;
                    {
                        this.val$context = contextInternal;
                        this.val$latch = countDownLatch;
                        this.val$registrationFailures = list;
                    }

                    public void handle(Void x) {
                        MessageConsumer consumer = ((ConsumeEvent)entry.getValue()).local() ? eventBus.localConsumer(address) : eventBus.consumer(address);
                        consumer.handler((Handler)new Handler<Message<Object>>(){

                            public void handle(final Message<Object> m) {
                                if (invoker.isBlocking()) {
                                    Context dup = VertxContext.getOrCreateDuplicatedContext((Context)val$context);
                                    VertxContextSafetyToggle.setContextSafe(dup, true);
                                    if (invoker.isRunningOnVirtualThread()) {
                                        dup.runOnContext((Handler)new Handler<Void>(){

                                            public void handle(Void event) {
                                                VirtualThreadsRecorder.getCurrent().execute(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        try {
                                                            invoker.invoke((Message<Object>)m);
                                                        }
                                                        catch (Exception e) {
                                                            if (m.replyAddress() == null) {
                                                                throw VertxEventBusConsumerRecorder.wrapIfNecessary(e);
                                                            }
                                                            m.fail(8185, e.toString());
                                                        }
                                                    }
                                                });
                                            }
                                        });
                                    } else {
                                        Future future = dup.executeBlocking((Callable)new Callable<Void>(){

                                            @Override
                                            public Void call() {
                                                try {
                                                    invoker.invoke((Message<Object>)m);
                                                }
                                                catch (Exception e) {
                                                    if (m.replyAddress() == null) {
                                                        throw VertxEventBusConsumerRecorder.wrapIfNecessary(e);
                                                    }
                                                    m.fail(8185, e.toString());
                                                }
                                                return null;
                                            }
                                        }, invoker.isOrdered());
                                        future.onFailure(arg_0 -> ((ContextInternal)val$context).reportException(arg_0));
                                    }
                                } else {
                                    VertxContextSafetyToggle.setCurrentContextSafe(true);
                                    try {
                                        invoker.invoke(m);
                                    }
                                    catch (Exception e) {
                                        if (m.replyAddress() == null) {
                                            throw VertxEventBusConsumerRecorder.wrapIfNecessary(e);
                                        }
                                        m.fail(8185, e.toString());
                                    }
                                }
                            }
                        });
                        consumer.completionHandler((Handler)new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> ar) {
                                val$latch.countDown();
                                if (ar.failed()) {
                                    val$registrationFailures.add(ar.cause());
                                }
                            }
                        });
                        messageConsumers.add(consumer);
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Unable to register all message consumer methods", e);
            }
            if (!registrationFailures.isEmpty()) {
                throw new RuntimeException("Registration of one or more message consumers failed", (Throwable)registrationFailures.get(0));
            }
        }
    }

    static RuntimeException wrapIfNecessary(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    void unregisterMessageConsumers() {
        CountDownLatch latch = new CountDownLatch(messageConsumers.size());
        for (MessageConsumer<?> messageConsumer : messageConsumers) {
            messageConsumer.unregister(ar -> {
                latch.countDown();
                if (ar.failed()) {
                    LOGGER.warn((Object)"Message consumer unregistration failed", ar.cause());
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Unable to unregister all message consumer methods", e);
        }
        messageConsumers.clear();
    }

    private EventConsumerInvoker createInvoker(String invokerClassName) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = VertxProducer.class.getClassLoader();
            }
            Class<?> invokerClazz = cl.loadClass(invokerClassName);
            return (EventConsumerInvoker)invokerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create invoker: " + invokerClassName, e);
        }
    }

    private void registerCodecs(Map<Class<?>, Class<?>> codecByClass, final List<Class<?>> selectorTypes) {
        EventBus eventBus = vertx.eventBus();
        boolean isDevMode = ProfileManager.getLaunchMode() == LaunchMode.DEVELOPMENT;
        for (Map.Entry<Class<?>, Class<?>> codecEntry : codecByClass.entrySet()) {
            Class<?> target = codecEntry.getKey();
            Class<?> codec = codecEntry.getValue();
            try {
                if (MessageCodec.class.isAssignableFrom(codec)) {
                    MessageCodec messageCodec = (MessageCodec)codec.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (isDevMode) {
                        eventBus.unregisterDefaultCodec(target);
                    }
                    eventBus.registerDefaultCodec(target, messageCodec);
                    continue;
                }
                LOGGER.error((Object)String.format("The codec %s does not inherit from MessageCodec ", target.toString()));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error((Object)("Cannot instantiate the MessageCodec " + target.toString()), (Throwable)e);
            }
        }
        final String localCodecName = "quarkus_default_local_codec";
        if (isDevMode) {
            eventBus.unregisterCodec(localCodecName);
        }
        eventBus.registerCodec(new LocalEventBusCodec(localCodecName));
        eventBus.codecSelector((Function)new Function<Object, String>(){

            @Override
            public String apply(Object messageBody) {
                for (Class selectorType : selectorTypes) {
                    if (!selectorType.isAssignableFrom(messageBody.getClass())) continue;
                    return localCodecName;
                }
                return null;
            }
        });
    }

    public RuntimeValue<Vertx> forceStart(Supplier<Vertx> vertx) {
        return new RuntimeValue((Object)vertx.get());
    }
}

