/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor.scanning;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.DeploymentException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Application;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.BlockingDefault;
import org.jboss.resteasy.reactive.common.processor.JandexUtil;
import org.jboss.resteasy.reactive.common.processor.NameBindingUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ScannedSerializer;
import org.jboss.resteasy.reactive.common.processor.scanning.SerializerScanningResult;

public class ResteasyReactiveScanner {
    public static final Map<DotName, String> BUILTIN_HTTP_ANNOTATIONS_TO_METHOD;
    public static final Map<String, DotName> METHOD_TO_BUILTIN_HTTP_ANNOTATIONS;

    public static ApplicationScanningResult scanForApplicationClass(IndexView index, Set<String> excludedClasses) {
        Collection applications = index.getAllKnownSubclasses(ResteasyReactiveDotNames.APPLICATION);
        HashSet<String> allowedClasses = new HashSet<String>();
        HashSet<String> singletonClasses = new HashSet<String>();
        HashSet<String> globalNameBindings = new HashSet();
        boolean filterClasses = !excludedClasses.isEmpty();
        Application application = null;
        ClassInfo selectedAppClass = null;
        BlockingDefault blocking = BlockingDefault.AUTOMATIC;
        for (ClassInfo applicationClassInfo : applications) {
            if (Modifier.isAbstract(applicationClassInfo.flags()) || excludedClasses.contains(applicationClassInfo.name().toString())) continue;
            if (selectedAppClass != null) {
                throw new RuntimeException("More than one Application class: " + applications);
            }
            selectedAppClass = applicationClassInfo;
            if (ResteasyReactiveScanner.appClassHasInject(selectedAppClass)) {
                throw new RuntimeException("'@Inject' cannot be used with a '" + ResteasyReactiveDotNames.APPLICATION + "' class. Offending class is: '" + selectedAppClass.name() + "'");
            }
            String applicationClass = applicationClassInfo.name().toString();
            try {
                Class<?> appClass = Thread.currentThread().getContextClassLoader().loadClass(applicationClass);
                application = (Application)appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Set classes = application.getClasses();
                if (!classes.isEmpty()) {
                    for (Class klass : classes) {
                        allowedClasses.add(klass.getName());
                    }
                    filterClasses = true;
                }
                if (!(classes = application.getSingletons().stream().map(Object::getClass).collect(Collectors.toSet())).isEmpty()) {
                    for (Class klass : classes) {
                        allowedClasses.add(klass.getName());
                        singletonClasses.add(klass.getName());
                    }
                    filterClasses = true;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to handle class: " + applicationClass, e);
            }
            if (applicationClassInfo.classAnnotation(ResteasyReactiveDotNames.BLOCKING) != null) {
                if (applicationClassInfo.classAnnotation(ResteasyReactiveDotNames.NON_BLOCKING) != null) {
                    throw new DeploymentException("JAX-RS Application class '" + applicationClassInfo.name() + "' contains both @Blocking and @NonBlocking annotations.");
                }
                blocking = BlockingDefault.BLOCKING;
                continue;
            }
            if (applicationClassInfo.classAnnotation(ResteasyReactiveDotNames.NON_BLOCKING) == null) continue;
            blocking = BlockingDefault.NON_BLOCKING;
        }
        if (selectedAppClass != null) {
            globalNameBindings = NameBindingUtil.nameBindingNames(index, selectedAppClass);
        }
        return new ApplicationScanningResult(allowedClasses, singletonClasses, excludedClasses, globalNameBindings, filterClasses, application, selectedAppClass, blocking);
    }

    public static SerializerScanningResult scanForSerializers(IndexView index, ApplicationScanningResult applicationScanningResult) {
        Collection readers = index.getAllKnownImplementors(ResteasyReactiveDotNames.MESSAGE_BODY_READER);
        ArrayList<ScannedSerializer> readerList = new ArrayList<ScannedSerializer>();
        for (ClassInfo readerClass : readers) {
            AnnotationInstance constrainedToInstance;
            ApplicationScanningResult.KeepProviderResult keepProviderResult = applicationScanningResult.keepProvider(readerClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            List<Type> typeParameters = JandexUtil.resolveTypeParameters(readerClass.name(), ResteasyReactiveDotNames.MESSAGE_BODY_READER, index);
            RuntimeType runtimeType = null;
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.SERVER_ONLY) {
                runtimeType = RuntimeType.SERVER;
            }
            List<String> mediaTypeStrings = Collections.emptyList();
            String readerClassName = readerClass.name().toString();
            AnnotationInstance consumesAnnotation = readerClass.classAnnotation(ResteasyReactiveDotNames.CONSUMES);
            if (consumesAnnotation != null) {
                mediaTypeStrings = Arrays.asList(consumesAnnotation.value().asStringArray());
            }
            if ((constrainedToInstance = readerClass.classAnnotation(ResteasyReactiveDotNames.CONSTRAINED_TO)) != null) {
                runtimeType = RuntimeType.valueOf((String)constrainedToInstance.value().asEnum());
            }
            int priority = 5000;
            AnnotationInstance priorityInstance = readerClass.classAnnotation(ResteasyReactiveDotNames.PRIORITY);
            if (priorityInstance != null) {
                priority = priorityInstance.value().asInt();
            }
            readerList.add(new ScannedSerializer(readerClassName, typeParameters.get(0).name().toString(), mediaTypeStrings, runtimeType, false, priority));
        }
        ArrayList<ScannedSerializer> writerList = new ArrayList<ScannedSerializer>();
        Collection writers = index.getAllKnownImplementors(ResteasyReactiveDotNames.MESSAGE_BODY_WRITER);
        for (ClassInfo writerClass : writers) {
            ApplicationScanningResult.KeepProviderResult keepProviderResult = applicationScanningResult.keepProvider(writerClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            RuntimeType runtimeType = null;
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.SERVER_ONLY) {
                runtimeType = RuntimeType.SERVER;
            }
            List<String> mediaTypeStrings = Collections.emptyList();
            AnnotationInstance producesAnnotation = writerClass.classAnnotation(ResteasyReactiveDotNames.PRODUCES);
            if (producesAnnotation != null) {
                mediaTypeStrings = Arrays.asList(producesAnnotation.value().asStringArray());
            }
            List<Type> typeParameters = JandexUtil.resolveTypeParameters(writerClass.name(), ResteasyReactiveDotNames.MESSAGE_BODY_WRITER, index);
            String writerClassName = writerClass.name().toString();
            AnnotationInstance constrainedToInstance = writerClass.classAnnotation(ResteasyReactiveDotNames.CONSTRAINED_TO);
            if (constrainedToInstance != null) {
                runtimeType = RuntimeType.valueOf((String)constrainedToInstance.value().asEnum());
            }
            int priority = 5000;
            AnnotationInstance priorityInstance = writerClass.classAnnotation(ResteasyReactiveDotNames.PRIORITY);
            if (priorityInstance != null) {
                priority = priorityInstance.value().asInt();
            }
            writerList.add(new ScannedSerializer(writerClassName, typeParameters.get(0).name().toString(), mediaTypeStrings, runtimeType, false, priority));
        }
        return new SerializerScanningResult(readerList, writerList);
    }

    private static boolean appClassHasInject(ClassInfo appClass) {
        if (appClass.annotations() == null) {
            return false;
        }
        List injectInstances = (List)appClass.annotations().get(ResteasyReactiveDotNames.CDI_INJECT);
        return injectInstances != null && !injectInstances.isEmpty();
    }

    public static ResourceScanningResult scanResources(IndexView index, Map<DotName, ClassInfo> additionalResources, Map<DotName, String> additionalResourcePaths) {
        boolean newBeanParamsRegistered;
        Collection paths = index.getAnnotations(ResteasyReactiveDotNames.PATH);
        ArrayList allPaths = new ArrayList(paths);
        HashMap<DotName, ClassInfo> scannedResources = new HashMap<DotName, ClassInfo>(additionalResources);
        HashMap<DotName, String> scannedResourcePaths = new HashMap<DotName, String>(additionalResourcePaths);
        HashMap<DotName, String> pathInterfaces = new HashMap<DotName, String>();
        HashMap<DotName, MethodInfo> resourcesThatNeedCustomProducer = new HashMap<DotName, MethodInfo>();
        ArrayList<MethodInfo> methodExceptionMappers = new ArrayList<MethodInfo>();
        HashSet<DotName> interfacesWithPathOnMethods = new HashSet<DotName>();
        for (Object annotation : allPaths) {
            ClassInfo classInfo;
            if (annotation.target().kind() == AnnotationTarget.Kind.CLASS) {
                Iterator exceptionMapperAnnotationInstances;
                ClassInfo classInfo2 = annotation.target().asClass();
                if (!Modifier.isInterface(classInfo2.flags())) {
                    scannedResources.put(classInfo2.name(), classInfo2);
                    scannedResourcePaths.put(classInfo2.name(), annotation.value().asString());
                } else {
                    pathInterfaces.put(classInfo2.name(), annotation.value().asString());
                }
                MethodInfo methodInfo = ResteasyReactiveScanner.hasJaxRsCtorParams(classInfo2);
                if (methodInfo != null) {
                    resourcesThatNeedCustomProducer.put(classInfo2.name(), methodInfo);
                }
                if ((exceptionMapperAnnotationInstances = (List)classInfo2.annotations().get(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER)) == null) continue;
                Iterator iterator = exceptionMapperAnnotationInstances.iterator();
                while (iterator.hasNext()) {
                    AnnotationInstance instance = (AnnotationInstance)iterator.next();
                    if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                    methodExceptionMappers.add(instance.target().asMethod());
                }
                continue;
            }
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || !Modifier.isInterface((classInfo = annotation.target().asMethod().declaringClass()).flags())) continue;
            interfacesWithPathOnMethods.add(classInfo.name());
        }
        HashMap<DotName, String> clientInterfaces = new HashMap<DotName, String>(pathInterfaces);
        for (DotName dotName : interfacesWithPathOnMethods) {
            if (clientInterfaces.containsKey(dotName)) continue;
            clientInterfaces.put(dotName, "");
        }
        HashMap<DotName, String> clientInterfaceSubtypes = new HashMap<DotName, String>();
        for (DotName dotName : clientInterfaces.keySet()) {
            ResteasyReactiveScanner.addClientSubInterfaces(dotName, index, clientInterfaceSubtypes, clientInterfaces);
        }
        clientInterfaces.putAll(clientInterfaceSubtypes);
        for (Map.Entry entry : pathInterfaces.entrySet()) {
            for (ClassInfo clazz : index.getAllKnownImplementors((DotName)entry.getKey())) {
                if (Modifier.isAbstract(clazz.flags()) || clazz.enclosingClass() != null && !Modifier.isStatic(clazz.flags()) || clazz.enclosingMethod() != null || scannedResources.containsKey(clazz.name())) continue;
                scannedResources.put(clazz.name(), clazz);
                scannedResourcePaths.put(clazz.name(), (String)entry.getValue());
            }
        }
        HashMap<DotName, String> hashMap = new HashMap<DotName, String>(BUILTIN_HTTP_ANNOTATIONS_TO_METHOD);
        Collection collection = index.getAnnotations(ResteasyReactiveDotNames.HTTP_METHOD);
        for (Object httpMethodInstance : collection) {
            if (httpMethodInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            hashMap.put(httpMethodInstance.target().asClass().name(), httpMethodInstance.value().asString());
        }
        Set methodAnnotations = hashMap.keySet();
        for (Object methodAnnotation : methodAnnotations) {
            for (Object methodAnnotationInstance : index.getAnnotations((DotName)methodAnnotation)) {
                if (methodAnnotationInstance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo annotatedMethod = methodAnnotationInstance.target().asMethod();
                ClassInfo classWithJaxrsMethod = annotatedMethod.declaringClass();
                if (!Modifier.isAbstract(annotatedMethod.flags()) || !Modifier.isAbstract(classWithJaxrsMethod.flags()) || clientInterfaces.containsKey(classWithJaxrsMethod.name())) continue;
                clientInterfaces.put(classWithJaxrsMethod.name(), "");
            }
        }
        ArrayDeque<ClassInfo> toScan = new ArrayDeque<ClassInfo>();
        for (DotName methodAnnotation : hashMap.keySet()) {
            for (AnnotationInstance instance : index.getAnnotations(methodAnnotation)) {
                MethodInfo method = instance.target().asMethod();
                ClassInfo classInfo = method.declaringClass();
                toScan.add(classInfo);
            }
        }
        for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveDotNames.PATH)) {
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo method = instance.target().asMethod();
            ClassInfo classInfo = method.declaringClass();
            toScan.add(classInfo);
        }
        HashMap<DotName, ClassInfo> possibleSubResources = new HashMap<DotName, ClassInfo>();
        while (!toScan.isEmpty()) {
            ClassInfo classInfo = (ClassInfo)toScan.poll();
            if (scannedResources.containsKey(classInfo.name()) || pathInterfaces.containsKey(classInfo.name()) || possibleSubResources.containsKey(classInfo.name())) continue;
            possibleSubResources.put(classInfo.name(), classInfo);
            toScan.addAll(index.getKnownDirectImplementors(classInfo.name()));
            toScan.addAll(index.getKnownDirectSubclasses(classInfo.name()));
        }
        HashSet<String> beanParams = new HashSet<String>();
        HashSet beanParamAsBeanUsers = new HashSet(scannedResources.values());
        ArrayList unregisteredBeanParamAnnotations = new ArrayList(index.getAnnotations(ResteasyReactiveDotNames.BEAN_PARAM));
        do {
            newBeanParamsRegistered = false;
            Iterator iterator = unregisteredBeanParamAnnotations.iterator();
            while (iterator.hasNext()) {
                AnnotationInstance beanParamAnnotation = (AnnotationInstance)iterator.next();
                AnnotationTarget target = beanParamAnnotation.target();
                switch (target.kind()) {
                    case FIELD: {
                        FieldInfo field = target.asField();
                        ClassInfo beanParamDeclaringClass = field.declaringClass();
                        if (!beanParamAsBeanUsers.contains(beanParamDeclaringClass) && !beanParams.contains(beanParamDeclaringClass.name().toString())) break;
                        newBeanParamsRegistered |= beanParams.add(field.type().name().toString());
                        iterator.remove();
                        break;
                    }
                    case METHOD: {
                        MethodInfo setterMethod = target.asMethod();
                        if (!beanParamAsBeanUsers.contains(setterMethod.declaringClass()) && !beanParams.contains(setterMethod.declaringClass().name().toString())) break;
                        Type setterParamType = (Type)setterMethod.parameters().get(0);
                        newBeanParamsRegistered |= beanParams.add(setterParamType.name().toString());
                        iterator.remove();
                        break;
                    }
                    case METHOD_PARAMETER: {
                        MethodInfo method = target.asMethodParameter().method();
                        if (!beanParamAsBeanUsers.contains(method.declaringClass()) && !beanParams.contains(method.declaringClass().name().toString())) break;
                        short paramIndex = target.asMethodParameter().position();
                        Type paramType = (Type)method.parameters().get(paramIndex);
                        newBeanParamsRegistered |= beanParams.add(paramType.name().toString());
                        iterator.remove();
                        break;
                    }
                }
            }
        } while (newBeanParamsRegistered);
        return new ResourceScanningResult(index, scannedResources, scannedResourcePaths, possibleSubResources, pathInterfaces, clientInterfaces, resourcesThatNeedCustomProducer, beanParams, hashMap, methodExceptionMappers);
    }

    private static void addClientSubInterfaces(DotName interfaceName, IndexView index, Map<DotName, String> clientInterfaceSubtypes, Map<DotName, String> clientInterfaces) {
        Collection subclasses = index.getKnownDirectImplementors(interfaceName);
        for (ClassInfo subclass : subclasses) {
            if (clientInterfaces.containsKey(subclass.name()) || !Modifier.isInterface(subclass.flags()) || clientInterfaceSubtypes.containsKey(subclass.name())) continue;
            clientInterfaceSubtypes.put(subclass.name(), clientInterfaces.get(interfaceName));
            ResteasyReactiveScanner.addClientSubInterfaces(subclass.name(), index, clientInterfaceSubtypes, clientInterfaces);
        }
    }

    private static MethodInfo hasJaxRsCtorParams(ClassInfo classInfo) {
        List methods = classInfo.methods();
        ArrayList<MethodInfo> ctors = new ArrayList<MethodInfo>();
        for (MethodInfo method : methods) {
            if (!method.name().equals("<init>")) continue;
            ctors.add(method);
        }
        if (ctors.size() != 1) {
            return null;
        }
        MethodInfo ctor = (MethodInfo)ctors.get(0);
        if (ctor.parameters().size() == 0) {
            return null;
        }
        boolean needsHandling = false;
        for (DotName dotName : ResteasyReactiveDotNames.RESOURCE_CTOR_PARAMS_THAT_NEED_HANDLING) {
            if (!ctor.hasAnnotation(dotName)) continue;
            needsHandling = true;
            break;
        }
        return needsHandling ? ctor : null;
    }

    static {
        HashMap<DotName, String> map = new HashMap<DotName, String>();
        HashMap<String, DotName> reverseMap = new HashMap<String, DotName>();
        map.put(ResteasyReactiveDotNames.GET, "GET");
        reverseMap.put("GET", ResteasyReactiveDotNames.GET);
        map.put(ResteasyReactiveDotNames.POST, "POST");
        reverseMap.put("POST", ResteasyReactiveDotNames.POST);
        map.put(ResteasyReactiveDotNames.HEAD, "HEAD");
        reverseMap.put("HEAD", ResteasyReactiveDotNames.HEAD);
        map.put(ResteasyReactiveDotNames.PUT, "PUT");
        reverseMap.put("PUT", ResteasyReactiveDotNames.PUT);
        map.put(ResteasyReactiveDotNames.DELETE, "DELETE");
        reverseMap.put("DELETE", ResteasyReactiveDotNames.DELETE);
        map.put(ResteasyReactiveDotNames.PATCH, "PATCH");
        reverseMap.put("PATCH", ResteasyReactiveDotNames.PATCH);
        map.put(ResteasyReactiveDotNames.OPTIONS, "OPTIONS");
        reverseMap.put("OPTIONS", ResteasyReactiveDotNames.OPTIONS);
        BUILTIN_HTTP_ANNOTATIONS_TO_METHOD = Collections.unmodifiableMap(map);
        METHOD_TO_BUILTIN_HTTP_ANNOTATIONS = Collections.unmodifiableMap(reverseMap);
    }
}

