/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl;

import io.smallrye.context.FastThreadContextProvider;
import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.context.impl.ContextHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ThreadContextProviderPlan {
    public final Set<ThreadContextProvider> propagatedProviders;
    public final Set<ThreadContextProvider> unchangedProviders;
    public final Set<ThreadContextProvider> clearedProviders;
    private final int snapshotInitialSize;
    private final ThreadContextProvider[] propagatedProvidersFastIterable;
    private final ThreadContextProvider[] clearedProvidersFastIterable;
    private boolean fast;

    public ThreadContextProviderPlan(Set<ThreadContextProvider> propagatedSet, Set<ThreadContextProvider> unchangedSet, Set<ThreadContextProvider> clearedSet, boolean enableFastThreadContextProviders) {
        this.propagatedProviders = Collections.unmodifiableSet(propagatedSet);
        this.unchangedProviders = Collections.unmodifiableSet(unchangedSet);
        this.clearedProviders = Collections.unmodifiableSet(clearedSet);
        this.snapshotInitialSize = this.propagatedProviders.size() + this.clearedProviders.size();
        this.propagatedProvidersFastIterable = this.propagatedProviders.toArray(new ThreadContextProvider[0]);
        this.clearedProvidersFastIterable = this.clearedProviders.toArray(new ThreadContextProvider[0]);
        boolean fast = enableFastThreadContextProviders;
        if (fast) {
            for (ThreadContextProvider provider : this.propagatedProvidersFastIterable) {
                if (provider instanceof FastThreadContextProvider) continue;
                fast = false;
                break;
            }
            if (fast) {
                for (ThreadContextProvider provider : this.clearedProvidersFastIterable) {
                    if (provider instanceof FastThreadContextProvider) continue;
                    fast = false;
                    break;
                }
            }
        }
        this.fast = fast;
    }

    public List<ThreadContextSnapshot> takeThreadContextSnapshots() {
        ThreadContextSnapshot snapshot;
        ArrayList<ThreadContextSnapshot> threadContextSnapshots = new ArrayList<ThreadContextSnapshot>(this.snapshotInitialSize);
        Map props = Collections.emptyMap();
        for (ThreadContextProvider provider : this.propagatedProvidersFastIterable) {
            snapshot = provider.currentContext(props);
            if (snapshot == null) continue;
            threadContextSnapshots.add(snapshot);
        }
        for (ThreadContextProvider provider : this.clearedProvidersFastIterable) {
            snapshot = provider.clearedContext(props);
            if (snapshot == null) continue;
            threadContextSnapshots.add(snapshot);
        }
        return threadContextSnapshots;
    }

    public boolean isFast() {
        return this.fast;
    }

    public void takeThreadContextSnapshotsFast(SmallRyeThreadContext threadContext, ThreadLocal<SmallRyeThreadContext> tcTl, ContextHolder contextHolder) {
        ThreadLocal<Object> tl;
        if (!this.fast) {
            throw new IllegalStateException("This ThreadContext includes non-fast providers: " + this.clearedProviders + " and " + this.propagatedProviders);
        }
        if (this.snapshotInitialSize == 0) {
            throw new IllegalStateException("Don't capture empty context plans");
        }
        Map<String, String> props = Collections.emptyMap();
        int i = 0;
        for (ThreadContextProvider provider : this.propagatedProvidersFastIterable) {
            tl = ((FastThreadContextProvider)provider).threadLocal(props);
            contextHolder.captureThreadLocal(i++, tl, tl.get());
        }
        for (ThreadContextProvider provider : this.clearedProvidersFastIterable) {
            tl = ((FastThreadContextProvider)provider).threadLocal(props);
            contextHolder.captureThreadLocal(i++, tl, ((FastThreadContextProvider)provider).clearedValue(props));
        }
        contextHolder.captureThreadLocal(i++, tcTl, threadContext);
    }

    public boolean isEmpty() {
        return this.snapshotInitialSize == 0;
    }

    public int size() {
        return this.snapshotInitialSize + 1;
    }
}

