/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class Type
extends Reference {
    private String description;
    private boolean isInterface;
    private Map<String, Field> fields = new LinkedHashMap<String, Field>();
    private Map<String, Operation> operations = new LinkedHashMap<String, Operation>();
    private Map<String, Operation> batchOperations = new LinkedHashMap<String, Operation>();
    private Set<Reference> interfaces = new LinkedHashSet<Reference>();
    private Set<Reference> unionMemberships = new LinkedHashSet<Reference>();

    public Type() {
    }

    public Type(String className, String name, String description) {
        super(className, name, ReferenceType.TYPE);
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Field> fields) {
        this.fields = fields;
    }

    public void addField(Field field) {
        this.fields.put(field.getName(), field);
    }

    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    public boolean hasField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    public Map<String, Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(Map<String, Operation> operations) {
        this.operations = operations;
    }

    public void addOperation(Operation operation) {
        this.operations.put(operation.getName(), operation);
    }

    public boolean hasOperations() {
        return !this.operations.isEmpty();
    }

    public boolean hasOperation(String operationName) {
        return this.operations.containsKey(operationName);
    }

    public Map<String, Operation> getBatchOperations() {
        return this.batchOperations;
    }

    public void setBatchOperations(Map<String, Operation> operations) {
        this.batchOperations = operations;
    }

    public void addBatchOperation(Operation operation) {
        this.batchOperations.put(operation.getName(), operation);
    }

    public boolean hasBatchOperations() {
        return !this.batchOperations.isEmpty();
    }

    public boolean hasBatchOperation(String operationName) {
        return this.batchOperations.containsKey(operationName);
    }

    public Set<Reference> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Set<Reference> interfaces) {
        this.interfaces = interfaces;
    }

    public void addInterface(Reference interfaceType) {
        this.interfaces.add(interfaceType);
    }

    public boolean hasInterfaces() {
        return !this.interfaces.isEmpty();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setIsInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public Set<Reference> getUnionMemberships() {
        return this.unionMemberships;
    }

    public void addUnion(Reference unionType) {
        this.unionMemberships.add(unionType);
    }

    public boolean hasUnionMemberships() {
        return !this.unionMemberships.isEmpty();
    }

    public boolean isMemberOfUnion(Reference unionType) {
        for (Reference u : this.unionMemberships) {
            if (!u.getName().equals(unionType.getName()) || !u.getClassName().equals(unionType.getClassName()) || !u.getGraphQLClassName().equals(unionType.getGraphQLClassName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "Type{description=" + this.description + ", isInterface=" + this.isInterface + ", fields=" + this.fields + ", operations=" + this.operations + ", batchOperations=" + this.batchOperations + ", interfaces=" + this.interfaces + ", unionMemberships=" + this.unionMemberships + "}";
    }
}

