/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.spring;

import io.smallrye.openapi.runtime.io.parameter.ParameterConstant;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.spi.AbstractParameterProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.FrameworkParameter;
import io.smallrye.openapi.runtime.util.TypeUtil;
import io.smallrye.openapi.spring.SpringConstants;
import io.smallrye.openapi.spring.SpringParameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class SpringParameterProcessor
extends AbstractParameterProcessor {
    static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\{[ \\t]*(\\w[\\w\\.-]*)[ \\t]*:[ \\t]*((?:[^{}]|\\{[^{}]+\\})+)\\}");

    private SpringParameterProcessor(AnnotationScannerContext scannerContext, Function<AnnotationInstance, Parameter> reader, List<AnnotationScannerExtension> extensions) {
        super(scannerContext, reader, extensions);
    }

    public static ResourceParameters process(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo resourceMethod, Function<AnnotationInstance, Parameter> reader, List<AnnotationScannerExtension> extensions) {
        SpringParameterProcessor processor = new SpringParameterProcessor(context, reader, extensions);
        return processor.process(resourceClass, resourceMethod);
    }

    protected Pattern getTemplateParameterPattern() {
        return TEMPLATE_PARAM_PATTERN;
    }

    protected FrameworkParameter getMatrixParameter() {
        return SpringParameter.MATRIX_PARAM.parameter;
    }

    protected void readAnnotatedType(AnnotationInstance annotation, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        DotName name = annotation.name();
        if (this.isReadableParameterAnnotation(name)) {
            this.readParameterAnnotation(annotation, overriddenParametersOnly);
        } else {
            FrameworkParameter frameworkParam = SpringParameter.forName(name);
            if (frameworkParam != null) {
                AnnotationTarget target = annotation.target();
                Type targetType = SpringParameterProcessor.getType((AnnotationTarget)target);
                if (frameworkParam.style == Parameter.Style.FORM) {
                    this.formParams.put(SpringParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
                } else if (frameworkParam.style == Parameter.Style.MATRIX) {
                    String pathSegment = beanParamAnnotation != null ? this.lastPathSegmentOf(beanParamAnnotation.target()) : this.lastPathSegmentOf(target);
                    this.matrixParams.computeIfAbsent(pathSegment, k -> new HashMap()).put(SpringParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
                } else if (frameworkParam.location != null) {
                    this.readParameter(new AbstractParameterProcessor.ParameterContextKey(SpringParameterProcessor.paramName((AnnotationInstance)annotation), frameworkParam.location, frameworkParam.defaultStyle), null, frameworkParam, this.getDefaultValue(target), target, overriddenParametersOnly);
                } else if (target != null) {
                    this.setMediaType(frameworkParam);
                    targetType = TypeUtil.unwrapType((Type)targetType);
                    if (targetType != null) {
                        ClassInfo beanParam = this.index.getClassByName(targetType.name());
                        this.readParameters(beanParam, annotation, overriddenParametersOnly);
                    }
                }
            }
        }
    }

    protected Set<DotName> getDefaultAnnotationNames() {
        return Collections.singleton(SpringConstants.QUERY_PARAM);
    }

    protected String getDefaultAnnotationProperty() {
        return "defaultValue";
    }

    protected String pathOf(AnnotationTarget target) {
        AnnotationInstance path = null;
        Set<DotName> paths = SpringConstants.HTTP_METHODS;
        if (target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
            for (DotName possiblePath : paths) {
                AnnotationInstance classAnnotation = target.asClass().classAnnotation(possiblePath);
                if (classAnnotation == null || classAnnotation.value() == null && classAnnotation.value("path") == null) continue;
                path = classAnnotation;
            }
        } else if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
            for (DotName possiblePath : paths) {
                AnnotationInstance methodAnnotation = target.asMethod().annotation(possiblePath);
                if (methodAnnotation == null || methodAnnotation.value() == null && methodAnnotation.value("path") == null) continue;
                path = methodAnnotation;
            }
            AnnotationInstance methodAnnotation = target.asMethod().annotation(SpringConstants.REQUEST_MAPPING);
            if (methodAnnotation != null && (methodAnnotation.value() != null || methodAnnotation.value("path") != null)) {
                path = methodAnnotation;
            }
        }
        if (path != null) {
            String pathValue = SpringParameterProcessor.requestMappingValuesToPath(path);
            if (pathValue.startsWith("/")) {
                pathValue = pathValue.substring(1);
            }
            if (pathValue.endsWith("/")) {
                pathValue = pathValue.substring(0, pathValue.length() - 1);
            }
            return pathValue;
        }
        return "";
    }

    static String requestMappingValuesToPath(AnnotationInstance requestMappingAnnotation) {
        StringBuilder sb = new StringBuilder();
        AnnotationValue value = SpringParameterProcessor.getRequestMappingPathAnnotation(requestMappingAnnotation);
        if (value != null) {
            String[] parts;
            for (String part : parts = value.asStringArray()) {
                sb.append(part);
            }
        }
        return sb.toString();
    }

    static AnnotationValue getRequestMappingPathAnnotation(AnnotationInstance requestMappingAnnotation) {
        AnnotationValue value = requestMappingAnnotation.value();
        if (value != null) {
            return value;
        }
        return requestMappingAnnotation.value("path");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSubResourceLocator(MethodInfo method) {
        if (method.returnType().kind() != Type.Kind.CLASS) return false;
        if (!this.isResourceMethod(method)) return false;
        if (!method.annotations().stream().map(AnnotationInstance::name).noneMatch(SpringConstants.HTTP_METHODS::contains)) return false;
        return true;
    }

    protected boolean isResourceMethod(MethodInfo method) {
        return method.annotations().stream().map(AnnotationInstance::name).anyMatch(SpringConstants.HTTP_METHODS::contains);
    }

    protected boolean isParameter(DotName annotationName) {
        if (SpringParameter.isParameter(annotationName)) {
            return true;
        }
        if (ParameterConstant.DOTNAME_PARAMETER.equals((Object)annotationName)) {
            return true;
        }
        return ParameterConstant.DOTNAME_PARAMETERS.equals((Object)annotationName);
    }
}

