/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanResult;

@Component
public class ApiListingReferenceScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiListingReferenceScanner.class);

    public ApiListingReferenceScanResult scan(DocumentationContext context) {
        LOGGER.debug("Scanning for api listing references");
        HashMap<ResourceGroup, List<RequestMappingContext>> resourceGroupRequestMappings = new HashMap<ResourceGroup, List<RequestMappingContext>>();
        int requestMappingContextId = 0;
        ApiSelector selector = context.getApiSelector();
        Iterable matchingHandlers = context.getRequestHandlers().stream().filter(selector.getRequestHandlerSelector()).collect(Collectors.toList());
        for (RequestHandler handler : matchingHandlers) {
            ResourceGroup resourceGroup = new ResourceGroup(handler.groupName(), handler.declaringClass(), Integer.valueOf(0));
            RequestMappingContext requestMappingContext = new RequestMappingContext(String.valueOf(requestMappingContextId), context, handler);
            resourceGroupRequestMappings.putIfAbsent(resourceGroup, new ArrayList());
            ((List)resourceGroupRequestMappings.get(resourceGroup)).add(requestMappingContext);
            ++requestMappingContextId;
        }
        return new ApiListingReferenceScanResult(resourceGroupRequestMappings);
    }
}

