/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.producer;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.WriteStream;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.producer.impl.KafkaWriteStreamImpl;
import io.vertx.kafka.client.serialization.VertxSerdes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.serialization.Serializer;

public interface KafkaWriteStream<K, V>
extends WriteStream<ProducerRecord<K, V>> {
    public static final int DEFAULT_MAX_SIZE = 0x100000;

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Properties config) {
        return new KafkaWriteStreamImpl(vertx, new KafkaProducer(config), KafkaClientOptions.fromProperties(config, true));
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Properties config, Class<K> keyType, Class<V> valueType) {
        Serializer keySerializer = VertxSerdes.serdeFrom(keyType).serializer();
        Serializer valueSerializer = VertxSerdes.serdeFrom(valueType).serializer();
        return KafkaWriteStream.create(vertx, config, keySerializer, valueSerializer);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Properties config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new KafkaWriteStreamImpl(vertx, new KafkaProducer(config, keySerializer, valueSerializer), KafkaClientOptions.fromProperties(config, true));
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Map<String, Object> config) {
        return new KafkaWriteStreamImpl(vertx, new KafkaProducer(config), KafkaClientOptions.fromMap(config, true));
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Map<String, Object> config, Class<K> keyType, Class<V> valueType) {
        Serializer keySerializer = VertxSerdes.serdeFrom(keyType).serializer();
        Serializer valueSerializer = VertxSerdes.serdeFrom(valueType).serializer();
        return KafkaWriteStream.create(vertx, config, keySerializer, valueSerializer);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Map<String, Object> config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new KafkaWriteStreamImpl(vertx, new KafkaProducer(config, keySerializer, valueSerializer), KafkaClientOptions.fromMap(config, true));
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, KafkaClientOptions options) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (options.getConfig() != null) {
            config.putAll(options.getConfig());
        }
        return new KafkaWriteStreamImpl(vertx, new KafkaProducer(config), options);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, KafkaClientOptions options, Class<K> keyType, Class<V> valueType) {
        Serializer keySerializer = VertxSerdes.serdeFrom(keyType).serializer();
        Serializer valueSerializer = VertxSerdes.serdeFrom(valueType).serializer();
        return KafkaWriteStream.create(vertx, options, keySerializer, valueSerializer);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, KafkaClientOptions options, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (options.getConfig() != null) {
            config.putAll(options.getConfig());
        }
        return new KafkaWriteStreamImpl(vertx, new KafkaProducer(config, keySerializer, valueSerializer), options);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Producer<K, V> producer) {
        return new KafkaWriteStreamImpl<K, V>(vertx, producer, new KafkaClientOptions());
    }

    @Fluent
    public KafkaWriteStream<K, V> exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public KafkaWriteStream<K, V> setWriteQueueMaxSize(int var1);

    @Fluent
    public KafkaWriteStream<K, V> drainHandler(@Nullable Handler<Void> var1);

    public KafkaWriteStream<K, V> initTransactions(Handler<AsyncResult<Void>> var1);

    public Future<Void> initTransactions();

    public KafkaWriteStream<K, V> beginTransaction(Handler<AsyncResult<Void>> var1);

    public Future<Void> beginTransaction();

    public KafkaWriteStream<K, V> commitTransaction(Handler<AsyncResult<Void>> var1);

    public Future<Void> commitTransaction();

    public KafkaWriteStream<K, V> abortTransaction(Handler<AsyncResult<Void>> var1);

    public Future<Void> abortTransaction();

    public Future<RecordMetadata> send(ProducerRecord<K, V> var1);

    public KafkaWriteStream<K, V> send(ProducerRecord<K, V> var1, Handler<AsyncResult<RecordMetadata>> var2);

    public KafkaWriteStream<K, V> partitionsFor(String var1, Handler<AsyncResult<List<PartitionInfo>>> var2);

    public Future<List<PartitionInfo>> partitionsFor(String var1);

    public KafkaWriteStream<K, V> flush(Handler<AsyncResult<Void>> var1);

    public Future<Void> flush();

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    public void close(long var1, Handler<AsyncResult<Void>> var3);

    public Future<Void> close(long var1);

    public Producer<K, V> unwrap();
}

