/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.impl.PgPoolOptions;
import io.vertx.pgclient.spi.PgDriver;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@VertxGen
public interface PgPool
extends Pool {
    public static PgPool pool() {
        return PgPool.pool(PgConnectOptions.fromEnv(), new PoolOptions());
    }

    public static PgPool pool(PoolOptions options) {
        return PgPool.pool(PgConnectOptions.fromEnv(), options);
    }

    public static PgPool pool(String connectionUri) {
        return PgPool.pool(connectionUri, new PoolOptions());
    }

    public static PgPool pool(String connectionUri, PoolOptions options) {
        return PgPool.pool(PgConnectOptions.fromUri(connectionUri), options);
    }

    public static PgPool pool(Vertx vertx, String connectionUri) {
        return PgPool.pool(vertx, PgConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static PgPool pool(Vertx vertx, PoolOptions options) {
        return PgPool.pool(vertx, PgConnectOptions.fromEnv(), options);
    }

    public static PgPool pool(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return PgPool.pool(vertx, PgConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static PgPool pool(PgConnectOptions database, PoolOptions options) {
        return PgPool.pool(null, database, options);
    }

    public static PgPool pool(Vertx vertx, PgConnectOptions database, PoolOptions options) {
        return PgPool.pool(vertx, Collections.singletonList(database), options);
    }

    public static PgPool pool(List<PgConnectOptions> databases, PoolOptions poolOptions) {
        return PgPool.pool(null, databases, poolOptions);
    }

    public static PgPool pool(Vertx vertx, List<PgConnectOptions> databases, PoolOptions poolOptions) {
        return (PgPool)PgDriver.INSTANCE.createPool(vertx, databases, poolOptions);
    }

    public static SqlClient client() {
        return PgPool.client(PgConnectOptions.fromEnv(), new PoolOptions());
    }

    public static SqlClient client(PoolOptions options) {
        return PgPool.client(PgConnectOptions.fromEnv(), options);
    }

    public static SqlClient client(String connectionUri) {
        return PgPool.client(connectionUri, new PoolOptions());
    }

    public static SqlClient client(String connectionUri, PoolOptions options) {
        return PgPool.client(PgConnectOptions.fromUri(connectionUri), options);
    }

    public static SqlClient client(Vertx vertx, String connectionUri) {
        return PgPool.client(vertx, PgConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static SqlClient client(Vertx vertx, PoolOptions poolOptions) {
        return PgPool.client(vertx, PgConnectOptions.fromEnv(), poolOptions);
    }

    public static SqlClient client(Vertx vertx, String connectionUri, PoolOptions options) {
        return PgPool.client(vertx, PgConnectOptions.fromUri(connectionUri), options);
    }

    public static SqlClient client(PgConnectOptions database, PoolOptions options) {
        return PgPool.client(null, database, options);
    }

    public static SqlClient client(Vertx vertx, PgConnectOptions database, PoolOptions options) {
        return PgPool.client(vertx, Collections.singletonList(database), options);
    }

    public static SqlClient client(Vertx vertx, List<PgConnectOptions> databases, PoolOptions options) {
        return PgDriver.INSTANCE.createPool(vertx, databases, new PgPoolOptions(options).setPipelined(true));
    }

    public static SqlClient client(List<PgConnectOptions> databases, PoolOptions options) {
        return PgPool.client(null, databases, options);
    }

    public PgPool connectHandler(Handler<SqlConnection> var1);

    @Fluent
    public PgPool connectionProvider(Function<Context, Future<SqlConnection>> var1);
}

