/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgNotification;
import io.vertx.pgclient.impl.PgConnectionFactory;
import io.vertx.pgclient.impl.codec.TxFailedEvent;
import io.vertx.pgclient.spi.PgDriver;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.Notification;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;

public class PgConnectionImpl
extends SqlConnectionBase<PgConnectionImpl>
implements PgConnection {
    private volatile Handler<PgNotification> notificationHandler;

    public static Future<PgConnection> connect(ContextInternal context, PgConnectOptions options) {
        PgConnectionFactory client;
        if (options.isUsingDomainSocket() && !context.owner().isNativeTransportEnabled()) {
            return context.failedFuture("Native transport is not available");
        }
        try {
            client = new PgConnectionFactory(context.owner(), options);
        }
        catch (Exception e) {
            return context.failedFuture((Throwable)e);
        }
        context.addCloseHook((Closeable)client);
        return client.connect((Context)context);
    }

    public PgConnectionImpl(PgConnectionFactory factory, ContextInternal context, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(context, (ConnectionFactory)factory, conn, (Driver)PgDriver.INSTANCE, tracer, metrics);
    }

    @Override
    public PgConnection notificationHandler(Handler<PgNotification> handler) {
        this.notificationHandler = handler;
        return this;
    }

    public void handleEvent(Object event) {
        Handler<PgNotification> handler = this.notificationHandler;
        if (handler != null && event instanceof Notification) {
            Notification notification = (Notification)event;
            handler.handle((Object)new PgNotification().setChannel(notification.getChannel()).setProcessId(notification.getProcessId()).setPayload(notification.getPayload()));
        }
        if (event instanceof TxFailedEvent && this.tx != null) {
            this.tx.fail();
        }
    }

    @Override
    public int processId() {
        return this.conn.getProcessId();
    }

    @Override
    public int secretKey() {
        return this.conn.getSecretKey();
    }

    @Override
    public PgConnection cancelRequest(Handler<AsyncResult<Void>> handler) {
        Context current = Vertx.currentContext();
        if (current == this.context) {
            ((PgConnectionFactory)this.factory).cancelRequest(this.conn.server(), this.processId(), this.secretKey(), handler);
        } else {
            this.context.runOnContext(v -> this.cancelRequest(handler));
        }
        return this;
    }
}

