/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.CondVar;
import org.jgroups.util.Streamable;

public class FC
extends Protocol {
    Address local_addr = null;
    final HashMap sent = new HashMap(11);
    final HashMap received = new HashMap(11);
    final Vector members = new Vector(11);
    final List creditors = new ArrayList(11);
    long max_credits = 50000L;
    double min_threshold = 0.25;
    long min_credits = 0L;
    CondVar blocking = new CondVar("blocking", Boolean.FALSE, this.sent);
    static final String name = "FC";
    long start_blocking = 0L;
    long stop_blocking = 0L;

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        boolean min_credits_set = false;
        super.setProperties(props);
        String str = props.getProperty("max_credits");
        if (str != null) {
            this.max_credits = Long.parseLong(str);
            props.remove("max_credits");
        }
        if ((str = props.getProperty("min_threshold")) != null) {
            this.min_threshold = Double.parseDouble(str);
            props.remove("min_threshold");
        }
        if ((str = props.getProperty("min_credits")) != null) {
            this.min_credits = Long.parseLong(str);
            props.remove("min_credits");
            min_credits_set = true;
        }
        if (!min_credits_set) {
            this.min_credits = (long)((double)this.max_credits * this.min_threshold);
        }
        if (props.size() > 0) {
            System.err.println("FC.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void down(final Event evt) {
        switch (evt.getType()) {
            case 6: {
                new Thread(){

                    public void run() {
                        FC.this.handleViewChange(((View)evt.getArg()).getMembers());
                    }
                }.start();
                break;
            }
            case 1: {
                this.waitUntilEnoughCreditsAvailable(evt);
                return;
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.handleViewChange(((View)evt.getArg()).getMembers());
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                FcHeader hdr = (FcHeader)msg.removeHeader(name);
                if (hdr != null) {
                    if (hdr.type != 1) break;
                    this.handleCredit(msg.getSrc());
                    return;
                }
                this.adjustCredit(msg);
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCredit(Address src) {
        if (src == null) {
            return;
        }
        HashMap hashMap = this.sent;
        synchronized (hashMap) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("received replenishment message from " + src + ", old credit was " + this.sent.get(src) + ", new credits are " + this.max_credits + ". Creditors are\n" + this.printCreditors()));
            }
            this.sent.put(src, new Long(this.max_credits));
            if (this.creditors.size() > 0) {
                this.removeCreditor(src);
                if (this.creditors.size() == 0 && this.blocking.get().equals(Boolean.TRUE)) {
                    this.unblockSender();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustCredit(Message msg) {
        Address src = msg.getSrc();
        long size = Math.max(24, msg.getLength());
        if (src == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"src is null");
            }
            return;
        }
        HashMap hashMap = this.received;
        synchronized (hashMap) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("credit for " + src + " is " + this.received.get(src)));
            }
            if (!this.decrementCredit(this.received, src, size)) {
                this.received.put(src, new Long(this.max_credits));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("sending replenishment message to " + src));
                }
                this.sendCredit(src);
            }
        }
    }

    void sendCredit(Address dest) {
        Message msg = new Message(dest, null, null);
        FcHeader hdr = new FcHeader(1);
        msg.putHeader(name, hdr);
        this.passDown(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilEnoughCreditsAvailable(Event evt) {
        Message msg = (Message)evt.getArg();
        HashMap hashMap = this.sent;
        synchronized (hashMap) {
            this.passDown(evt);
            if (!this.decrMessage(msg)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("blocking due to insufficient credits, creditors=\n" + this.printCreditors()));
                }
                this.start_blocking = System.currentTimeMillis();
                this.blocking.set(Boolean.TRUE);
                this.blocking.waitUntil(Boolean.FALSE);
            }
        }
    }

    private boolean decrMessage(Message msg) {
        boolean success = true;
        if (msg == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"msg is null");
            }
            return true;
        }
        Address dest = msg.getDest();
        long size = Math.max(24, msg.getLength());
        if (dest != null && !dest.isMulticastAddress()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("credit for " + dest + " is " + this.sent.get(dest)));
            }
            if (this.decrementCredit(this.sent, dest, size)) {
                return true;
            }
            this.addCreditor(dest);
            return false;
        }
        Iterator it = this.members.iterator();
        while (it.hasNext()) {
            dest = (Address)it.next();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("credit for " + dest + " is " + this.sent.get(dest)));
            }
            if (this.decrementCredit(this.sent, dest, size)) continue;
            this.addCreditor(dest);
            success = false;
        }
        return success;
    }

    private void unblockSender() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"setting blocking=false");
        }
        this.blocking.set(Boolean.FALSE);
        this.printBlockTime();
    }

    private void printBlockTime() {
        this.stop_blocking = System.currentTimeMillis();
        long diff = this.stop_blocking - this.start_blocking;
        this.start_blocking = 0L;
        this.stop_blocking = 0L;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("blocking time was " + diff + "ms"));
        }
    }

    private String printCreditors() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.creditors.iterator();
        while (it.hasNext()) {
            Address creditor = (Address)it.next();
            sb.append(creditor).append(": ").append(this.getCredits(this.sent, creditor)).append(" credits\n");
        }
        return sb.toString();
    }

    private void addCreditor(Address mbr) {
        if (mbr != null && !this.creditors.contains(mbr)) {
            this.creditors.add(mbr);
        }
    }

    private void removeCreditor(Address mbr) {
        if (mbr != null) {
            this.creditors.remove(mbr);
        }
    }

    private long getCredits(Map map, Address mbr) {
        Long tmp = (Long)map.get(mbr);
        if (tmp == null) {
            map.put(mbr, new Long(this.max_credits));
            return this.max_credits;
        }
        return tmp;
    }

    private boolean decrementCredit(HashMap map, Address dest, long credits_required) {
        Long tmp = (Long)map.get(dest);
        if (tmp != null) {
            long credits_left = tmp;
            long new_credits_left = Math.max(0L, credits_left - credits_required);
            map.put(dest, new Long(new_credits_left));
            if (new_credits_left >= this.min_credits + credits_required) {
                return true;
            }
            if (this.log.isTraceEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("not enough credits left for ").append(dest).append(": left=").append(new_credits_left);
                sb.append(", required+min_credits=").append(credits_required + this.min_credits).append(", required=");
                sb.append(credits_required).append(", min_credits=").append(this.min_credits);
                this.log.trace((Object)sb.toString());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleViewChange(Vector mbrs) {
        Address addr;
        if (mbrs == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("new membership: " + mbrs));
        }
        this.members.clear();
        this.members.addAll(mbrs);
        HashMap hashMap = this.received;
        synchronized (hashMap) {
            for (int i = 0; i < mbrs.size(); ++i) {
                addr = (Address)mbrs.elementAt(i);
                if (this.received.containsKey(addr)) continue;
                this.received.put(addr, new Long(this.max_credits));
            }
            Iterator it = this.received.keySet().iterator();
            while (it.hasNext()) {
                addr = (Address)it.next();
                if (mbrs.contains(addr)) continue;
                it.remove();
            }
        }
        hashMap = this.sent;
        synchronized (hashMap) {
            for (int i = 0; i < mbrs.size(); ++i) {
                addr = (Address)mbrs.elementAt(i);
                if (this.sent.containsKey(addr)) continue;
                this.sent.put(addr, new Long(this.max_credits));
            }
            Iterator<Object> it = this.sent.keySet().iterator();
            while (it.hasNext()) {
                addr = (Address)it.next();
                if (mbrs.contains(addr)) continue;
                it.remove();
            }
            it = this.creditors.iterator();
            while (it.hasNext()) {
                Address creditor = (Address)it.next();
                if (mbrs.contains(creditor)) continue;
                it.remove();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("creditors are\n" + this.printCreditors()));
            }
            if (this.creditors.size() == 0 && this.blocking.get().equals(Boolean.TRUE)) {
                this.unblockSender();
            }
        }
    }

    public static class FcHeader
    extends Header
    implements Streamable {
        public static final byte REPLENISH = 1;
        byte type = 1;

        public FcHeader() {
        }

        public FcHeader(byte type) {
            this.type = type;
        }

        public long size() {
            return 1L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
        }
    }
}

