/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

class CompressionResponseStream
extends ServletOutputStream {
    private final int compressionThreshold;
    private final HttpServletResponse response;
    private OutputStream stream;

    CompressionResponseStream(HttpServletResponse response, int compressionThreshold) {
        assert (response != null);
        assert (compressionThreshold >= 0);
        this.response = response;
        this.compressionThreshold = compressionThreshold;
        this.stream = new ByteArrayOutputStream(compressionThreshold);
    }

    public void close() throws IOException {
        if (this.stream instanceof ByteArrayOutputStream) {
            byte[] bytes = ((ByteArrayOutputStream)this.stream).toByteArray();
            this.response.getOutputStream().write(bytes);
            this.stream = this.response.getOutputStream();
        }
        this.stream.close();
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    private void checkBufferSize(int length) throws IOException {
        ByteArrayOutputStream baos;
        if (this.stream instanceof ByteArrayOutputStream && (baos = (ByteArrayOutputStream)this.stream).size() + length > this.compressionThreshold) {
            this.flushToGZIP();
        }
    }

    private void flushToGZIP() throws IOException {
        if (this.stream instanceof ByteArrayOutputStream) {
            this.response.setHeader("Content-Encoding", "gzip");
            this.response.setHeader("Vary", "Accept-Encoding");
            GZIPOutputStream gzipstream = new GZIPOutputStream((OutputStream)this.response.getOutputStream(), this.compressionThreshold);
            byte[] bytes = ((ByteArrayOutputStream)this.stream).toByteArray();
            gzipstream.write(bytes);
            this.stream = gzipstream;
        }
    }

    public void write(int i) throws IOException {
        this.checkBufferSize(1);
        this.stream.write(i);
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.checkBufferSize(len);
        this.stream.write(bytes, off, len);
    }
}

