/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.TransportFormat;

final class Parameters {
    static final String PARAMETER_SYSTEM_PREFIX = "javamelody.";
    static final File TEMPORARY_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    static final String JAVA_VERSION = System.getProperty("java.version");
    static final String JAVAMELODY_VERSION = Parameters.getJavaMelodyVersion();
    private static final int DEFAULT_RESOLUTION_SECONDS = 60;
    private static final String DEFAULT_DIRECTORY = "javamelody";
    private static final String COLLECTOR_APPLICATIONS_FILENAME = "applications.properties";
    private static Map<String, List<URL>> urlsByApplications;
    private static FilterConfig filterConfig;
    private static ServletContext servletContext;
    private static String lastConnectUrl;
    private static Properties lastConnectInfo;
    private static boolean dnsLookupsDisabled;

    private Parameters() {
    }

    static void initialize(FilterConfig config) {
        filterConfig = config;
        if (config != null) {
            ServletContext context = config.getServletContext();
            Parameters.initialize(context);
        }
    }

    static void initialize(ServletContext context) {
        if ("1.6".compareTo(JAVA_VERSION) > 0) {
            throw new IllegalStateException("La version java doit \u00eatre 1.6 au minimum et non " + JAVA_VERSION);
        }
        servletContext = context;
        dnsLookupsDisabled = Boolean.parseBoolean(Parameters.getParameter(Parameter.DNS_LOOKUPS_DISABLED));
    }

    static void initJdbcDriverParameters(String connectUrl, Properties connectInfo) {
        lastConnectUrl = connectUrl;
        lastConnectInfo = connectInfo;
    }

    static ServletContext getServletContext() {
        assert (servletContext != null);
        return servletContext;
    }

    static String getLastConnectUrl() {
        return lastConnectUrl;
    }

    static Properties getLastConnectInfo() {
        return lastConnectInfo;
    }

    static Map<String, List<URL>> getCollectorUrlsByApplications() throws IOException {
        if (urlsByApplications == null) {
            Parameters.readCollectorApplications();
        }
        return Collections.unmodifiableMap(urlsByApplications);
    }

    static void addCollectorApplication(String application, List<URL> urls) throws IOException {
        assert (application != null);
        assert (urls != null && !urls.isEmpty());
        Parameters.getCollectorUrlsByApplications();
        urlsByApplications.put(application, urls);
        Parameters.writeCollectorApplications();
    }

    static void removeCollectorApplication(String application) throws IOException {
        assert (application != null);
        Parameters.getCollectorUrlsByApplications();
        urlsByApplications.remove(application);
        Parameters.writeCollectorApplications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCollectorApplications() throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, List<URL>> entry : urlsByApplications.entrySet()) {
            List<URL> urls = entry.getValue();
            assert (urls != null && !urls.isEmpty());
            StringBuilder sb = new StringBuilder();
            for (URL url : urls) {
                String urlString = url.toString();
                sb.append(urlString.substring(0, urlString.lastIndexOf("/monitoring"))).append(',');
            }
            sb.delete(sb.length() - 1, sb.length());
            properties.put(entry.getKey(), sb.toString());
        }
        File collectorApplicationsFile = Parameters.getCollectorApplicationsFile();
        File directory = collectorApplicationsFile.getParentFile();
        if (!directory.mkdirs() && !directory.exists()) {
            throw new IOException("JavaMelody directory can't be created: " + directory.getPath());
        }
        FileOutputStream output = new FileOutputStream(collectorApplicationsFile);
        try {
            properties.store(output, "urls of the applications to monitor");
        }
        finally {
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readCollectorApplications() throws IOException {
        LinkedHashMap<String, List<URL>> result = new LinkedHashMap<String, List<URL>>();
        File file = Parameters.getCollectorApplicationsFile();
        if (file.exists()) {
            Properties properties = new Properties();
            FileInputStream input = new FileInputStream(file);
            try {
                properties.load(input);
            }
            finally {
                input.close();
            }
            ArrayList<String> propertyNames = Collections.list(properties.propertyNames());
            Collections.sort(propertyNames);
            for (String property : propertyNames) {
                result.put(property, Parameters.parseUrl(String.valueOf(properties.get(property))));
            }
        }
        urlsByApplications = result;
    }

    static File getCollectorApplicationsFile() {
        return new File(Parameters.getStorageDirectory(""), COLLECTOR_APPLICATIONS_FILENAME);
    }

    static List<URL> parseUrl(String value) throws MalformedURLException {
        TransportFormat transportFormat = Parameters.getParameter(Parameter.TRANSPORT_FORMAT) == null ? TransportFormat.SERIALIZED : TransportFormat.valueOfIgnoreCase(Parameters.getParameter(Parameter.TRANSPORT_FORMAT));
        String suffix = "/monitoring?collector=stop&format=" + transportFormat.getCode();
        String[] urlsArray = value.split(",");
        ArrayList<URL> urls = new ArrayList<URL>(urlsArray.length);
        for (String s : urlsArray) {
            String s2 = s.trim();
            while (s2.endsWith("/")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            URL url = new URL(s2 + suffix);
            urls.add(url);
        }
        return urls;
    }

    static String getHostName() {
        if (dnsLookupsDisabled) {
            return "localhost";
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return "unknown";
        }
    }

    static String getHostAddress() {
        if (dnsLookupsDisabled) {
            return "127.0.0.1";
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "unknown";
        }
    }

    static String getResourcePath(String fileName) {
        Class<Parameters> classe = Parameters.class;
        String packageName = classe.getName().substring(0, classe.getName().length() - classe.getSimpleName().length() - 1);
        return '/' + packageName.replace('.', '/') + "/resource/" + fileName;
    }

    static int getResolutionSeconds() {
        String param = Parameters.getParameter(Parameter.RESOLUTION_SECONDS);
        if (param != null) {
            int result = Integer.parseInt(param);
            if (result <= 0) {
                throw new IllegalStateException("Le param\u00e8tre resolution-seconds doit \u00eatre > 0 (entre 60 et 600 recommand\u00e9)");
            }
            return result;
        }
        return 60;
    }

    static File getStorageDirectory(String application) {
        String param = Parameters.getParameter(Parameter.STORAGE_DIRECTORY);
        String dir = param == null ? DEFAULT_DIRECTORY : param;
        String directory = dir.length() > 0 && new File(dir).isAbsolute() ? dir : TEMPORARY_DIRECTORY.getPath() + '/' + dir;
        if (servletContext != null) {
            return new File(directory + '/' + application);
        }
        return new File(directory);
    }

    static boolean isNoDatabase() {
        return Boolean.parseBoolean(Parameters.getParameter(Parameter.NO_DATABASE));
    }

    static boolean isSystemActionsEnabled() {
        String parameter = Parameters.getParameter(Parameter.SYSTEM_ACTIONS_ENABLED);
        return parameter == null || Boolean.parseBoolean(parameter);
    }

    static boolean isCounterHidden(String counterName) {
        String displayedCounters = Parameters.getParameter(Parameter.DISPLAYED_COUNTERS);
        if (displayedCounters == null) {
            return false;
        }
        for (String displayedCounter : displayedCounters.split(",")) {
            String displayedCounterName = displayedCounter.trim();
            if (!counterName.equalsIgnoreCase(displayedCounterName)) continue;
            return false;
        }
        return true;
    }

    static String getCurrentApplication() {
        if (servletContext != null) {
            return Parameters.getContextPath(servletContext) + '_' + Parameters.getHostName();
        }
        return null;
    }

    static String getContextPath(ServletContext context) {
        int lastIndexOfSlash;
        URL webXmlUrl;
        if (context.getMajorVersion() == 2 && context.getMinorVersion() >= 5 || context.getMajorVersion() > 2) {
            return context.getContextPath();
        }
        try {
            webXmlUrl = context.getResource("/WEB-INF/web.xml");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        String contextPath = webXmlUrl.toExternalForm();
        contextPath = contextPath.substring(0, contextPath.indexOf("/WEB-INF/web.xml"));
        int indexOfWar = contextPath.indexOf(".war");
        if (indexOfWar > 0) {
            contextPath = contextPath.substring(0, indexOfWar);
        }
        if (contextPath.startsWith("jndi:/localhost")) {
            contextPath = contextPath.substring("jndi:/localhost".length());
        }
        if ((lastIndexOfSlash = contextPath.lastIndexOf(47)) != -1) {
            contextPath = contextPath.substring(lastIndexOfSlash);
        }
        return contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getJavaMelodyVersion() {
        String string;
        Properties properties = new Properties();
        InputStream inputStream = Parameters.class.getResourceAsStream("/VERSION.properties");
        if (inputStream == null) {
            return null;
        }
        try {
            properties.load(inputStream);
            string = properties.getProperty("version");
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                return e.toString();
            }
        }
        inputStream.close();
        return string;
    }

    static String getParameter(Parameter parameter) {
        assert (parameter != null);
        String name = parameter.getCode();
        return Parameters.getParameterByName(name);
    }

    static String getParameterByName(String parameterName) {
        assert (parameterName != null);
        String globalName = PARAMETER_SYSTEM_PREFIX + parameterName;
        String result = System.getProperty(globalName);
        if (result != null) {
            return result;
        }
        if (servletContext != null && (result = servletContext.getInitParameter(globalName)) != null) {
            return result;
        }
        if (filterConfig != null && (result = filterConfig.getInitParameter(parameterName)) != null) {
            return result;
        }
        return null;
    }
}

