/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.UriParser;

public abstract class CompositeFileProvider
extends AbstractFileProvider {
    private static final int INITIAL_BUFSZ = 80;

    protected abstract String[] getSchemes();

    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        String[] schemes;
        StringBuilder buf = new StringBuilder(80);
        UriParser.extractScheme(uri, buf);
        for (String scheme : schemes = this.getSchemes()) {
            buf.insert(0, ":");
            buf.insert(0, scheme);
        }
        FileObject fo = this.getContext().getFileSystemManager().resolveFile(buf.toString(), fileSystemOptions);
        return fo;
    }
}

