/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.KafkaStorageException;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.LogOffsetMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u000f\r&dW-T3tg\u0006<WmU3u\u0011!Y\u0002A!A!\u0002\u00131\u0012\u0001\u00027pO\u0002B\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0006S:$W\r_\u000b\u0002?A\u0011q\u0003I\u0005\u0003C\t\u00111b\u00144gg\u0016$\u0018J\u001c3fq\"A1\u0005\u0001B\u0001B\u0003%q$\u0001\u0004j]\u0012,\u0007\u0010\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0016\u0003\u001d\u0002\"!\u0003\u0015\n\u0005%R!\u0001\u0002'p]\u001eD\u0001b\u000b\u0001\u0003\u0002\u0003\u0006IaJ\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u0003IIg\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:\u0016\u0003=\u0002\"!\u0003\u0019\n\u0005ER!aA%oi\"A1\u0007\u0001B\u0001B\u0003%q&A\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\b\u0005\u0003\u00056\u0001\t\u0015\r\u0011\"\u0001'\u00031\u0011x\u000e\u001c7KSR$XM]'t\u0011!9\u0004A!A!\u0002\u00139\u0013!\u0004:pY2T\u0015\u000e\u001e;fe6\u001b\b\u0005\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0003\u0011!\u0018.\\3\u0011\u0005=Y\u0014B\u0001\u001f\u0011\u0005\u0011!\u0016.\\3\t\u000by\u0002A\u0011A \u0002\rqJg.\u001b;?)\u001d\u0001\u0015IQ\"E\u000b\u001a\u0003\"a\u0006\u0001\t\u000b\ri\u0004\u0019\u0001\f\t\u000bui\u0004\u0019A\u0010\t\u000b\u0015j\u0004\u0019A\u0014\t\u000b5j\u0004\u0019A\u0018\t\u000bUj\u0004\u0019A\u0014\t\u000bej\u0004\u0019\u0001\u001e\t\u000f!\u0003\u0001\u0019!C\u0001M\u000591M]3bi\u0016$\u0007b\u0002&\u0001\u0001\u0004%\taS\u0001\fGJ,\u0017\r^3e?\u0012*\u0017\u000f\u0006\u0002M\u001fB\u0011\u0011\"T\u0005\u0003\u001d*\u0011A!\u00168ji\"9\u0001+SA\u0001\u0002\u00049\u0013a\u0001=%c!1!\u000b\u0001Q!\n\u001d\n\u0001b\u0019:fCR,G\r\t\u0005\b)\u0002\u0001\r\u0011\"\u0003/\u0003a\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/\u001f\u0005\b-\u0002\u0001\r\u0011\"\u0003X\u0003q\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/_0%KF$\"\u0001\u0014-\t\u000fA+\u0016\u0011!a\u0001_!1!\f\u0001Q!\n=\n\u0011DY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:zA!)a\b\u0001C\u00019RQ\u0001)X4jU2lgn];\t\u000by[\u0006\u0019A0\u0002\u0007\u0011L'\u000f\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006\u0011\u0011n\u001c\u0006\u0002I\u0006!!.\u0019<b\u0013\t1\u0017M\u0001\u0003GS2,\u0007\"\u00025\\\u0001\u00049\u0013aC:uCJ$xJ\u001a4tKRDQ!L.A\u0002=BQa[.A\u0002=\nA\"\\1y\u0013:$W\r_*ju\u0016DQ!N.A\u0002\u001dBQ!O.A\u0002iBqa\\.\u0011\u0002\u0003\u0007\u0001/A\tgS2,\u0017\t\u001c:fC\u0012LX\t_5tiN\u0004\"!C9\n\u0005IT!a\u0002\"p_2,\u0017M\u001c\u0005\bin\u0003\n\u00111\u00010\u00031Ig.\u001b;GS2,7+\u001b>f\u0011\u001d18\f%AA\u0002A\f1\u0002\u001d:fC2dwnY1uK\")\u0001\u0010\u0001C\u0001M\u0005!1/\u001b>f\u0011\u0015Q\b\u0001\"\u0001|\u0003\u0019\t\u0007\u000f]3oIR\u0019A\n @\t\u000buL\b\u0019A\u0014\u0002\r=4gm]3u\u0011\u0019y\u0018\u00101\u0001\u0002\u0002\u0005AQ.Z:tC\u001e,7\u000f\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9\u0001B\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\tY!!\u0002\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3uQ\rI\u0018q\u0002\t\u0004\u001f\u0005E\u0011bAA\n!\tian\u001c8uQJ,\u0017\rZ:bM\u0016D\u0001\"a\u0006\u0001\t\u0003\u0011\u0011\u0011D\u0001\u0010iJ\fgn\u001d7bi\u0016|eMZ:fiR1\u00111DA\u0011\u0003G\u00012aFA\u000f\u0013\r\tyB\u0001\u0002\u000f\u001f\u001a47/\u001a;Q_NLG/[8o\u0011\u0019i\u0018Q\u0003a\u0001O!I\u0011QEA\u000b!\u0003\u0005\raL\u0001\u0015gR\f'\u000f^5oO\u001aKG.\u001a)pg&$\u0018n\u001c8)\t\u0005U\u0011\u0011\u0006\t\u0004\u001f\u0005-\u0012bAA\u0017!\tQA\u000f\u001b:fC\u0012\u001c\u0018MZ3\t\u000f\u0005E\u0002\u0001\"\u0001\u00024\u0005!!/Z1e))\t)$!\u0011\u0002D\u00055\u0013\u0011\u000b\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111\b\u0003\u0002\rM,'O^3s\u0013\u0011\ty$!\u000f\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011\u0019A\u0017q\u0006a\u0001O!A\u0011QIA\u0018\u0001\u0004\t9%A\u0005nCb|eMZ:fiB!\u0011\"!\u0013(\u0013\r\tYE\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005=\u0013q\u0006a\u0001_\u00059Q.\u0019=TSj,\u0007\"CA*\u0003_\u0001\n\u00111\u0001(\u0003-i\u0017\r\u001f)pg&$\u0018n\u001c8)\t\u0005=\u0012\u0011\u0006\u0005\b\u00033\u0002A\u0011AA.\u0003\u001d\u0011XmY8wKJ$2aLA/\u0011\u001d\ty&a\u0016A\u0002=\na\"\\1y\u001b\u0016\u001c8/Y4f'&TX\r\u000b\u0003\u0002X\u0005=\u0001bBA3\u0001\u0011\u0005\u0013qM\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u000e\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN2\u0002\t1\fgnZ\u0005\u0005\u0003g\niG\u0001\u0004TiJLgn\u001a\u0005\b\u0003o\u0002A\u0011AA=\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004_\u0005m\u0004BB?\u0002v\u0001\u0007q\u0005\u000b\u0003\u0002v\u0005=\u0001bBAA\u0001\u0011\u0005\u00111Q\u0001\u000b]\u0016DHo\u00144gg\u0016$H#A\u0014)\t\u0005}\u0014\u0011\u0006\u0005\b\u0003\u0013\u0003A\u0011AAF\u0003\u00151G.^:i)\u0005a\u0005\u0006BAD\u0003SAq!!%\u0001\t\u0003\t\u0019*\u0001\ndQ\u0006tw-\u001a$jY\u0016\u001cVO\u001a4jq\u0016\u001cH#\u0002'\u0002\u0016\u0006\u0015\u0006\u0002CAL\u0003\u001f\u0003\r!!'\u0002\u0013=dGmU;gM&D\b\u0003BAN\u0003Cs1!CAO\u0013\r\tyJC\u0001\u0007!J,G-\u001a4\n\t\u0005M\u00141\u0015\u0006\u0004\u0003?S\u0001\u0002CAT\u0003\u001f\u0003\r!!'\u0002\u00139,woU;gM&D\bbBAV\u0001\u0011\u0005\u00111R\u0001\u0006G2|7/\u001a\u0005\b\u0003_\u0003A\u0011AAF\u0003\u0019!W\r\\3uK\"1\u00111\u0017\u0001\u0005\u0002\u0019\nA\u0002\\1ti6{G-\u001b4jK\u0012Dq!a.\u0001\t\u0003\tI,\u0001\tmCN$Xj\u001c3jM&,Gm\u0018\u0013fcR\u0019\u0001/a/\t\u000f\u0005u\u0016Q\u0017a\u0001O\u0005\u0011Qn\u001d\u0005\n\u0003\u0003\u0004\u0011\u0013!C\u0001\u0003\u0007\faB]3bI\u0012\"WMZ1vYR$C'\u0006\u0002\u0002F*\u001aq%a2,\u0005\u0005%\u0007\u0003BAf\u0003+l!!!4\u000b\t\u0005=\u0017\u0011[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a5\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003/\fiMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a7\u0001#\u0003%\t!!8\u00023Q\u0014\u0018M\\:mCR,wJ\u001a4tKR$C-\u001a4bk2$HEM\u000b\u0003\u0003?T3aLAdQ\r\u0001\u0011qB\u0004\n\u0003K\u0014\u0011\u0011!E\u0001\u0003O\f!\u0002T8h'\u0016<W.\u001a8u!\r9\u0012\u0011\u001e\u0004\t\u0003\t\t\t\u0011#\u0001\u0002lN\u0019\u0011\u0011\u001e\u0005\t\u000fy\nI\u000f\"\u0001\u0002pR\u0011\u0011q\u001d\u0005\u000b\u0003g\fI/%A\u0005\u0002\u0005U\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0002x*\u001a\u0001/a2\t\u0015\u0005m\u0018\u0011^I\u0001\n\u0003\ti.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000f\u0005\u000b\u0003\u007f\fI/%A\u0005\u0002\u0005U\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\b")
public class LogSegment
implements Logging {
    private final FileMessageSet log;
    private final OffsetIndex index;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$9() {
        return LogSegment$.MODULE$.$lessinit$greater$default$9();
    }

    public static int $lessinit$greater$default$8() {
        return LogSegment$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$7() {
        return LogSegment$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileMessageSet log() {
        return this.log;
    }

    public OffsetIndex index() {
        return this.index;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public long created() {
        return this.created;
    }

    public void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    public long size() {
        return this.log().sizeInBytes();
    }

    public void append(long offset, ByteBufferMessageSet messages) {
        if (messages.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, offset, messages){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long offset$1;
                private final ByteBufferMessageSet messages$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.log().sizeInBytes())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.offset$1 = offset$1;
                    this.messages$1 = messages$1;
                }
            });
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(offset, this.log().sizeInBytes());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.log().append(messages);
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + messages.sizeInBytes());
        }
    }

    public OffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.index().lookup(offset);
        return this.log().searchFor(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition) {
        Option<Object> option;
        block9: {
            int n;
            LogOffsetMetadata offsetMetadata;
            OffsetPosition startPosition;
            block8: {
                int logSize;
                block7: {
                    if (maxSize < 0) {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize)})));
                    }
                    logSize = this.log().sizeInBytes();
                    startPosition = this.translateOffset(startOffset, this.translateOffset$default$2());
                    if (startPosition == null) {
                        return null;
                    }
                    offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition.position());
                    if (maxSize == 0) {
                        return new FetchDataInfo(offsetMetadata, MessageSet$.MODULE$.Empty());
                    }
                    option = maxOffset;
                    None$ none$ = None$.MODULE$;
                    Option<Object> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    n = package$.MODULE$.min((int)(maxPosition - (long)startPosition.position()), maxSize);
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                long offset = BoxesRunTime.unboxToLong((Object)some.x());
                if (offset < startOffset) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to read with a maximum offset (%d) less than the start offset (%d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToLong((long)startOffset)})));
                }
                OffsetPosition mapping = this.translateOffset(offset, startPosition.position());
                int endPosition = mapping == null ? logSize : mapping.position();
                n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition.position(), (long)maxSize);
            }
            int length = n;
            return new FetchDataInfo(offsetMetadata, this.log().read(startPosition.position(), length));
        }
        throw new MatchError(option);
    }

    public long read$default$4() {
        return this.size();
    }

    public int recover(int maxMessageSize) {
        this.index().truncate();
        this.index().resize(this.index().maxIndexSize());
        int validBytes = 0;
        int lastIndexEntry = 0;
        Iterator<MessageAndOffset> iter = this.log().iterator(maxMessageSize);
        try {
            while (iter.hasNext()) {
                MessageAndOffset entry2 = (MessageAndOffset)iter.next();
                entry2.message().ensureValid();
                if (validBytes - lastIndexEntry > this.indexIntervalBytes()) {
                    CompressionCodec compressionCodec = entry2.message().compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    long l = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? entry2.offset() : ((MessageAndOffset)ByteBufferMessageSet$.MODULE$.deepIterator(entry2.message()).next()).offset();
                    long startOffset = l;
                    this.index().append(startOffset, validBytes);
                    lastIndexEntry = validBytes;
                }
                validBytes += MessageSet$.MODULE$.entrySize(entry2.message());
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            this.logger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes), invalidMessageException.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes;
        this.log().truncateTo(validBytes);
        this.index().trimToValidSize();
        return truncated;
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset) {
        OffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        if (mapping == null) {
            return 0;
        }
        this.index().truncateTo(offset);
        this.index().resize(this.index().maxIndexSize());
        int bytesTruncated = this.log().truncateTo(mapping.position());
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time.milliseconds());
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        return bytesTruncated;
    }

    public long nextOffset() {
        Option<MessageAndOffset> option;
        block6: {
            long l;
            block3: {
                long l2;
                block5: {
                    block4: {
                        FetchDataInfo ms;
                        block2: {
                            ms = this.read(this.index().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4());
                            if (ms != null) break block2;
                            l = this.baseOffset();
                            break block3;
                        }
                        option = ms.messageSet().lastOption();
                        None$ none$ = None$.MODULE$;
                        Option<MessageAndOffset> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        l2 = this.baseOffset();
                        break block5;
                    }
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    MessageAndOffset last = (MessageAndOffset)some.x();
                    l2 = last.nextOffset();
                }
                l = l2;
            }
            return l;
        }
        throw new MatchError(option);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.index().flush();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        boolean logRenamed = this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        if (logRenamed) {
            boolean indexRenamed = this.index().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.index().file().getPath(), oldSuffix, newSuffix)));
            if (indexRenamed) {
                return;
            }
            throw new KafkaStorageException(new StringOps(Predef$.MODULE$.augmentString("Failed to change the index file suffix from %s to %s for log segment %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong((long)this.baseOffset())})));
        }
        throw new KafkaStorageException(new StringOps(Predef$.MODULE$.augmentString("Failed to change the log file suffix from %s to %s for log segment %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong((long)this.baseOffset())})));
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.index().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void delete() {
        boolean deletedLog = this.log().delete();
        boolean deletedIndex = this.index().delete();
        if (!deletedLog && this.log().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of log ").append((Object)this.log().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedIndex && this.index().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of index ").append((Object)this.index().file().getName()).append((Object)" failed.").toString());
        }
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public boolean lastModified_$eq(long ms) {
        this.log().file().setLastModified(ms);
        return this.index().file().setLastModified(ms);
    }

    public LogSegment(FileMessageSet log, OffsetIndex index, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.index = index;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
    }

    public LogSegment(File dir, long startOffset, int indexIntervalBytes, int maxIndexSize, long rollJitterMs, Time time, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(dir, startOffset), fileAlreadyExists, initFileSize, preallocate), new OffsetIndex(Log$.MODULE$.indexFilename(dir, startOffset), startOffset, maxIndexSize), startOffset, indexIntervalBytes, rollJitterMs, time);
    }
}

