/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.List;
import kafka.api.ApiVersion$;
import kafka.consumer.ConsumerConfig$;
import kafka.coordinator.OffsetConfig$;
import kafka.message.MessageSet$;
import kafka.server.ClientQuotaManagerConfig$;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.protocol.SecurityProtocol;

public final class Defaults$ {
    public static final Defaults$ MODULE$;
    private final int ZkSessionTimeoutMs;
    private final int ZkSyncTimeMs;
    private final boolean ZkEnableSecureAcls;
    private final int MaxReservedBrokerId;
    private final int BrokerId;
    private final int MessageMaxBytes;
    private final int NumNetworkThreads;
    private final int NumIoThreads;
    private final int BackgroundThreads;
    private final int QueuedMaxRequests;
    private final String AuthorizerClassName;
    private final int Port;
    private final String HostName;
    private final int SocketSendBufferBytes;
    private final int SocketReceiveBufferBytes;
    private final int SocketRequestMaxBytes;
    private final int MaxConnectionsPerIp;
    private final String MaxConnectionsPerIpOverrides;
    private final long ConnectionsMaxIdleMs;
    private final int RequestTimeoutMs;
    private final int NumPartitions;
    private final String LogDir;
    private final int LogSegmentBytes;
    private final int LogRollHours;
    private final int LogRollJitterHours;
    private final int LogRetentionHours;
    private final long LogRetentionBytes;
    private final long LogCleanupIntervalMs;
    private final String Delete;
    private final String Compact;
    private final String LogCleanupPolicy;
    private final int LogCleanerThreads;
    private final double LogCleanerIoMaxBytesPerSecond;
    private final long LogCleanerDedupeBufferSize;
    private final int LogCleanerIoBufferSize;
    private final double LogCleanerDedupeBufferLoadFactor;
    private final int LogCleanerBackoffMs;
    private final double LogCleanerMinCleanRatio;
    private final boolean LogCleanerEnable;
    private final long LogCleanerDeleteRetentionMs;
    private final int LogIndexSizeMaxBytes;
    private final int LogIndexIntervalBytes;
    private final long LogFlushIntervalMessages;
    private final int LogDeleteDelayMs;
    private final long LogFlushSchedulerIntervalMs;
    private final int LogFlushOffsetCheckpointIntervalMs;
    private final boolean LogPreAllocateEnable;
    private final int NumRecoveryThreadsPerDataDir;
    private final boolean AutoCreateTopicsEnable;
    private final int MinInSyncReplicas;
    private final int ControllerSocketTimeoutMs;
    private final int ControllerMessageQueueSize;
    private final int DefaultReplicationFactor;
    private final long ReplicaLagTimeMaxMs;
    private final int ReplicaSocketTimeoutMs;
    private final int ReplicaSocketReceiveBufferBytes;
    private final int ReplicaFetchMaxBytes;
    private final int ReplicaFetchWaitMaxMs;
    private final int ReplicaFetchMinBytes;
    private final int NumReplicaFetchers;
    private final int ReplicaFetchBackoffMs;
    private final long ReplicaHighWatermarkCheckpointIntervalMs;
    private final int FetchPurgatoryPurgeIntervalRequests;
    private final int ProducerPurgatoryPurgeIntervalRequests;
    private final boolean AutoLeaderRebalanceEnable;
    private final int LeaderImbalancePerBrokerPercentage;
    private final int LeaderImbalanceCheckIntervalSeconds;
    private final boolean UncleanLeaderElectionEnable;
    private final String InterBrokerSecurityProtocol;
    private final String InterBrokerProtocolVersion;
    private final int ControlledShutdownMaxRetries;
    private final int ControlledShutdownRetryBackoffMs;
    private final boolean ControlledShutdownEnable;
    private final int ConsumerMinSessionTimeoutMs;
    private final int ConsumerMaxSessionTimeoutMs;
    private final int OffsetMetadataMaxSize;
    private final int OffsetsLoadBufferSize;
    private final short OffsetsTopicReplicationFactor;
    private final int OffsetsTopicPartitions;
    private final int OffsetsTopicSegmentBytes;
    private final int OffsetsTopicCompressionCodec;
    private final int OffsetsRetentionMinutes;
    private final long OffsetsRetentionCheckIntervalMs;
    private final int OffsetCommitTimeoutMs;
    private final short OffsetCommitRequiredAcks;
    private final long ProducerQuotaBytesPerSecondDefault;
    private final long ConsumerQuotaBytesPerSecondDefault;
    private final int NumQuotaSamples;
    private final int QuotaWindowSizeSeconds;
    private final boolean DeleteTopicEnable;
    private final String CompressionType;
    private final int MetricNumSamples;
    private final int MetricSampleWindowMs;
    private final String MetricReporterClasses;
    private final String PrincipalBuilderClass;
    private final String SslProtocol;
    private final String SslEnabledProtocols;
    private final String SslKeystoreType;
    private final String SslTruststoreType;
    private final String SslKeyManagerAlgorithm;
    private final String SslTrustManagerAlgorithm;
    private final String SslClientAuthRequired;
    private final String SslClientAuthRequested;
    private final String SslClientAuthNone;
    private final String SslClientAuth;
    private final String SaslKerberosKinitCmd;
    private final double SaslKerberosTicketRenewWindowFactor;
    private final double SaslKerberosTicketRenewJitter;
    private final long SaslKerberosMinTimeBeforeRelogin;
    private final List<String> SaslKerberosPrincipalToLocalRules;

    static {
        new Defaults$();
    }

    public int ZkSessionTimeoutMs() {
        return this.ZkSessionTimeoutMs;
    }

    public int ZkSyncTimeMs() {
        return this.ZkSyncTimeMs;
    }

    public boolean ZkEnableSecureAcls() {
        return this.ZkEnableSecureAcls;
    }

    public int MaxReservedBrokerId() {
        return this.MaxReservedBrokerId;
    }

    public int BrokerId() {
        return this.BrokerId;
    }

    public int MessageMaxBytes() {
        return this.MessageMaxBytes;
    }

    public int NumNetworkThreads() {
        return this.NumNetworkThreads;
    }

    public int NumIoThreads() {
        return this.NumIoThreads;
    }

    public int BackgroundThreads() {
        return this.BackgroundThreads;
    }

    public int QueuedMaxRequests() {
        return this.QueuedMaxRequests;
    }

    public String AuthorizerClassName() {
        return this.AuthorizerClassName;
    }

    public int Port() {
        return this.Port;
    }

    public String HostName() {
        return this.HostName;
    }

    public int SocketSendBufferBytes() {
        return this.SocketSendBufferBytes;
    }

    public int SocketReceiveBufferBytes() {
        return this.SocketReceiveBufferBytes;
    }

    public int SocketRequestMaxBytes() {
        return this.SocketRequestMaxBytes;
    }

    public int MaxConnectionsPerIp() {
        return this.MaxConnectionsPerIp;
    }

    public String MaxConnectionsPerIpOverrides() {
        return this.MaxConnectionsPerIpOverrides;
    }

    public long ConnectionsMaxIdleMs() {
        return this.ConnectionsMaxIdleMs;
    }

    public int RequestTimeoutMs() {
        return this.RequestTimeoutMs;
    }

    public int NumPartitions() {
        return this.NumPartitions;
    }

    public String LogDir() {
        return this.LogDir;
    }

    public int LogSegmentBytes() {
        return this.LogSegmentBytes;
    }

    public int LogRollHours() {
        return this.LogRollHours;
    }

    public int LogRollJitterHours() {
        return this.LogRollJitterHours;
    }

    public int LogRetentionHours() {
        return this.LogRetentionHours;
    }

    public long LogRetentionBytes() {
        return this.LogRetentionBytes;
    }

    public long LogCleanupIntervalMs() {
        return this.LogCleanupIntervalMs;
    }

    public String Delete() {
        return this.Delete;
    }

    public String Compact() {
        return this.Compact;
    }

    public String LogCleanupPolicy() {
        return this.LogCleanupPolicy;
    }

    public int LogCleanerThreads() {
        return this.LogCleanerThreads;
    }

    public double LogCleanerIoMaxBytesPerSecond() {
        return this.LogCleanerIoMaxBytesPerSecond;
    }

    public long LogCleanerDedupeBufferSize() {
        return this.LogCleanerDedupeBufferSize;
    }

    public int LogCleanerIoBufferSize() {
        return this.LogCleanerIoBufferSize;
    }

    public double LogCleanerDedupeBufferLoadFactor() {
        return this.LogCleanerDedupeBufferLoadFactor;
    }

    public int LogCleanerBackoffMs() {
        return this.LogCleanerBackoffMs;
    }

    public double LogCleanerMinCleanRatio() {
        return this.LogCleanerMinCleanRatio;
    }

    public boolean LogCleanerEnable() {
        return this.LogCleanerEnable;
    }

    public long LogCleanerDeleteRetentionMs() {
        return this.LogCleanerDeleteRetentionMs;
    }

    public int LogIndexSizeMaxBytes() {
        return this.LogIndexSizeMaxBytes;
    }

    public int LogIndexIntervalBytes() {
        return this.LogIndexIntervalBytes;
    }

    public long LogFlushIntervalMessages() {
        return this.LogFlushIntervalMessages;
    }

    public int LogDeleteDelayMs() {
        return this.LogDeleteDelayMs;
    }

    public long LogFlushSchedulerIntervalMs() {
        return this.LogFlushSchedulerIntervalMs;
    }

    public int LogFlushOffsetCheckpointIntervalMs() {
        return this.LogFlushOffsetCheckpointIntervalMs;
    }

    public boolean LogPreAllocateEnable() {
        return this.LogPreAllocateEnable;
    }

    public int NumRecoveryThreadsPerDataDir() {
        return this.NumRecoveryThreadsPerDataDir;
    }

    public boolean AutoCreateTopicsEnable() {
        return this.AutoCreateTopicsEnable;
    }

    public int MinInSyncReplicas() {
        return this.MinInSyncReplicas;
    }

    public int ControllerSocketTimeoutMs() {
        return this.ControllerSocketTimeoutMs;
    }

    public int ControllerMessageQueueSize() {
        return this.ControllerMessageQueueSize;
    }

    public int DefaultReplicationFactor() {
        return this.DefaultReplicationFactor;
    }

    public long ReplicaLagTimeMaxMs() {
        return this.ReplicaLagTimeMaxMs;
    }

    public int ReplicaSocketTimeoutMs() {
        return this.ReplicaSocketTimeoutMs;
    }

    public int ReplicaSocketReceiveBufferBytes() {
        return this.ReplicaSocketReceiveBufferBytes;
    }

    public int ReplicaFetchMaxBytes() {
        return this.ReplicaFetchMaxBytes;
    }

    public int ReplicaFetchWaitMaxMs() {
        return this.ReplicaFetchWaitMaxMs;
    }

    public int ReplicaFetchMinBytes() {
        return this.ReplicaFetchMinBytes;
    }

    public int NumReplicaFetchers() {
        return this.NumReplicaFetchers;
    }

    public int ReplicaFetchBackoffMs() {
        return this.ReplicaFetchBackoffMs;
    }

    public long ReplicaHighWatermarkCheckpointIntervalMs() {
        return this.ReplicaHighWatermarkCheckpointIntervalMs;
    }

    public int FetchPurgatoryPurgeIntervalRequests() {
        return this.FetchPurgatoryPurgeIntervalRequests;
    }

    public int ProducerPurgatoryPurgeIntervalRequests() {
        return this.ProducerPurgatoryPurgeIntervalRequests;
    }

    public boolean AutoLeaderRebalanceEnable() {
        return this.AutoLeaderRebalanceEnable;
    }

    public int LeaderImbalancePerBrokerPercentage() {
        return this.LeaderImbalancePerBrokerPercentage;
    }

    public int LeaderImbalanceCheckIntervalSeconds() {
        return this.LeaderImbalanceCheckIntervalSeconds;
    }

    public boolean UncleanLeaderElectionEnable() {
        return this.UncleanLeaderElectionEnable;
    }

    public String InterBrokerSecurityProtocol() {
        return this.InterBrokerSecurityProtocol;
    }

    public String InterBrokerProtocolVersion() {
        return this.InterBrokerProtocolVersion;
    }

    public int ControlledShutdownMaxRetries() {
        return this.ControlledShutdownMaxRetries;
    }

    public int ControlledShutdownRetryBackoffMs() {
        return this.ControlledShutdownRetryBackoffMs;
    }

    public boolean ControlledShutdownEnable() {
        return this.ControlledShutdownEnable;
    }

    public int ConsumerMinSessionTimeoutMs() {
        return this.ConsumerMinSessionTimeoutMs;
    }

    public int ConsumerMaxSessionTimeoutMs() {
        return this.ConsumerMaxSessionTimeoutMs;
    }

    public int OffsetMetadataMaxSize() {
        return this.OffsetMetadataMaxSize;
    }

    public int OffsetsLoadBufferSize() {
        return this.OffsetsLoadBufferSize;
    }

    public short OffsetsTopicReplicationFactor() {
        return this.OffsetsTopicReplicationFactor;
    }

    public int OffsetsTopicPartitions() {
        return this.OffsetsTopicPartitions;
    }

    public int OffsetsTopicSegmentBytes() {
        return this.OffsetsTopicSegmentBytes;
    }

    public int OffsetsTopicCompressionCodec() {
        return this.OffsetsTopicCompressionCodec;
    }

    public int OffsetsRetentionMinutes() {
        return this.OffsetsRetentionMinutes;
    }

    public long OffsetsRetentionCheckIntervalMs() {
        return this.OffsetsRetentionCheckIntervalMs;
    }

    public int OffsetCommitTimeoutMs() {
        return this.OffsetCommitTimeoutMs;
    }

    public short OffsetCommitRequiredAcks() {
        return this.OffsetCommitRequiredAcks;
    }

    public long ProducerQuotaBytesPerSecondDefault() {
        return this.ProducerQuotaBytesPerSecondDefault;
    }

    public long ConsumerQuotaBytesPerSecondDefault() {
        return this.ConsumerQuotaBytesPerSecondDefault;
    }

    public int NumQuotaSamples() {
        return this.NumQuotaSamples;
    }

    public int QuotaWindowSizeSeconds() {
        return this.QuotaWindowSizeSeconds;
    }

    public boolean DeleteTopicEnable() {
        return this.DeleteTopicEnable;
    }

    public String CompressionType() {
        return this.CompressionType;
    }

    public int MetricNumSamples() {
        return this.MetricNumSamples;
    }

    public int MetricSampleWindowMs() {
        return this.MetricSampleWindowMs;
    }

    public String MetricReporterClasses() {
        return this.MetricReporterClasses;
    }

    public String PrincipalBuilderClass() {
        return this.PrincipalBuilderClass;
    }

    public String SslProtocol() {
        return this.SslProtocol;
    }

    public String SslEnabledProtocols() {
        return this.SslEnabledProtocols;
    }

    public String SslKeystoreType() {
        return this.SslKeystoreType;
    }

    public String SslTruststoreType() {
        return this.SslTruststoreType;
    }

    public String SslKeyManagerAlgorithm() {
        return this.SslKeyManagerAlgorithm;
    }

    public String SslTrustManagerAlgorithm() {
        return this.SslTrustManagerAlgorithm;
    }

    public String SslClientAuthRequired() {
        return this.SslClientAuthRequired;
    }

    public String SslClientAuthRequested() {
        return this.SslClientAuthRequested;
    }

    public String SslClientAuthNone() {
        return this.SslClientAuthNone;
    }

    public String SslClientAuth() {
        return this.SslClientAuth;
    }

    public String SaslKerberosKinitCmd() {
        return this.SaslKerberosKinitCmd;
    }

    public double SaslKerberosTicketRenewWindowFactor() {
        return this.SaslKerberosTicketRenewWindowFactor;
    }

    public double SaslKerberosTicketRenewJitter() {
        return this.SaslKerberosTicketRenewJitter;
    }

    public long SaslKerberosMinTimeBeforeRelogin() {
        return this.SaslKerberosMinTimeBeforeRelogin;
    }

    public List<String> SaslKerberosPrincipalToLocalRules() {
        return this.SaslKerberosPrincipalToLocalRules;
    }

    private Defaults$() {
        MODULE$ = this;
        this.ZkSessionTimeoutMs = 6000;
        this.ZkSyncTimeMs = 2000;
        this.ZkEnableSecureAcls = false;
        this.MaxReservedBrokerId = 1000;
        this.BrokerId = -1;
        this.MessageMaxBytes = 1000000 + MessageSet$.MODULE$.LogOverhead();
        this.NumNetworkThreads = 3;
        this.NumIoThreads = 8;
        this.BackgroundThreads = 10;
        this.QueuedMaxRequests = 500;
        this.AuthorizerClassName = "";
        this.Port = 9092;
        this.HostName = new String("");
        this.SocketSendBufferBytes = 102400;
        this.SocketReceiveBufferBytes = 102400;
        this.SocketRequestMaxBytes = 0x6400000;
        this.MaxConnectionsPerIp = Integer.MAX_VALUE;
        this.MaxConnectionsPerIpOverrides = "";
        this.ConnectionsMaxIdleMs = 600000L;
        this.RequestTimeoutMs = 30000;
        this.NumPartitions = 1;
        this.LogDir = "/tmp/kafka-logs";
        this.LogSegmentBytes = 0x40000000;
        this.LogRollHours = 168;
        this.LogRollJitterHours = 0;
        this.LogRetentionHours = 168;
        this.LogRetentionBytes = -1L;
        this.LogCleanupIntervalMs = 300000L;
        this.Delete = "delete";
        this.Compact = "compact";
        this.LogCleanupPolicy = this.Delete();
        this.LogCleanerThreads = 1;
        this.LogCleanerIoMaxBytesPerSecond = Double.MAX_VALUE;
        this.LogCleanerDedupeBufferSize = 524288000L;
        this.LogCleanerIoBufferSize = 524288;
        this.LogCleanerDedupeBufferLoadFactor = 0.9;
        this.LogCleanerBackoffMs = 15000;
        this.LogCleanerMinCleanRatio = 0.5;
        this.LogCleanerEnable = false;
        this.LogCleanerDeleteRetentionMs = 86400000L;
        this.LogIndexSizeMaxBytes = 0xA00000;
        this.LogIndexIntervalBytes = 4096;
        this.LogFlushIntervalMessages = Long.MAX_VALUE;
        this.LogDeleteDelayMs = 60000;
        this.LogFlushSchedulerIntervalMs = Long.MAX_VALUE;
        this.LogFlushOffsetCheckpointIntervalMs = 60000;
        this.LogPreAllocateEnable = false;
        this.NumRecoveryThreadsPerDataDir = 1;
        this.AutoCreateTopicsEnable = true;
        this.MinInSyncReplicas = 1;
        this.ControllerSocketTimeoutMs = this.RequestTimeoutMs();
        this.ControllerMessageQueueSize = Integer.MAX_VALUE;
        this.DefaultReplicationFactor = 1;
        this.ReplicaLagTimeMaxMs = 10000L;
        this.ReplicaSocketTimeoutMs = ConsumerConfig$.MODULE$.SocketTimeout();
        this.ReplicaSocketReceiveBufferBytes = ConsumerConfig$.MODULE$.SocketBufferSize();
        this.ReplicaFetchMaxBytes = ConsumerConfig$.MODULE$.FetchSize();
        this.ReplicaFetchWaitMaxMs = 500;
        this.ReplicaFetchMinBytes = 1;
        this.NumReplicaFetchers = 1;
        this.ReplicaFetchBackoffMs = 1000;
        this.ReplicaHighWatermarkCheckpointIntervalMs = 5000L;
        this.FetchPurgatoryPurgeIntervalRequests = 1000;
        this.ProducerPurgatoryPurgeIntervalRequests = 1000;
        this.AutoLeaderRebalanceEnable = true;
        this.LeaderImbalancePerBrokerPercentage = 10;
        this.LeaderImbalanceCheckIntervalSeconds = 300;
        this.UncleanLeaderElectionEnable = true;
        this.InterBrokerSecurityProtocol = SecurityProtocol.PLAINTEXT.toString();
        this.InterBrokerProtocolVersion = ApiVersion$.MODULE$.latestVersion().toString();
        this.ControlledShutdownMaxRetries = 3;
        this.ControlledShutdownRetryBackoffMs = 5000;
        this.ControlledShutdownEnable = true;
        this.ConsumerMinSessionTimeoutMs = 6000;
        this.ConsumerMaxSessionTimeoutMs = 30000;
        this.OffsetMetadataMaxSize = OffsetConfig$.MODULE$.DefaultMaxMetadataSize();
        this.OffsetsLoadBufferSize = OffsetConfig$.MODULE$.DefaultLoadBufferSize();
        this.OffsetsTopicReplicationFactor = OffsetConfig$.MODULE$.DefaultOffsetsTopicReplicationFactor();
        this.OffsetsTopicPartitions = OffsetConfig$.MODULE$.DefaultOffsetsTopicNumPartitions();
        this.OffsetsTopicSegmentBytes = OffsetConfig$.MODULE$.DefaultOffsetsTopicSegmentBytes();
        this.OffsetsTopicCompressionCodec = OffsetConfig$.MODULE$.DefaultOffsetsTopicCompressionCodec().codec();
        this.OffsetsRetentionMinutes = 1440;
        this.OffsetsRetentionCheckIntervalMs = OffsetConfig$.MODULE$.DefaultOffsetsRetentionCheckIntervalMs();
        this.OffsetCommitTimeoutMs = OffsetConfig$.MODULE$.DefaultOffsetCommitTimeoutMs();
        this.OffsetCommitRequiredAcks = OffsetConfig$.MODULE$.DefaultOffsetCommitRequiredAcks();
        this.ProducerQuotaBytesPerSecondDefault = ClientQuotaManagerConfig$.MODULE$.QuotaBytesPerSecondDefault();
        this.ConsumerQuotaBytesPerSecondDefault = ClientQuotaManagerConfig$.MODULE$.QuotaBytesPerSecondDefault();
        this.NumQuotaSamples = ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        this.QuotaWindowSizeSeconds = ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        this.DeleteTopicEnable = false;
        this.CompressionType = "producer";
        this.MetricNumSamples = 2;
        this.MetricSampleWindowMs = 30000;
        this.MetricReporterClasses = "";
        this.PrincipalBuilderClass = "org.apache.kafka.common.security.auth.DefaultPrincipalBuilder";
        this.SslProtocol = "TLS";
        this.SslEnabledProtocols = "TLSv1.2,TLSv1.1,TLSv1";
        this.SslKeystoreType = "JKS";
        this.SslTruststoreType = "JKS";
        this.SslKeyManagerAlgorithm = SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM;
        this.SslTrustManagerAlgorithm = SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM;
        this.SslClientAuthRequired = "required";
        this.SslClientAuthRequested = "requested";
        this.SslClientAuthNone = "none";
        this.SslClientAuth = this.SslClientAuthNone();
        this.SaslKerberosKinitCmd = "/usr/bin/kinit";
        this.SaslKerberosTicketRenewWindowFactor = 0.8;
        this.SaslKerberosTicketRenewJitter = 0.05;
        this.SaslKerberosMinTimeBeforeRelogin = 60000L;
        this.SaslKerberosPrincipalToLocalRules = SaslConfigs.DEFAULT_SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES;
    }
}

