/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.intervals.IntervalFunction;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalsSource;

class ConjunctionIntervalsSource
extends IntervalsSource {
    final List<IntervalsSource> subSources;
    final IntervalFunction function;

    ConjunctionIntervalsSource(List<IntervalsSource> subSources, IntervalFunction function) {
        this.subSources = subSources;
        this.function = function;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConjunctionIntervalsSource that = (ConjunctionIntervalsSource)o;
        return Objects.equals(this.subSources, that.subSources) && Objects.equals(this.function, that.function);
    }

    @Override
    public String toString() {
        return this.function + this.subSources.stream().map(Object::toString).collect(Collectors.joining(",", "(", ")"));
    }

    @Override
    public void extractTerms(String field, Set<Term> terms) {
        for (IntervalsSource source : this.subSources) {
            source.extractTerms(field, terms);
        }
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> subIntervals = new ArrayList<IntervalIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalIterator it = source.intervals(field, ctx);
            if (it == null) {
                return null;
            }
            subIntervals.add(it);
        }
        return this.function.apply(subIntervals);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subSources, this.function);
    }
}

