/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractDeployMojo
extends AbstractMojo {
    @Parameter(defaultValue="${settings.offline}", readonly=true)
    private boolean offline;
    @Parameter(property="retryFailedDeploymentCount", defaultValue="1")
    private int retryFailedDeploymentCount;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;

    void failIfOffline() throws MojoFailureException {
        if (this.offline) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
    }

    int getRetryFailedDeploymentCount() {
        return this.retryFailedDeploymentCount;
    }

    protected ArtifactRepository createDeploymentArtifactRepository(String id, String url) {
        return new MavenArtifactRepository(id, url, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy());
    }

    protected final MavenSession getSession() {
        return this.session;
    }
}

