/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.primitive;

import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.Removal;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.StackManipulation;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.Assigner;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.constant.DefaultValue;

public class VoidAwareAssigner
implements Assigner {
    private final Assigner chained;

    public VoidAwareAssigner(Assigner chained) {
        this.chained = chained;
    }

    @Override
    public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Assigner.Typing typing) {
        if (source.represents(Void.TYPE) && target.represents(Void.TYPE)) {
            return StackManipulation.Trivial.INSTANCE;
        }
        if (source.represents(Void.TYPE)) {
            return typing.isDynamic() ? DefaultValue.of(target) : StackManipulation.Illegal.INSTANCE;
        }
        if (target.represents(Void.TYPE)) {
            return Removal.of(source);
        }
        return this.chained.assign(source, target, typing);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoidAwareAssigner)) {
            return false;
        }
        VoidAwareAssigner other = (VoidAwareAssigner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Assigner this$chained = this.chained;
        Assigner other$chained = other.chained;
        return !(this$chained == null ? other$chained != null : !this$chained.equals(other$chained));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VoidAwareAssigner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Assigner $chained = this.chained;
        result = result * 59 + ($chained == null ? 43 : $chained.hashCode());
        return result;
    }
}

