/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import net.sf.clirr.core.ClassFilter;
import org.apache.bcel.classfile.JavaClass;
import org.codehaus.plexus.util.SelectorUtils;

public class ClirrClassFilter
implements ClassFilter {
    private final String[] excludes;
    private final String[] includes;
    private boolean alwaysTrue;

    public ClirrClassFilter(String[] includes, String[] excludes) {
        this.excludes = excludes == null || excludes.length == 0 ? null : (String[])excludes.clone();
        if (includes == null || includes.length == 0) {
            this.includes = new String[]{"**"};
            if (excludes == null) {
                this.alwaysTrue = true;
            }
        } else {
            this.includes = (String[])includes.clone();
        }
    }

    public boolean isSelected(JavaClass javaClass) {
        boolean result = false;
        if (this.alwaysTrue) {
            result = true;
        } else {
            int i;
            String path = javaClass.getClassName().replace('.', '/');
            for (i = 0; i < this.includes.length && !result; ++i) {
                result = SelectorUtils.matchPath((String)this.includes[i], (String)path);
            }
            if (this.excludes != null) {
                for (i = 0; i < this.excludes.length && result; ++i) {
                    result = !SelectorUtils.matchPath((String)this.excludes[i], (String)path);
                }
            }
        }
        return result;
    }
}

