/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class WKTWriter {
    private static final int INDENT = 2;
    private int outputDimension = 2;
    private DecimalFormat formatter;
    private boolean isFormatted = false;
    private boolean useFormatting = false;
    private int level = 0;
    private int coordsPerLine = -1;
    private String indentTabStr = "  ";

    public static String toPoint(Coordinate p0) {
        return "POINT ( " + p0.x + " " + p0.y + " )";
    }

    public static String toLineString(CoordinateSequence seq) {
        StringBuffer buf = new StringBuffer();
        buf.append("LINESTRING ");
        if (seq.size() == 0) {
            buf.append(" EMPTY");
        } else {
            buf.append("(");
            for (int i = 0; i < seq.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(seq.getX(i) + " " + seq.getY(i));
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String toLineString(Coordinate[] coord) {
        StringBuffer buf = new StringBuffer();
        buf.append("LINESTRING ");
        if (coord.length == 0) {
            buf.append(" EMPTY");
        } else {
            buf.append("(");
            for (int i = 0; i < coord.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(coord[i].x + " " + coord[i].y);
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String toLineString(Coordinate p0, Coordinate p1) {
        return "LINESTRING ( " + p0.x + " " + p0.y + ", " + p1.x + " " + p1.y + " )";
    }

    private static DecimalFormat createFormatter(PrecisionModel precisionModel) {
        int decimalPlaces = precisionModel.getMaximumSignificantDigits();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        String fmtString = "0" + (decimalPlaces > 0 ? "." : "") + WKTWriter.stringOfChar('#', decimalPlaces);
        return new DecimalFormat(fmtString, symbols);
    }

    public static String stringOfChar(char ch, int count) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public WKTWriter() {
    }

    public WKTWriter(int outputDimension) {
        this.outputDimension = outputDimension;
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Invalid output dimension (must be 2 or 3)");
        }
    }

    public void setFormatted(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    public void setMaxCoordinatesPerLine(int coordsPerLine) {
        this.coordsPerLine = coordsPerLine;
    }

    public void setTab(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Tab count must be positive");
        }
        this.indentTabStr = WKTWriter.stringOfChar(' ', size);
    }

    public String write(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geometry, this.isFormatted, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    public void write(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, false, writer);
    }

    public String writeFormatted(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geometry, true, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    public void writeFormatted(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, true, writer);
    }

    private void writeFormatted(Geometry geometry, boolean useFormatting, Writer writer) throws IOException {
        this.useFormatting = useFormatting;
        this.formatter = WKTWriter.createFormatter(geometry.getPrecisionModel());
        this.appendGeometryTaggedText(geometry, 0, writer);
    }

    private void appendGeometryTaggedText(Geometry geometry, int level, Writer writer) throws IOException {
        this.indent(level, writer);
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            this.appendPointTaggedText(point.getCoordinate(), level, writer, point.getPrecisionModel());
        } else if (geometry instanceof LinearRing) {
            this.appendLinearRingTaggedText((LinearRing)geometry, level, writer);
        } else if (geometry instanceof LineString) {
            this.appendLineStringTaggedText((LineString)geometry, level, writer);
        } else if (geometry instanceof Polygon) {
            this.appendPolygonTaggedText((Polygon)geometry, level, writer);
        } else if (geometry instanceof MultiPoint) {
            this.appendMultiPointTaggedText((MultiPoint)geometry, level, writer);
        } else if (geometry instanceof MultiLineString) {
            this.appendMultiLineStringTaggedText((MultiLineString)geometry, level, writer);
        } else if (geometry instanceof MultiPolygon) {
            this.appendMultiPolygonTaggedText((MultiPolygon)geometry, level, writer);
        } else if (geometry instanceof GeometryCollection) {
            this.appendGeometryCollectionTaggedText((GeometryCollection)geometry, level, writer);
        } else {
            Assert.shouldNeverReachHere("Unsupported Geometry implementation:" + geometry.getClass());
        }
    }

    private void appendPointTaggedText(Coordinate coordinate, int level, Writer writer, PrecisionModel precisionModel) throws IOException {
        writer.write("POINT ");
        this.appendPointText(coordinate, level, writer, precisionModel);
    }

    private void appendLineStringTaggedText(LineString lineString, int level, Writer writer) throws IOException {
        writer.write("LINESTRING ");
        this.appendLineStringText(lineString, level, false, writer);
    }

    private void appendLinearRingTaggedText(LinearRing linearRing, int level, Writer writer) throws IOException {
        writer.write("LINEARRING ");
        this.appendLineStringText(linearRing, level, false, writer);
    }

    private void appendPolygonTaggedText(Polygon polygon, int level, Writer writer) throws IOException {
        writer.write("POLYGON ");
        this.appendPolygonText(polygon, level, false, writer);
    }

    private void appendMultiPointTaggedText(MultiPoint multipoint, int level, Writer writer) throws IOException {
        writer.write("MULTIPOINT ");
        this.appendMultiPointText(multipoint, level, writer);
    }

    private void appendMultiLineStringTaggedText(MultiLineString multiLineString, int level, Writer writer) throws IOException {
        writer.write("MULTILINESTRING ");
        this.appendMultiLineStringText(multiLineString, level, false, writer);
    }

    private void appendMultiPolygonTaggedText(MultiPolygon multiPolygon, int level, Writer writer) throws IOException {
        writer.write("MULTIPOLYGON ");
        this.appendMultiPolygonText(multiPolygon, level, writer);
    }

    private void appendGeometryCollectionTaggedText(GeometryCollection geometryCollection, int level, Writer writer) throws IOException {
        writer.write("GEOMETRYCOLLECTION ");
        this.appendGeometryCollectionText(geometryCollection, level, writer);
    }

    private void appendPointText(Coordinate coordinate, int level, Writer writer, PrecisionModel precisionModel) throws IOException {
        if (coordinate == null) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            this.appendCoordinate(coordinate, writer);
            writer.write(")");
        }
    }

    private void appendCoordinate(CoordinateSequence seq, int i, Writer writer) throws IOException {
        double z;
        writer.write(this.writeNumber(seq.getX(i)) + " " + this.writeNumber(seq.getY(i)));
        if (this.outputDimension >= 3 && seq.getDimension() >= 3 && !Double.isNaN(z = seq.getOrdinate(i, 3))) {
            writer.write(" ");
            writer.write(this.writeNumber(z));
        }
    }

    private void appendCoordinate(Coordinate coordinate, Writer writer) throws IOException {
        writer.write(this.writeNumber(coordinate.x) + " " + this.writeNumber(coordinate.y));
        if (this.outputDimension >= 3 && !Double.isNaN(coordinate.z)) {
            writer.write(" ");
            writer.write(this.writeNumber(coordinate.z));
        }
    }

    private String writeNumber(double d) {
        return this.formatter.format(d);
    }

    private void appendSequenceText(CoordinateSequence seq, int level, boolean doIndent, Writer writer) throws IOException {
        if (seq.size() == 0) {
            writer.write("EMPTY");
        } else {
            if (doIndent) {
                this.indent(level, writer);
            }
            writer.write("(");
            for (int i = 0; i < seq.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    if (this.coordsPerLine > 0 && i % this.coordsPerLine == 0) {
                        this.indent(level + 1, writer);
                    }
                }
                this.appendCoordinate(seq, i, writer);
            }
            writer.write(")");
        }
    }

    private void appendLineStringText(LineString lineString, int level, boolean doIndent, Writer writer) throws IOException {
        if (lineString.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (doIndent) {
                this.indent(level, writer);
            }
            writer.write("(");
            for (int i = 0; i < lineString.getNumPoints(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    if (this.coordsPerLine > 0 && i % this.coordsPerLine == 0) {
                        this.indent(level + 1, writer);
                    }
                }
                this.appendCoordinate(lineString.getCoordinateN(i), writer);
            }
            writer.write(")");
        }
    }

    private void appendPolygonText(Polygon polygon, int level, boolean indentFirst, Writer writer) throws IOException {
        if (polygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (indentFirst) {
                this.indent(level, writer);
            }
            writer.write("(");
            this.appendLineStringText(polygon.getExteriorRing(), level, false, writer);
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                writer.write(", ");
                this.appendLineStringText(polygon.getInteriorRingN(i), level + 1, true, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiPointText(MultiPoint multiPoint, int level, Writer writer) throws IOException {
        if (multiPoint.isEmpty()) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    this.indentCoords(i, level + 1, writer);
                }
                writer.write("(");
                this.appendCoordinate(((Point)multiPoint.getGeometryN(i)).getCoordinate(), writer);
                writer.write(")");
            }
            writer.write(")");
        }
    }

    private void appendMultiLineStringText(MultiLineString multiLineString, int level, boolean indentFirst, Writer writer) throws IOException {
        if (multiLineString.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = indentFirst;
            writer.write("(");
            for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                this.appendLineStringText((LineString)multiLineString.getGeometryN(i), level2, doIndent, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiPolygonText(MultiPolygon multiPolygon, int level, Writer writer) throws IOException {
        if (multiPolygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = false;
            writer.write("(");
            for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                this.appendPolygonText((Polygon)multiPolygon.getGeometryN(i), level2, doIndent, writer);
            }
            writer.write(")");
        }
    }

    private void appendGeometryCollectionText(GeometryCollection geometryCollection, int level, Writer writer) throws IOException {
        if (geometryCollection.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            writer.write("(");
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                }
                this.appendGeometryTaggedText(geometryCollection.getGeometryN(i), level2, writer);
            }
            writer.write(")");
        }
    }

    private void indentCoords(int coordIndex, int level, Writer writer) throws IOException {
        if (this.coordsPerLine <= 0 || coordIndex % this.coordsPerLine != 0) {
            return;
        }
        this.indent(level, writer);
    }

    private void indent(int level, Writer writer) throws IOException {
        if (!this.useFormatting || level <= 0) {
            return;
        }
        writer.write("\n");
        for (int i = 0; i < level; ++i) {
            writer.write(this.indentTabStr);
        }
    }
}

