/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.index.strtree.ItemDistance;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.distance.FacetSequence;
import com.vividsolutions.jts.operation.distance.FacetSequenceTreeBuilder;

public class MinimumClearance {
    private Geometry inputGeom;
    private double minClearance;
    private Coordinate[] minClearancePts;

    public static double getDistance(Geometry g) {
        MinimumClearance rp = new MinimumClearance(g);
        return rp.getDistance();
    }

    public static Geometry getLine(Geometry g) {
        MinimumClearance rp = new MinimumClearance(g);
        return rp.getLine();
    }

    public MinimumClearance(Geometry geom) {
        this.inputGeom = geom;
    }

    public double getDistance() {
        this.compute();
        return this.minClearance;
    }

    public LineString getLine() {
        this.compute();
        if (this.minClearancePts == null || this.minClearancePts[0] == null) {
            return this.inputGeom.getFactory().createLineString((Coordinate[])null);
        }
        return this.inputGeom.getFactory().createLineString(this.minClearancePts);
    }

    private void compute() {
        if (this.minClearancePts != null) {
            return;
        }
        this.minClearancePts = new Coordinate[2];
        this.minClearance = Double.MAX_VALUE;
        if (this.inputGeom.isEmpty()) {
            return;
        }
        STRtree geomTree = FacetSequenceTreeBuilder.build(this.inputGeom);
        Object[] nearest = geomTree.nearestNeighbour(new MinClearanceDistance());
        MinClearanceDistance mcd = new MinClearanceDistance();
        this.minClearance = mcd.distance((FacetSequence)nearest[0], (FacetSequence)nearest[1]);
        this.minClearancePts = mcd.getCoordinates();
    }

    private static class MinClearanceDistance
    implements ItemDistance {
        private double minDist = Double.MAX_VALUE;
        private Coordinate[] minPts = new Coordinate[2];

        private MinClearanceDistance() {
        }

        public Coordinate[] getCoordinates() {
            return this.minPts;
        }

        @Override
        public double distance(ItemBoundable b1, ItemBoundable b2) {
            FacetSequence fs1 = (FacetSequence)b1.getItem();
            FacetSequence fs2 = (FacetSequence)b2.getItem();
            this.minDist = Double.MAX_VALUE;
            return this.distance(fs1, fs2);
        }

        public double distance(FacetSequence fs1, FacetSequence fs2) {
            this.vertexDistance(fs1, fs2);
            if (fs1.size() == 1 && fs2.size() == 1) {
                return this.minDist;
            }
            if (this.minDist <= 0.0) {
                return this.minDist;
            }
            this.segmentDistance(fs1, fs2);
            if (this.minDist <= 0.0) {
                return this.minDist;
            }
            this.segmentDistance(fs2, fs1);
            return this.minDist;
        }

        private double vertexDistance(FacetSequence fs1, FacetSequence fs2) {
            for (int i1 = 0; i1 < fs1.size(); ++i1) {
                for (int i2 = 0; i2 < fs2.size(); ++i2) {
                    double d;
                    Coordinate p2;
                    Coordinate p1 = fs1.getCoordinate(i1);
                    if (p1.equals2D(p2 = fs2.getCoordinate(i2)) || !((d = p1.distance(p2)) < this.minDist)) continue;
                    this.minDist = d;
                    this.minPts[0] = p1;
                    this.minPts[1] = p2;
                    if (d != 0.0) continue;
                    return d;
                }
            }
            return this.minDist;
        }

        private double segmentDistance(FacetSequence fs1, FacetSequence fs2) {
            for (int i1 = 0; i1 < fs1.size(); ++i1) {
                for (int i2 = 1; i2 < fs2.size(); ++i2) {
                    double d;
                    Coordinate p = fs1.getCoordinate(i1);
                    Coordinate seg0 = fs2.getCoordinate(i2 - 1);
                    Coordinate seg1 = fs2.getCoordinate(i2);
                    if (p.equals2D(seg0) || p.equals2D(seg1) || !((d = CGAlgorithms.distancePointLine(p, seg0, seg1)) < this.minDist)) continue;
                    this.minDist = d;
                    this.updatePts(p, seg0, seg1);
                    if (d != 0.0) continue;
                    return d;
                }
            }
            return this.minDist;
        }

        private void updatePts(Coordinate p, Coordinate seg0, Coordinate seg1) {
            this.minPts[0] = p;
            LineSegment seg = new LineSegment(seg0, seg1);
            this.minPts[1] = new Coordinate(seg.closestPoint(p));
        }
    }
}

