/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.formatMapper.FormatMapper;
import org.wololo.geojson.Feature;
import org.wololo.geojson.GeoJSONFactory;
import org.wololo.jts2geojson.GeoJSONReader;

public class LineStringFormatMapper
extends FormatMapper
implements FlatMapFunction<Iterator<String>, Object> {
    public LineStringFormatMapper(FileDataSplitter Splitter, boolean carryInputData) {
        super(Splitter, carryInputData);
    }

    public LineStringFormatMapper(Integer startOffset, Integer endOffset, FileDataSplitter Splitter, boolean carryInputData) {
        super(startOffset, endOffset, Splitter, carryInputData);
    }

    public Iterator<Object> call(Iterator<String> stringIterator) throws Exception {
        ArrayList<LineString> result = new ArrayList<LineString>();
        MultiLineString multiSpatialObjects = null;
        block8: while (stringIterator.hasNext()) {
            String line = stringIterator.next();
            try {
                switch (this.splitter) {
                    case CSV: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        this.coordinatesList = new ArrayList();
                        int actualEndOffset = this.endOffset >= 0 ? this.endOffset : this.lineSplitList.size() - 1;
                        for (int i = this.startOffset.intValue(); i <= actualEndOffset; i += 2) {
                            this.coordinatesList.add(new Coordinate(Double.parseDouble((String)this.lineSplitList.get(i)), Double.parseDouble((String)this.lineSplitList.get(i + 1))));
                        }
                        this.spatialObject = this.fact.createLineString(this.coordinatesList.toArray(new Coordinate[this.coordinatesList.size()]));
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((LineString)this.spatialObject);
                        break;
                    }
                    case TSV: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        this.coordinatesList = new ArrayList();
                        int actualEndOffset = this.endOffset >= 0 ? this.endOffset : this.lineSplitList.size() - 1;
                        for (int i = this.startOffset.intValue(); i <= actualEndOffset; i += 2) {
                            this.coordinatesList.add(new Coordinate(Double.parseDouble((String)this.lineSplitList.get(i)), Double.parseDouble((String)this.lineSplitList.get(i + 1))));
                        }
                        this.spatialObject = this.fact.createLineString(this.coordinatesList.toArray(new Coordinate[this.coordinatesList.size()]));
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((LineString)this.spatialObject);
                        break;
                    }
                    case GEOJSON: {
                        GeoJSONReader reader = new GeoJSONReader();
                        this.spatialObject = reader.read(line);
                        if (line.contains("Feature")) {
                            Feature feature = (Feature)GeoJSONFactory.create(line);
                            this.spatialObject = reader.read(feature.getGeometry());
                        } else {
                            this.spatialObject = reader.read(line);
                        }
                        if (this.spatialObject instanceof MultiLineString) {
                            multiSpatialObjects = (MultiLineString)this.spatialObject;
                            for (int i = 0; i < multiSpatialObjects.getNumGeometries(); ++i) {
                                this.spatialObject = multiSpatialObjects.getGeometryN(i);
                                if (this.carryInputData) {
                                    this.spatialObject.setUserData(line);
                                }
                                result.add((LineString)this.spatialObject);
                            }
                            continue block8;
                        }
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((LineString)this.spatialObject);
                        break;
                    }
                    case WKT: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        WKTReader wktreader = new WKTReader();
                        this.spatialObject = wktreader.read((String)this.lineSplitList.get(this.startOffset));
                        if (this.spatialObject instanceof MultiLineString) {
                            multiSpatialObjects = (MultiLineString)this.spatialObject;
                            for (int i = 0; i < multiSpatialObjects.getNumGeometries(); ++i) {
                                this.spatialObject = multiSpatialObjects.getGeometryN(i);
                                if (this.carryInputData) {
                                    this.spatialObject.setUserData(line);
                                }
                                result.add((LineString)this.spatialObject);
                            }
                            continue block8;
                        }
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((LineString)this.spatialObject);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result.iterator();
    }
}

