/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.dbf;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.EndianUtils;
import org.apache.hadoop.io.Text;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.dbf.FieldDescriptor;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeFileConst;

public class DbfParseUtil
implements ShapeFileConst {
    public int numRecord = 0;
    public int numBytesRecord = 0;
    public int numRecordRead;
    public static List<FieldDescriptor> fieldDescriptors = null;

    public boolean isDone() {
        return this.numRecordRead >= this.numRecord;
    }

    public float getProgress() {
        return (float)this.numRecordRead / (float)this.numRecord;
    }

    public void parseFileHead(DataInputStream inputStream) throws IOException {
        inputStream.readByte();
        byte[] date = new byte[3];
        inputStream.readFully(date);
        this.numRecord = EndianUtils.swapInteger((int)inputStream.readInt());
        short numBytes = EndianUtils.swapShort((short)inputStream.readShort());
        this.numBytesRecord = EndianUtils.swapShort((short)inputStream.readShort());
        inputStream.skipBytes(2);
        inputStream.skipBytes(1);
        inputStream.skipBytes(1);
        inputStream.skipBytes(12);
        inputStream.skipBytes(1);
        inputStream.skipBytes(1);
        inputStream.skipBytes(2);
        fieldDescriptors = new ArrayList<FieldDescriptor>();
        byte terminator = inputStream.readByte();
        while (terminator != 13) {
            FieldDescriptor descriptor = new FieldDescriptor();
            byte[] nameBytes = new byte[11];
            nameBytes[0] = terminator;
            inputStream.readFully(nameBytes, 1, 10);
            int zeroId = 0;
            while (nameBytes[zeroId] != 0) {
                ++zeroId;
            }
            Text fieldName = new Text();
            fieldName.append(nameBytes, 0, zeroId);
            descriptor.setFiledName(fieldName.toString());
            descriptor.setFieldType(inputStream.readByte());
            inputStream.readInt();
            descriptor.setFieldLength(inputStream.readUnsignedByte());
            descriptor.setFieldDecimalCount(inputStream.readByte());
            inputStream.skipBytes(14);
            fieldDescriptors.add(descriptor);
            terminator = inputStream.readByte();
        }
    }

    public byte[] parsePrimitiveRecord(DataInputStream inputStream) throws IOException {
        if (this.isDone()) {
            return null;
        }
        byte flag = inputStream.readByte();
        int recordLength = this.numBytesRecord - 1;
        while (flag == 42) {
            inputStream.skipBytes(recordLength);
            ++this.numRecordRead;
            flag = inputStream.readByte();
        }
        if (flag == 26) {
            return null;
        }
        byte[] primitiveBytes = new byte[recordLength];
        inputStream.readFully(primitiveBytes);
        ++this.numRecordRead;
        return primitiveBytes;
    }

    public static String primitiveToAttributes(DataInputStream inputStream) throws IOException {
        byte[] delimiter = new byte[]{9};
        Text attributes = new Text();
        for (FieldDescriptor descriptor : fieldDescriptors) {
            byte[] fldBytes = new byte[descriptor.getFieldLength()];
            inputStream.readFully(fldBytes);
            attributes.append(fldBytes, 0, fldBytes.length);
            attributes.append(delimiter, 0, 1);
        }
        return attributes.toString();
    }
}

