/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.shapes;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.BytesWritable;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.dbf.DbfParseUtil;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ByteBufferReader;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeType;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.TypeUnknownException;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShpRecord;

public class PrimitiveShape
implements Serializable {
    private BytesWritable primitiveRecord = null;
    private BytesWritable primitiveAttribute = null;
    ShapeType shapeType = ShapeType.NULL;

    public BytesWritable getPrimitiveRecord() {
        return this.primitiveRecord;
    }

    public void setPrimitiveRecord(ShpRecord shpRecord) {
        this.primitiveRecord = shpRecord.getBytes();
        this.shapeType = ShapeType.getType(shpRecord.getTypeID());
    }

    public BytesWritable getPrimitiveAttribute() {
        return this.primitiveAttribute;
    }

    public void setPrimitiveAttribute(BytesWritable primitiveAttribute) {
        this.primitiveAttribute = primitiveAttribute;
    }

    public String generateAttributes() {
        String attrStr = "";
        if (this.primitiveAttribute != null) {
            try {
                DataInputStream dbfInputStream = new DataInputStream(new ByteArrayInputStream(this.primitiveAttribute.getBytes()));
                attrStr = DbfParseUtil.primitiveToAttributes(dbfInputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return attrStr;
    }

    public Geometry getShape(GeometryFactory geometryFactory) throws IOException, TypeUnknownException {
        ShapeParser parser = null;
        parser = this.shapeType.getParser(geometryFactory);
        if (parser == null) {
            throw new TypeUnknownException(this.shapeType.getId());
        }
        ByteBufferReader reader = new ByteBufferReader(this.primitiveRecord.getBytes(), false);
        Geometry shape = parser.parserShape(reader);
        if (this.primitiveAttribute != null) {
            String attributes = this.generateAttributes();
            shape.setUserData(attributes);
        }
        return shape;
    }
}

