/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.geometryObjects;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;

public class Circle
extends Geometry {
    private Geometry centerGeometry;
    private Coordinate centerPoint;
    private Double radius;
    private Envelope MBR;

    public Geometry getCenterGeometry() {
        return this.centerGeometry;
    }

    public Circle(Geometry centerGeometry, Double givenRadius) {
        super(new GeometryFactory(centerGeometry.getPrecisionModel()));
        this.centerGeometry = centerGeometry;
        Envelope centerGeometryMBR = this.centerGeometry.getEnvelopeInternal();
        this.centerPoint = new Coordinate((centerGeometryMBR.getMinX() + centerGeometryMBR.getMaxX()) / 2.0, (centerGeometryMBR.getMinY() + centerGeometryMBR.getMaxY()) / 2.0);
        double width = centerGeometryMBR.getMaxX() - centerGeometryMBR.getMinX();
        double length = centerGeometryMBR.getMaxY() - centerGeometryMBR.getMinY();
        double centerGeometryInternalRadius = Math.sqrt(width * width + length * length) / 2.0;
        this.radius = givenRadius > centerGeometryInternalRadius ? givenRadius : centerGeometryInternalRadius;
        this.MBR = new Envelope(this.centerPoint.x - this.radius, this.centerPoint.x + this.radius, this.centerPoint.y - this.radius, this.centerPoint.y + this.radius);
        this.setUserData(centerGeometry.getUserData());
    }

    public Coordinate getCenterPoint() {
        return this.centerPoint;
    }

    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double givenRadius) {
        Envelope centerGeometryMBR = this.centerGeometry.getEnvelopeInternal();
        double width = centerGeometryMBR.getMaxX() - centerGeometryMBR.getMinX();
        double length = centerGeometryMBR.getMaxY() - centerGeometryMBR.getMinY();
        double centerGeometryInternalRadius = Math.sqrt(width * width + length * length) / 2.0;
        this.radius = givenRadius > centerGeometryInternalRadius ? givenRadius : centerGeometryInternalRadius;
        this.MBR = new Envelope(this.centerPoint.x - this.radius, this.centerPoint.x + this.radius, this.centerPoint.y - this.radius, this.centerPoint.y + this.radius);
    }

    @Override
    public boolean covers(Geometry g) {
        if (!this.getEnvelopeInternal().covers(g.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return true;
        }
        double x1 = g.getEnvelopeInternal().getMinX();
        double x2 = g.getEnvelopeInternal().getMaxX();
        double y1 = g.getEnvelopeInternal().getMinY();
        double y2 = g.getEnvelopeInternal().getMaxY();
        return this.covers(x1, y1) && this.covers(x1, y2) && this.covers(x2, y2) && this.covers(x2, y1);
    }

    @Override
    public boolean intersects(Geometry g) {
        if (!this.getEnvelopeInternal().covers(g.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return true;
        }
        double x1 = g.getEnvelopeInternal().getMinX();
        double x2 = g.getEnvelopeInternal().getMaxX();
        double y1 = g.getEnvelopeInternal().getMinY();
        double y2 = g.getEnvelopeInternal().getMaxY();
        return this.covers(x1, y1) || this.covers(x1, y2) || this.covers(x2, y2) || this.covers(x2, y1);
    }

    public boolean covers(double x, double y) {
        double distance = Math.sqrt((x - this.centerPoint.x) * (x - this.centerPoint.x) + (y - this.centerPoint.y) * (y - this.centerPoint.y));
        return distance <= this.radius;
    }

    @Override
    public String getGeometryType() {
        return "Circle";
    }

    @Override
    public Coordinate getCoordinate() {
        return this.centerGeometry.getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.centerGeometry.getCoordinates();
    }

    @Override
    public int getNumPoints() {
        return this.centerGeometry.getNumPoints();
    }

    @Override
    public boolean isEmpty() {
        return this.centerGeometry.isEmpty();
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public Geometry getBoundary() {
        return this.getFactory().createGeometryCollection(null);
    }

    @Override
    public int getBoundaryDimension() {
        return 0;
    }

    @Override
    public Geometry reverse() {
        Geometry g = this.centerGeometry.reverse();
        Circle newCircle = new Circle(g, this.radius);
        return newCircle;
    }

    @Override
    public Object clone() {
        Geometry g = (Geometry)this.centerGeometry.clone();
        Circle cloneCircle = new Circle(g, this.radius);
        return cloneCircle;
    }

    @Override
    public boolean equalsExact(Geometry g, double tolerance) {
        String type1 = this.getGeometryType();
        String type2 = g.getGeometryType();
        double radius1 = this.radius;
        double radius2 = ((Circle)g).radius;
        if (type1 != type2) {
            return false;
        }
        if (radius1 != radius2) {
            return false;
        }
        return this.centerGeometry.equals(((Circle)g).centerGeometry);
    }

    @Override
    public void apply(CoordinateFilter filter) {
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
    }

    @Override
    public void apply(GeometryFilter filter) {
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
    }

    @Override
    public void normalize() {
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        return this.MBR;
    }

    @Override
    protected int compareToSameClass(Object other) {
        Envelope env = (Envelope)other;
        Envelope mbr = this.MBR;
        if (mbr.getMinX() < env.getMinX()) {
            return -1;
        }
        if (mbr.getMinX() > env.getMinX()) {
            return 1;
        }
        if (mbr.getMinY() < env.getMinY()) {
            return -1;
        }
        if (mbr.getMinY() > env.getMinY()) {
            return 1;
        }
        if (mbr.getMaxX() < env.getMaxX()) {
            return -1;
        }
        if (mbr.getMaxX() > env.getMaxX()) {
            return 1;
        }
        if (mbr.getMaxY() < env.getMaxY()) {
            return -1;
        }
        if (mbr.getMaxY() > env.getMaxY()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected int compareToSameClass(Object other, CoordinateSequenceComparator comp) {
        Envelope env = (Envelope)other;
        Envelope mbr = this.MBR;
        if (mbr.getMinX() < env.getMinX()) {
            return -1;
        }
        if (mbr.getMinX() > env.getMinX()) {
            return 1;
        }
        if (mbr.getMinY() < env.getMinY()) {
            return -1;
        }
        if (mbr.getMinY() > env.getMinY()) {
            return 1;
        }
        if (mbr.getMaxX() < env.getMaxX()) {
            return -1;
        }
        if (mbr.getMaxX() > env.getMaxX()) {
            return 1;
        }
        if (mbr.getMaxY() < env.getMaxY()) {
            return -1;
        }
        if (mbr.getMaxY() > env.getMaxY()) {
            return 1;
        }
        return 0;
    }
}

